/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

public class TrustLevel
implements Comparable<TrustLevel> {
    public final int major;
    public final int minor;

    public TrustLevel(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static TrustLevel of(String majorDotMinor) {
        int major = Integer.parseInt(majorDotMinor.substring(0, 1));
        int minor = Integer.parseInt(majorDotMinor.substring(2, 3));
        return new TrustLevel(major, minor);
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public static TrustLevel createDirect() {
        return new TrustLevel(4, 0);
    }

    public static TrustLevel createServer() {
        return new TrustLevel(3, 0);
    }

    public static TrustLevel createIndirect(int indirectTrustLevelMajor) {
        return new TrustLevel(2, indirectTrustLevelMajor);
    }

    public static TrustLevel createServerGroupV2() {
        return new TrustLevel(1, 0);
    }

    @Override
    public int compareTo(TrustLevel other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        return Integer.compare(this.minor, other.minor);
    }
}

