/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public abstract class ServerMethodForS3 {
    public static final byte OK = 0;
    public static final byte NOT_FOUND = 1;
    public static final byte INVALID_SIGNED_URL = 2;
    public static final byte GENERAL_ERROR = -1;
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_GET = "GET";
    public static final byte MALFORMED_URL = -128;
    public static final byte SERVER_CONNECTION_ERROR = -127;
    public static final byte IDENTITY_IS_NOT_ACTIVE = -114;
    private static final int BLOCK_SIZE = 32768;
    private SSLSocketFactory sslSocketFactory = null;
    private ServerMethodForS3ProgressListener progressListener = null;
    private long progressListenerIntervalMs;
    protected byte returnStatus;

    protected abstract String getUrl();

    protected abstract byte[] getDataToSend();

    protected abstract void handleReceivedData(byte[] var1);

    protected abstract String getMethod();

    protected abstract boolean isActiveIdentityRequired();

    public final void setProgressListener(long intervalMs, ServerMethodForS3ProgressListener progressListener) {
        this.progressListenerIntervalMs = intervalMs;
        this.progressListener = progressListener;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte execute(boolean ownedIdentityIsActive) {
        if (this.isActiveIdentityRequired() && !ownedIdentityIsActive) {
            this.returnStatus = (byte)-114;
            return this.returnStatus;
        }
        String url = this.getUrl();
        byte[] dataToSend = this.getDataToSend();
        String method = this.getMethod();
        try {
            String userAgentProperty;
            URL requestUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
            if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if ((userAgentProperty = System.getProperty("http.agent")) != null) {
                connection.setRequestProperty("User-Agent", userAgentProperty);
            }
            try {
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Cache-Control", "no-store");
                connection.setRequestMethod(method);
                if (METHOD_GET.equals(this.getMethod())) {
                    connection.setDoOutput(false);
                } else {
                    connection.setDoOutput(true);
                    connection.setFixedLengthStreamingMode(dataToSend.length);
                    try (OutputStream os = connection.getOutputStream();){
                        if (this.progressListener != null) {
                            long nextReport = System.currentTimeMillis() + this.progressListenerIntervalMs;
                            for (int offset = 0; offset < dataToSend.length; offset += 32768) {
                                if (System.currentTimeMillis() > nextReport) {
                                    this.progressListener.onProgress(offset);
                                    nextReport = System.currentTimeMillis() + this.progressListenerIntervalMs;
                                }
                                os.write(dataToSend, offset, Math.min(32768, dataToSend.length - offset));
                            }
                            this.progressListener.onProgress(dataToSend.length);
                        } else {
                            os.write(dataToSend);
                        }
                    }
                }
                int serverResponse = connection.getResponseCode();
                switch (serverResponse) {
                    case 200: {
                        this.returnStatus = 0;
                        if (!METHOD_GET.equals(this.getMethod())) return this.returnStatus;
                        try (InputStream is = connection.getInputStream();
                             BufferedInputStream bis = new BufferedInputStream(is);
                             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                            byte[] buffer = new byte[32768];
                            if (this.progressListener != null) {
                                int numberOfBytesRead;
                                long nextReport = System.currentTimeMillis() + this.progressListenerIntervalMs;
                                int progress = 0;
                                while ((numberOfBytesRead = bis.read(buffer)) != -1) {
                                    byteArrayOutputStream.write(buffer, 0, numberOfBytesRead);
                                    progress += numberOfBytesRead;
                                    if (System.currentTimeMillis() <= nextReport) continue;
                                    this.progressListener.onProgress(progress);
                                    nextReport = System.currentTimeMillis() + this.progressListenerIntervalMs;
                                }
                                this.progressListener.onProgress(progress);
                            } else {
                                int numberOfBytesRead;
                                while ((numberOfBytesRead = bis.read(buffer)) != -1) {
                                    byteArrayOutputStream.write(buffer, 0, numberOfBytesRead);
                                }
                            }
                            byteArrayOutputStream.flush();
                            byte[] responseData = byteArrayOutputStream.toByteArray();
                            this.handleReceivedData(responseData);
                            return this.returnStatus;
                        }
                    }
                    case 403: {
                        this.returnStatus = (byte)2;
                        return this.returnStatus;
                    }
                    case 404: {
                        this.returnStatus = 1;
                        return this.returnStatus;
                    }
                    default: {
                        Logger.w("Unexpected HTTP response code: " + serverResponse + " for attachment download");
                        this.returnStatus = (byte)-1;
                        return this.returnStatus;
                    }
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException e) {
            Logger.x(e);
            this.returnStatus = (byte)-128;
            return this.returnStatus;
        }
        catch (IOException e) {
            Logger.x(e);
            this.returnStatus = (byte)-127;
        }
        return this.returnStatus;
    }

    public static interface ServerMethodForS3ProgressListener {
        public void onProgress(long var1);
    }
}

