/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public abstract class ServerMethod {
    public static final byte OK = 0;
    public static final byte INVALID_SESSION = 4;
    public static final byte DELETED_FROM_SERVER = 9;
    public static final byte ANOTHER_DEVICE_IS_ALREADY_REGISTERED = 10;
    public static final byte DEVICE_IS_NOT_REGISTERED = 11;
    public static final byte INVALID_NONCE = 12;
    public static final byte PERMISSION_DENIED = 14;
    public static final byte FREE_TRIAL_ALREADY_USED = 15;
    public static final byte EXTENDED_PAYLOAD_UNAVAILABLE = 17;
    public static final byte GROUP_UID_ALREADY_USED = 18;
    public static final byte GROUP_IS_LOCKED = 19;
    public static final byte INVALID_SIGNATURE = 20;
    public static final byte GROUP_NOT_LOCKED = 21;
    public static final byte INVALID_API_KEY = 22;
    public static final byte LISTING_TRUNCATED = 23;
    public static final byte PAYLOAD_TOO_LARGE = 24;
    public static final byte BACKUP_UID_ALREADY_USED = 25;
    public static final byte BACKUP_VERSION_TOO_SMALL = 26;
    public static final byte UNKNOWN_BACKUP_UID = 27;
    public static final byte UNKNOWN_BACKUP_THREAD_ID = 28;
    public static final byte UNKNOWN_BACKUP_VERSION = 29;
    public static final byte PARSING_ERROR = -2;
    public static final byte GENERAL_ERROR = -1;
    public static final byte MALFORMED_URL = -128;
    public static final byte SERVER_CONNECTION_ERROR = -127;
    public static final byte MALFORMED_SERVER_RESPONSE = -126;
    public static final byte OK_WITH_MALFORMED_SERVER_RESPONSE = -125;
    public static final byte IDENTITY_IS_NOT_ACTIVE = -114;
    protected byte returnStatus;
    private SSLSocketFactory sslSocketFactory = null;

    protected abstract String getServer();

    protected abstract String getServerMethod();

    protected abstract byte[] getDataToSend();

    protected abstract void parseReceivedData(Encoded[] var1);

    protected abstract boolean isActiveIdentityRequired();

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte execute(boolean ownedIdentityIsActive) {
        if (this.isActiveIdentityRequired() && !ownedIdentityIsActive) {
            this.returnStatus = (byte)-114;
            return this.returnStatus;
        }
        String server = this.getServer();
        String[] parts = server.split("://");
        String proto = "https";
        if (parts.length == 2) {
            proto = parts[0];
            server = parts[1];
        } else {
            server = parts[0];
        }
        String pathPrefix = null;
        int pathPos = server.indexOf(47);
        if (pathPos != -1) {
            pathPrefix = server.substring(pathPos);
            server = server.substring(0, pathPos);
            while (pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
            }
        }
        int port = -1;
        int portPos = server.indexOf(58);
        if (portPos != -1) {
            port = Integer.parseInt(server.substring(portPos + 1));
            server = server.substring(0, portPos);
        }
        Object path = this.getServerMethod();
        if (pathPrefix != null && !pathPrefix.isEmpty()) {
            path = pathPrefix + (String)path;
        }
        byte[] dataToSend = this.getDataToSend();
        try {
            String userAgentProperty;
            URL requestUrl = new URL(proto, server, port, (String)path);
            HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
            if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if ((userAgentProperty = System.getProperty("http.agent")) != null) {
                connection.setRequestProperty("User-Agent", userAgentProperty);
            }
            try {
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(20000);
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(dataToSend.length);
                connection.setRequestProperty("Cache-Control", "no-store");
                connection.setRequestProperty("Content-Type", "application/bytes");
                connection.setRequestProperty("Olvid-API-Version", "19");
                try (OutputStream os = connection.getOutputStream();){
                    os.write(dataToSend);
                    int serverResponse = connection.getResponseCode();
                    switch (serverResponse) {
                        case 200: {
                            try (InputStream is = connection.getInputStream();
                                 BufferedInputStream bis = new BufferedInputStream(is);
                                 ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                                int numberOfBytesRead;
                                byte[] buffer = new byte[8192];
                                while ((numberOfBytesRead = bis.read(buffer)) != -1) {
                                    byteArrayOutputStream.write(buffer, 0, numberOfBytesRead);
                                }
                                byteArrayOutputStream.flush();
                                byte[] responseData = byteArrayOutputStream.toByteArray();
                                Encoded encodedResponse = new Encoded(responseData);
                                Encoded[] responseList = encodedResponse.decodeList();
                                if (responseList.length == 0) {
                                    throw new DecodingException();
                                }
                                byte[] returnStatusBytes = responseList[0].decodeBytes();
                                if (returnStatusBytes.length != 1) {
                                    throw new DecodingException();
                                }
                                this.returnStatus = returnStatusBytes[0];
                                this.parseReceivedData(Arrays.copyOfRange(responseList, 1, responseList.length));
                                return this.returnStatus;
                            }
                        }
                        case 413: {
                            this.returnStatus = (byte)24;
                            return this.returnStatus;
                        }
                        default: {
                            Logger.w("Unexpected HTTP response code: " + serverResponse + " for query " + (String)path);
                            this.returnStatus = (byte)-127;
                            return this.returnStatus;
                        }
                    }
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException e) {
            Logger.x(e);
            this.returnStatus = (byte)-128;
            return this.returnStatus;
        }
        catch (IOException e) {
            Logger.x(e);
            this.returnStatus = (byte)-127;
            return this.returnStatus;
        }
        catch (DecodingException e) {
            Logger.x(e);
            this.returnStatus = (byte)-126;
        }
        return this.returnStatus;
    }
}

