/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import java.util.Arrays;

public class Seed {
    public static final int MIN_SEED_LENGTH = 32;
    private final byte[] seed;
    public final int length;

    public Seed(byte[] seed) throws IllegalArgumentException {
        if (seed.length < 32) {
            throw new IllegalArgumentException();
        }
        this.seed = seed;
        this.length = seed.length;
    }

    public Seed(Seed ... seedsToConcatenate) {
        int len = 0;
        for (Seed seedToConcatenate : seedsToConcatenate) {
            len += seedToConcatenate.length;
        }
        this.seed = new byte[len];
        this.length = len;
        len = 0;
        for (Seed seedToConcatenate : seedsToConcatenate) {
            System.arraycopy(seedToConcatenate.seed, 0, this.seed, len, seedToConcatenate.length);
            len += seedToConcatenate.length;
        }
    }

    public Seed(PRNG prng) {
        this(prng.bytes(32));
    }

    public byte[] getBytes() {
        return this.seed;
    }

    public static Seed of(AuthEncKey ... authEncKeys) throws Exception {
        if (authEncKeys.length == 0) {
            throw new Exception();
        }
        Seed zeroSeed = new Seed(new byte[32]);
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", zeroSeed);
        int ciphertextsLength = 0;
        EncryptedBytes[] ciphertexts = new EncryptedBytes[authEncKeys.length];
        for (int i = 0; i < authEncKeys.length; ++i) {
            AuthEnc authEnc = Suite.getAuthEnc(authEncKeys[i]);
            ciphertexts[i] = authEnc.encrypt(authEncKeys[i], new byte[32], prng);
            ciphertextsLength += ciphertexts[i].length;
        }
        byte[] hashInput = new byte[ciphertextsLength];
        ciphertextsLength = 0;
        for (int i = 0; i < authEncKeys.length; ++i) {
            System.arraycopy(ciphertexts[i].bytes, 0, hashInput, ciphertextsLength, ciphertexts[i].length);
            ciphertextsLength += ciphertexts[i].length;
        }
        Hash hash = Suite.getHash("sha-256");
        return new Seed(hash.digest(hashInput));
    }

    public String toString() {
        return Logger.toHexString(this.seed);
    }

    public int hashCode() {
        return Arrays.hashCode(this.seed);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Seed)) {
            return false;
        }
        return Arrays.equals(this.seed, ((Seed)obj).seed);
    }
}

