/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.encoder.Encoded;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PrivateIdentity {
    private final Identity publicIdentity;
    private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
    private final EncryptionPrivateKey encryptionPrivateKey;
    private final MACKey macKey;
    private static final byte[] DETERMINISTIC_SEED_MAC_PAYLOAD = new byte[]{85};
    private static final byte[] BACKUP_SEED_FOR_LEGACY_IDENTITY_MAC_PAYLOAD = new byte[]{-52};
    private static final byte[] BACKUP_SEED_FOR_LEGACY_IDENTITY_HASH_PADDING = "backupKey".getBytes(StandardCharsets.UTF_8);

    public PrivateIdentity(Identity publicIdentity, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey) {
        this.publicIdentity = publicIdentity;
        this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
        this.encryptionPrivateKey = encryptionPrivateKey;
        this.macKey = macKey;
    }

    public Identity getPublicIdentity() {
        return this.publicIdentity;
    }

    public ServerAuthenticationPrivateKey getServerAuthenticationPrivateKey() {
        return this.serverAuthenticationPrivateKey;
    }

    public EncryptionPrivateKey getEncryptionPrivateKey() {
        return this.encryptionPrivateKey;
    }

    public UID computeUniqueUid() {
        return this.publicIdentity.computeUniqueUid();
    }

    public ServerAuthenticationPublicKey getServerAuthenticationPublicKey() {
        return this.publicIdentity.getServerAuthenticationPublicKey();
    }

    public EncryptionPublicKey getEncryptionPublicKey() {
        return this.publicIdentity.getEncryptionPublicKey();
    }

    public MACKey getMacKey() {
        return this.macKey;
    }

    public byte[] serialize() {
        return Encoded.of(new Encoded[]{Encoded.of(this.publicIdentity.getBytes()), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey)}).getBytes();
    }

    public static PrivateIdentity of(byte[] bytes) {
        try {
            Encoded[] encodedElements = new Encoded(bytes).decodeList();
            return new PrivateIdentity(encodedElements[0].decodeIdentity(), (ServerAuthenticationPrivateKey)encodedElements[1].decodePrivateKey(), (EncryptionPrivateKey)encodedElements[2].decodePrivateKey(), (MACKey)encodedElements[3].decodeSymmetricKey());
        }
        catch (Exception e) {
            Logger.w("An error occurred while deserializing a PrivateIdentity.");
            return null;
        }
    }

    public Seed getDeterministicSeedForOwnedIdentity(byte[] diversificationTag) throws Exception {
        MAC mac = Suite.getMAC(this.macKey);
        byte[] digest = mac.digest(this.macKey, DETERMINISTIC_SEED_MAC_PAYLOAD);
        byte[] hashInput = new byte[digest.length + diversificationTag.length];
        System.arraycopy(digest, 0, hashInput, 0, digest.length);
        System.arraycopy(diversificationTag, 0, hashInput, digest.length, diversificationTag.length);
        Hash sha256 = Suite.getHash("sha-256");
        byte[] hash = sha256.digest(hashInput);
        return new Seed(hash);
    }

    public BackupSeed getDeterministicBackupSeedForLegacyIdentity() throws Exception {
        MAC mac = Suite.getMAC(this.macKey);
        byte[] digest = mac.digest(this.macKey, BACKUP_SEED_FOR_LEGACY_IDENTITY_MAC_PAYLOAD);
        byte[] hashInput = new byte[digest.length + BACKUP_SEED_FOR_LEGACY_IDENTITY_HASH_PADDING.length];
        System.arraycopy(digest, 0, hashInput, 0, digest.length);
        System.arraycopy(BACKUP_SEED_FOR_LEGACY_IDENTITY_HASH_PADDING, 0, hashInput, digest.length, BACKUP_SEED_FOR_LEGACY_IDENTITY_HASH_PADDING.length);
        Hash sha256 = Suite.getHash("sha-256");
        byte[] hash = sha256.digest(hashInput);
        return new BackupSeed(Arrays.copyOfRange(hash, 0, 20));
    }
}

