/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.PreKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;
import java.util.Objects;

public class PreKeyBlobOnServer {
    public final PreKey preKey;
    public final String[] rawDeviceCapabilities;

    public PreKeyBlobOnServer(PreKey preKey, String[] rawDeviceCapabilities) {
        this.preKey = preKey;
        this.rawDeviceCapabilities = rawDeviceCapabilities;
    }

    public static PreKeyBlobOnServer verifySignatureAndDecode(Encoded encodedSignedPreKey, Identity preKeyOwnerIdentity, UID expectedDeviceUid, Long serverTimestamp) {
        block11: {
            try {
                Encoded verifiedEncodedPreKey = null;
                try {
                    Encoded[] encodeds = encodedSignedPreKey.decodeList();
                    byte[] payload = encodeds[0].getBytes();
                    byte[] signature = encodeds[1].decodeBytes();
                    if (Signature.verify(Constants.SignatureContext.DEVICE_PRE_KEY, payload, preKeyOwnerIdentity, signature)) {
                        verifiedEncodedPreKey = encodeds[0];
                    } else {
                        Logger.i("PreKey signature verification failed.");
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                if (verifiedEncodedPreKey == null) break block11;
                try {
                    HashMap<DictionaryKey, Encoded> dict = verifiedEncodedPreKey.decodeDictionary();
                    Encoded encodedPreKey = dict.get(new DictionaryKey("prk"));
                    if (encodedPreKey == null) {
                        throw new Exception();
                    }
                    Encoded[] encodeds = encodedPreKey.decodeList();
                    UID deviceUid = encodeds[2].decodeUid();
                    if (!Objects.equals(expectedDeviceUid, deviceUid)) {
                        Logger.w("Device UID mismatch for a preKey received from server");
                        throw new Exception();
                    }
                    KeyId keyId = new KeyId(encodeds[0].decodeBytes());
                    byte[] compactEncryptionPublicKey = encodeds[1].decodeBytes();
                    EncryptionPublicKey encryptionPublicKey = EncryptionPublicKey.of(compactEncryptionPublicKey);
                    long expirationTimestamp = encodeds[3].decodeLong();
                    Encoded encodedCapabilities = dict.get(new DictionaryKey("cap"));
                    String[] capabilityStrings = encodedCapabilities != null ? encodedCapabilities.decodeStringArray() : null;
                    if (serverTimestamp != null && expirationTimestamp > serverTimestamp) {
                        return new PreKeyBlobOnServer(new PreKey(expectedDeviceUid, keyId, encryptionPublicKey, expirationTimestamp), capabilityStrings);
                    }
                }
                catch (Exception e) {
                    Logger.i("PreKey decoding failed.");
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        return null;
    }
}

