/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Operation;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OperationQueue {
    protected static final int MILLISECONDS_TO_WAIT_BETWEEN_TWO_OPERATION_EXECUTIONS = 20;
    private final Queue<Operation> operations;
    private final Lock lockOnCount;
    private final boolean persistent;
    private int count;
    private final Object notifier;
    private boolean executing = false;

    public OperationQueue() {
        this(false);
    }

    public OperationQueue(boolean persistent) {
        this.persistent = persistent;
        this.operations = new ConcurrentLinkedQueue<Operation>();
        this.lockOnCount = new ReentrantLock();
        this.count = 0;
        this.notifier = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperation(Operation op) {
        this.lockOnCount.lock();
        ++this.count;
        this.operations.add(op);
        this.lockOnCount.unlock();
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notifyAll();
        }
    }

    public void queue(Operation op) {
        op.setPending();
        this.addOperation(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        this.lockOnCount.lock();
        boolean queueIsEmpty = this.count == 0;
        this.lockOnCount.unlock();
        while (!queueIsEmpty) {
            Object object = this.notifier;
            synchronized (object) {
                try {
                    this.notifier.wait(500L);
                }
                catch (InterruptedException e) {
                    Logger.x(e);
                }
            }
            this.lockOnCount.lock();
            queueIsEmpty = this.count == 0;
            this.lockOnCount.unlock();
        }
    }

    public void execute(int numberOfThreads) {
        this.execute(numberOfThreads, null);
    }

    public void execute(int numberOfThreads, String tag) {
        if (this.persistent) {
            if (this.executing) {
                Logger.e("You can only call execute once on a persistent OperationQueue.");
                return;
            }
            this.executing = true;
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            new OperationQueueThread(i, tag).start();
        }
    }

    class OperationQueueThread
    extends Thread {
        public final int threadNumber;

        public OperationQueueThread(int i, String tag) {
            this.threadNumber = i;
            if (tag != null) {
                this.setName(tag + "-" + this.threadNumber);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long timeToWait;
                Object object;
                Operation op;
                if ((op = OperationQueue.this.operations.poll()) == null) {
                    if (!OperationQueue.this.persistent) break;
                    object = OperationQueue.this.notifier;
                    synchronized (object) {
                        try {
                            OperationQueue.this.notifier.wait(30000L);
                        }
                        catch (InterruptedException e) {
                            Logger.x(e);
                        }
                    }
                }
                op.updateReadiness();
                op.processCancel();
                if (op.getTimestampOfLastExecution() != 0L && (timeToWait = op.getTimestampOfLastExecution() - System.currentTimeMillis() + 20L) > 0L) {
                    try {
                        OperationQueueThread.sleep(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                op.setTimestampOfLastExecution(System.currentTimeMillis());
                if (op.isPending()) {
                    OperationQueue.this.addOperation(op);
                }
                if (op.isReady()) {
                    if (op.areConditionsFulfilled()) {
                        try {
                            op.execute();
                        }
                        catch (Exception e) {
                            Logger.e("Exception in operation that could have killed a queue!");
                            Logger.x(e);
                        }
                    } else {
                        OperationQueue.this.addOperation(op);
                    }
                }
                OperationQueue.this.lockOnCount.lock();
                --OperationQueue.this.count;
                object = OperationQueue.this.notifier;
                synchronized (object) {
                    OperationQueue.this.notifier.notifyAll();
                }
                OperationQueue.this.lockOnCount.unlock();
            }
        }
    }
}

