/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.UID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Operation {
    public static final int RFC_NULL = -1;
    private static final ReentrantLock globalLock = new ReentrantLock();
    private static final HashMap<String, HashSet<UID>> runningOperationUIDsByClass = new HashMap();
    private final List<Operation> dependencies;
    private State state = State.NOT_QUEUED;
    private final ReentrantLock lockOnState;
    private long timestampOfLastExecution = 0L;
    private boolean cancelWasRequested = false;
    private Integer reasonForCancel = null;
    private final UID uid;
    private final OnFinishCallback onFinishCallback;
    private final OnCancelCallback onCancelCallback;

    public Operation() {
        this(null, null, null);
    }

    public Operation(UID uid, OnFinishCallback onFinishCallback, OnCancelCallback onCancelCallback) {
        this.dependencies = new LinkedList<Operation>();
        this.lockOnState = new ReentrantLock();
        this.uid = uid;
        this.onFinishCallback = onFinishCallback;
        this.onCancelCallback = onCancelCallback;
    }

    public String toString() {
        return "Operation of type " + this.getClass().getName() + "(" + System.identityHashCode(this) + ")\n\tStatus: " + String.valueOf((Object)this.state);
    }

    public UID getUid() {
        return this.uid;
    }

    public boolean hasCancelledDependency() {
        for (Operation op : this.dependencies) {
            if (!op.isCancelled()) continue;
            return true;
        }
        return false;
    }

    public boolean areAllDependenciesFinished() {
        for (Operation op : this.dependencies) {
            if (op.isFinished()) continue;
            return false;
        }
        return true;
    }

    public void updateReadiness() {
        if (!this.isPending()) {
            return;
        }
        if (this.hasCancelledDependency()) {
            this.cancel(null);
            return;
        }
        if (this.areAllDependenciesFinished()) {
            this.setReady();
        }
    }

    public void setFinished() {
        this.lockOnState.lock();
        if (this.isStateChangeAuthorized(State.FINISHED)) {
            this.state = State.FINISHED;
            this.lockOnState.unlock();
            if (this.onFinishCallback != null) {
                this.onFinishCallback.onFinishCallback(this);
            }
            if (this.uid != null) {
                globalLock.lock();
                HashSet<UID> uids = runningOperationUIDsByClass.get(this.getClass().getName());
                if (uids != null) {
                    uids.remove(this.uid);
                }
                globalLock.unlock();
            }
        } else {
            this.lockOnState.unlock();
        }
    }

    public final void cancel(Integer reasonForCancel) {
        this.lockOnState.lock();
        if (this.state != State.CANCELLED && this.state != State.FINISHED && !this.cancelWasRequested) {
            this.cancelWasRequested = true;
            this.reasonForCancel = reasonForCancel;
            Logger.d("Cancel with RFC " + reasonForCancel + " requested for Operation of " + String.valueOf(this.getClass()));
        }
        this.lockOnState.unlock();
        this.doCancel();
    }

    public abstract void doCancel();

    public void processCancel() {
        this.lockOnState.lock();
        if (this.state != State.CANCELLED && this.state != State.FINISHED && this.cancelWasRequested) {
            this.state = State.CANCELLED;
            this.lockOnState.unlock();
            if (this.onCancelCallback != null) {
                this.onCancelCallback.onCancelCallback(this);
            }
            if (this.uid != null) {
                globalLock.lock();
                HashSet<UID> uids = runningOperationUIDsByClass.get(this.getClass().getName());
                if (uids != null) {
                    uids.remove(this.uid);
                }
                globalLock.unlock();
            }
            Logger.d("Processed cancel of Operation of " + this.getClass().toString());
        } else {
            this.lockOnState.unlock();
        }
    }

    public boolean areConditionsFulfilled() {
        HashSet<UID> uids;
        boolean conditionsFulfilled = true;
        globalLock.lock();
        if (this.uid != null && (uids = runningOperationUIDsByClass.get(this.getClass().getName())) != null && uids.contains(this.uid)) {
            conditionsFulfilled = false;
        }
        globalLock.unlock();
        return conditionsFulfilled;
    }

    public final void execute() {
        if (this.uid != null) {
            globalLock.lock();
            HashSet<UID> uids = runningOperationUIDsByClass.get(this.getClass().getName());
            if (uids == null) {
                uids = new HashSet();
                runningOperationUIDsByClass.put(this.getClass().getName(), uids);
            }
            uids.add(this.uid);
            globalLock.unlock();
        }
        this.setExecuting();
        this.doExecute();
    }

    public abstract void doExecute();

    public void addDependency(Operation operation) {
        for (Operation op : this.dependencies) {
            op.addDependency(operation);
        }
        this.dependencies.add(operation);
    }

    private boolean isStateChangeAuthorized(State newState) {
        switch (this.state.ordinal()) {
            case 0: {
                switch (newState.ordinal()) {
                    case 0: 
                    case 1: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                switch (newState.ordinal()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (newState.ordinal()) {
                    case 2: 
                    case 3: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (newState.ordinal()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                return newState == State.FINISHED;
            }
            case 5: {
                return newState == State.CANCELLED;
            }
        }
        return false;
    }

    public void setPending() {
        this.lockOnState.lock();
        if (this.isStateChangeAuthorized(State.PENDING)) {
            this.state = State.PENDING;
        }
        this.lockOnState.unlock();
    }

    public void setReady() {
        this.lockOnState.lock();
        if (this.isStateChangeAuthorized(State.READY)) {
            this.state = State.READY;
        }
        this.lockOnState.unlock();
    }

    public void setExecuting() {
        this.lockOnState.lock();
        if (this.isStateChangeAuthorized(State.EXECUTING)) {
            this.state = State.EXECUTING;
        }
        this.lockOnState.unlock();
    }

    public boolean wasQueued() {
        this.lockOnState.lock();
        boolean res = this.state != State.NOT_QUEUED;
        this.lockOnState.unlock();
        return res;
    }

    public boolean isPending() {
        this.lockOnState.lock();
        boolean res = this.state == State.PENDING;
        this.lockOnState.unlock();
        return res;
    }

    public boolean isExecuting() {
        this.lockOnState.lock();
        boolean res = this.state == State.EXECUTING;
        this.lockOnState.unlock();
        return res;
    }

    public boolean isReady() {
        this.lockOnState.lock();
        boolean res = this.state == State.READY;
        this.lockOnState.unlock();
        return res;
    }

    public boolean isFinished() {
        this.lockOnState.lock();
        boolean res = this.state == State.FINISHED;
        this.lockOnState.unlock();
        return res;
    }

    public boolean isCancelled() {
        this.lockOnState.lock();
        boolean res = this.state == State.CANCELLED;
        this.lockOnState.unlock();
        return res;
    }

    public long getTimestampOfLastExecution() {
        return this.timestampOfLastExecution;
    }

    public void setTimestampOfLastExecution(long timestampOfLastExecution) {
        this.timestampOfLastExecution = timestampOfLastExecution;
    }

    public List<Operation> getDependencies() {
        return this.dependencies;
    }

    public boolean cancelWasRequested() {
        return this.cancelWasRequested;
    }

    public Integer getReasonForCancel() {
        return this.reasonForCancel;
    }

    public boolean hasNoReasonForCancel() {
        return this.reasonForCancel == null;
    }

    public static interface OnFinishCallback {
        public void onFinishCallback(Operation var1);
    }

    public static interface OnCancelCallback {
        public void onCancelCallback(Operation var1);
    }

    private static enum State {
        NOT_QUEUED,
        PENDING,
        READY,
        EXECUTING,
        FINISHED,
        CANCELLED;

    }
}

