/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import java.util.Arrays;
import java.util.regex.Pattern;

public class ObvBase64 {
    private static final char[] base64Map;
    private static final int[] invBase64Map;
    private static final Pattern pattern;

    public static String encode(byte[] bytes) {
        int buffer;
        int srcPos;
        int base64len = 1 + (bytes.length * 4 - 1) / 3;
        char[] chars = new char[base64len];
        int outPos = 0;
        for (srcPos = 0; srcPos < bytes.length - 2; srcPos += 3) {
            buffer = (bytes[srcPos] & 0xFF) << 16 ^ (bytes[srcPos + 1] & 0xFF) << 8 ^ bytes[srcPos + 2] & 0xFF;
            chars[outPos++] = base64Map[buffer >> 18];
            chars[outPos++] = base64Map[buffer >> 12 & 0x3F];
            chars[outPos++] = base64Map[buffer >> 6 & 0x3F];
            chars[outPos++] = base64Map[buffer & 0x3F];
        }
        if (srcPos == bytes.length - 1) {
            buffer = bytes[srcPos] & 0xFF;
            chars[outPos++] = base64Map[buffer >> 2 & 0x3F];
            chars[outPos++] = base64Map[buffer << 4 & 0x3F];
        }
        if (srcPos == bytes.length - 2) {
            buffer = (bytes[srcPos] & 0xFF) << 8 ^ bytes[srcPos + 1] & 0xFF;
            chars[outPos++] = base64Map[buffer >> 10 & 0x3F];
            chars[outPos++] = base64Map[buffer >> 4 & 0x3F];
            chars[outPos] = base64Map[buffer << 2 & 0x3F];
        }
        return new String(chars);
    }

    public static byte[] decode(String base64) throws Exception {
        int buffer;
        char[] chars = (base64 = base64.replaceAll("=+$", "")).toCharArray();
        if ((chars.length & 3) == 1) {
            throw new Exception();
        }
        if (!pattern.matcher(base64).matches()) {
            throw new Exception();
        }
        int bytelen = chars.length * 3 / 4;
        byte[] bytes = new byte[bytelen];
        int srcPos = 0;
        int outPos = 0;
        while (srcPos < chars.length - 3) {
            buffer = invBase64Map[chars[srcPos++]] << 18;
            buffer ^= invBase64Map[chars[srcPos++]] << 12;
            buffer ^= invBase64Map[chars[srcPos++]] << 6;
            bytes[outPos++] = (byte)((buffer ^= invBase64Map[chars[srcPos++]]) >> 16);
            bytes[outPos++] = (byte)(buffer >> 8);
            bytes[outPos++] = (byte)buffer;
        }
        if (srcPos == chars.length - 2) {
            buffer = invBase64Map[chars[srcPos++]] << 18;
            bytes[outPos++] = (byte)((buffer ^= invBase64Map[chars[srcPos++]] << 12) >> 16);
        }
        if (srcPos == chars.length - 3) {
            buffer = invBase64Map[chars[srcPos++]] << 18;
            buffer ^= invBase64Map[chars[srcPos++]] << 12;
            bytes[outPos++] = (byte)((buffer ^= invBase64Map[chars[srcPos]] << 6) >> 16);
            bytes[outPos] = (byte)(buffer >> 8);
        }
        return bytes;
    }

    static {
        int c;
        base64Map = new char[64];
        invBase64Map = new int[128];
        Arrays.fill(invBase64Map, -1);
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ObvBase64.invBase64Map[c] = i;
            ObvBase64.base64Map[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ObvBase64.invBase64Map[c] = i;
            ObvBase64.base64Map[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ObvBase64.invBase64Map[c] = i;
            ObvBase64.base64Map[i++] = c;
        }
        ObvBase64.invBase64Map[45] = i;
        ObvBase64.base64Map[i++] = 45;
        ObvBase64.invBase64Map[95] = i;
        ObvBase64.base64Map[i] = 95;
        pattern = Pattern.compile("^[-_a-zA-Z0-9]*$");
    }
}

