/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NoDuplicateOperationQueue {
    private final BlockingQueue<Operation> operations;
    private final Lock lockOnQueuedOperationUids;
    private final Set<UID> queuedOperationUids = new HashSet<UID>();
    private boolean executing = false;

    public NoDuplicateOperationQueue() {
        this.lockOnQueuedOperationUids = new ReentrantLock();
        this.operations = new LinkedBlockingQueue<Operation>();
    }

    public void queue(Operation op) {
        if (!op.getDependencies().isEmpty()) {
            Logger.e("Cannot queue an operation with dependencies into a NoDuplicateOperationQueue.");
            return;
        }
        UID uid = op.getUid();
        if (uid != null) {
            this.lockOnQueuedOperationUids.lock();
            if (this.queuedOperationUids.contains(uid)) {
                this.lockOnQueuedOperationUids.unlock();
                return;
            }
            this.queuedOperationUids.add(uid);
            this.lockOnQueuedOperationUids.unlock();
        }
        op.setPending();
        this.operations.add(op);
    }

    public void execute(int numberOfThreads) {
        this.execute(numberOfThreads, null);
    }

    public void execute(int numberOfThreads, String tag) {
        if (this.executing) {
            Logger.e("You can only call execute once on a NoDuplicateOperationQueue.");
            return;
        }
        this.executing = true;
        for (int i = 0; i < numberOfThreads; ++i) {
            new NoDuplicateOperationQueueThread(i, tag).start();
        }
    }

    class NoDuplicateOperationQueueThread
    extends Thread {
        final int threadNumber;

        NoDuplicateOperationQueueThread(int i, String tag) {
            this.threadNumber = i;
            if (tag != null) {
                this.setName(tag + "-" + this.threadNumber);
            }
        }

        @Override
        public void run() {
            while (true) {
                long timeToWait;
                Operation op;
                try {
                    op = NoDuplicateOperationQueue.this.operations.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                op.updateReadiness();
                op.processCancel();
                if (op.getTimestampOfLastExecution() != 0L && (timeToWait = op.getTimestampOfLastExecution() - System.currentTimeMillis() + 20L) > 0L) {
                    try {
                        NoDuplicateOperationQueueThread.sleep(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                op.setTimestampOfLastExecution(System.currentTimeMillis());
                if (!op.isReady()) continue;
                if (op.areConditionsFulfilled()) {
                    if (op.getUid() != null) {
                        NoDuplicateOperationQueue.this.lockOnQueuedOperationUids.lock();
                        NoDuplicateOperationQueue.this.queuedOperationUids.remove(op.getUid());
                        NoDuplicateOperationQueue.this.lockOnQueuedOperationUids.unlock();
                    }
                    try {
                        op.execute();
                    }
                    catch (Exception e) {
                        Logger.e("Exception in operation that could have killed a queue!");
                        Logger.x(e);
                    }
                    continue;
                }
                NoDuplicateOperationQueue.this.operations.add(op);
            }
        }
    }
}

