/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.encoder.DecodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Identity
implements Comparable<Identity> {
    private final String server;
    private final ServerAuthenticationPublicKey serverAuthenticationPublicKey;
    private final EncryptionPublicKey encryptionPublicKey;
    private byte[] identityBytes;

    public Identity(String server, ServerAuthenticationPublicKey serverAuthenticationPublicKey, EncryptionPublicKey encryptionPublicKey) {
        this.server = server;
        this.serverAuthenticationPublicKey = serverAuthenticationPublicKey;
        this.encryptionPublicKey = encryptionPublicKey;
        this.identityBytes = null;
    }

    private Identity(String server, ServerAuthenticationPublicKey serverAuthenticationPublicKey, EncryptionPublicKey encryptionPublicKey, byte[] identityBytes) {
        this.server = server;
        this.serverAuthenticationPublicKey = serverAuthenticationPublicKey;
        this.encryptionPublicKey = encryptionPublicKey;
        this.identityBytes = identityBytes;
    }

    public static Identity of(byte[] identityBytes) throws DecodingException {
        int serverPkLength;
        int pos = -1;
        for (int i = 0; i < identityBytes.length; ++i) {
            if (identityBytes[i] != 0) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            throw new DecodingException();
        }
        String server = new String(Arrays.copyOfRange(identityBytes, 0, pos), StandardCharsets.UTF_8);
        if ((serverPkLength = ServerAuthenticationPublicKey.getCompactKeyLength(identityBytes[++pos])) < 0) {
            throw new DecodingException();
        }
        ServerAuthenticationPublicKey serverAuthenticationPublicKey = ServerAuthenticationPublicKey.of(Arrays.copyOfRange(identityBytes, pos, pos + serverPkLength));
        int anonAuthPkLength = EncryptionPublicKey.getCompactKeyLength(identityBytes[pos += serverPkLength]);
        if (anonAuthPkLength < 0) {
            throw new DecodingException();
        }
        EncryptionPublicKey encryptionPublicKey = EncryptionPublicKey.of(Arrays.copyOfRange(identityBytes, pos, pos + anonAuthPkLength));
        return new Identity(server, serverAuthenticationPublicKey, encryptionPublicKey, identityBytes);
    }

    public byte[] getBytes() {
        if (this.identityBytes == null) {
            byte[] serverBytes = this.server.getBytes(StandardCharsets.UTF_8);
            byte[] serverAuthenticationPublicKeyBytes = this.serverAuthenticationPublicKey.getCompactKey();
            byte[] anonAuthPublicKeyBytes = this.encryptionPublicKey.getCompactKey();
            this.identityBytes = new byte[serverBytes.length + 1 + serverAuthenticationPublicKeyBytes.length + anonAuthPublicKeyBytes.length];
            System.arraycopy(serverBytes, 0, this.identityBytes, 0, serverBytes.length);
            this.identityBytes[serverBytes.length] = 0;
            System.arraycopy(serverAuthenticationPublicKeyBytes, 0, this.identityBytes, serverBytes.length + 1, serverAuthenticationPublicKeyBytes.length);
            System.arraycopy(anonAuthPublicKeyBytes, 0, this.identityBytes, serverBytes.length + 1 + serverAuthenticationPublicKeyBytes.length, anonAuthPublicKeyBytes.length);
        }
        return this.identityBytes;
    }

    public String getServer() {
        return this.server;
    }

    public ServerAuthenticationPublicKey getServerAuthenticationPublicKey() {
        return this.serverAuthenticationPublicKey;
    }

    public EncryptionPublicKey getEncryptionPublicKey() {
        return this.encryptionPublicKey;
    }

    public UID computeUniqueUid() {
        Hash sha256 = Suite.getHash("sha-256");
        return new UID(sha256.digest(this.getBytes()));
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Identity)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), ((Identity)other).getBytes());
    }

    public String toString() {
        return this.server + "@" + Logger.toHexString(this.serverAuthenticationPublicKey.getCompactKey()) + "-" + Logger.toHexString(this.encryptionPublicKey.getCompactKey());
    }

    @Override
    public int compareTo(Identity o) {
        byte[] other;
        byte[] me = this.getBytes();
        if (me.length != (other = o.getBytes()).length) {
            return me.length - other.length;
        }
        for (int i = 0; i < me.length; ++i) {
            if (me[i] == other[i]) continue;
            return (me[i] & 0xFF) - (other[i] & 0xFF);
        }
        return 0;
    }
}

