/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ExponentialBackoffRepeatingScheduler<T> {
    private final ScheduledExecutorService scheduler;
    private final HashMap<T, Integer> failedAttemptCounts;
    private final HashMap<T, Runnable> pendingRunnables;
    private final Object lock = new Object();
    private final Random random = new Random();

    public ExponentialBackoffRepeatingScheduler() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.failedAttemptCounts = new HashMap();
        this.pendingRunnables = new HashMap();
    }

    public void schedule(T key, Runnable runnable) {
        this.schedule(key, runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(T key, Runnable runnable, String tag) {
        Object object = this.lock;
        synchronized (object) {
            Runnable oldRunnable = this.pendingRunnables.get(key);
            if (oldRunnable != null) {
                return;
            }
            this.pendingRunnables.put(key, runnable);
            Integer failedCount = this.failedAttemptCounts.get(key);
            if (failedCount == null) {
                failedCount = 1;
            } else {
                Integer n = failedCount;
                failedCount = failedCount + 1;
            }
            this.failedAttemptCounts.put(key, failedCount);
            long delay = this.computeReschedulingDelay(failedCount);
            if (tag != null) {
                Logger.i("Scheduling a " + tag + " for " + key.toString() + " in " + delay + "ms.");
            }
            this.scheduler.schedule(() -> {
                Runnable runnab;
                Object object = this.lock;
                synchronized (object) {
                    runnab = this.pendingRunnables.get(key);
                    if (runnab != null) {
                        this.pendingRunnables.remove(key);
                    }
                }
                if (runnab != null) {
                    runnab.run();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(T key, Runnable runnable, String tag, long delay) {
        Object object = this.lock;
        synchronized (object) {
            if (tag != null) {
                Logger.d("Scheduling a " + tag + " for " + key.toString() + " in " + delay + "ms.");
            }
            this.scheduler.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        }
    }

    public void clearFailedCount(T key) {
        this.failedAttemptCounts.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryScheduledRunnables() {
        ArrayList<Runnable> runnables;
        Object object = this.lock;
        synchronized (object) {
            runnables = new ArrayList<Runnable>(this.pendingRunnables.values());
            this.pendingRunnables.clear();
            this.failedAttemptCounts.clear();
        }
        this.scheduler.execute(() -> {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
        });
    }

    protected long computeReschedulingDelay(int failedAttemptCount) {
        long base = 250L << Math.min(failedAttemptCount, 32);
        return (long)((float)base * (1.0f + this.random.nextFloat()));
    }
}

