/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.exceptions.PointNotOnCurveException;
import java.math.BigInteger;

public class EdwardCurvePoint {
    final BigInteger X;
    final BigInteger Y;
    final EdwardCurve curve;

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public EdwardCurve getCurve() {
        return this.curve;
    }

    public EdwardCurvePoint(BigInteger X, BigInteger Y, EdwardCurve curve) throws PointNotOnCurveException {
        this.X = X;
        this.Y = Y;
        this.curve = curve;
        BigInteger X2 = X.multiply(X).mod(curve.p);
        BigInteger Y2 = Y.multiply(Y).mod(curve.p);
        if (!X2.add(Y2).mod(curve.p).equals(BigInteger.ONE.add(curve.d.multiply(X2).multiply(Y2)).mod(curve.p))) {
            throw new PointNotOnCurveException();
        }
    }

    private EdwardCurvePoint(BigInteger X, BigInteger Y, EdwardCurve curve, boolean noCheck) {
        this.X = X;
        this.Y = Y;
        this.curve = curve;
    }

    public static EdwardCurvePoint noCheckFactory(BigInteger X, BigInteger Y, EdwardCurve curve) {
        return new EdwardCurvePoint(X, Y, curve, true);
    }

    public boolean isLowOrderPoint() {
        if (this.X != null) {
            return this.curve.scalarMultiplicationWithX(this.curve.nu, this).getY().equals(BigInteger.ONE);
        }
        return this.curve.scalarMultiplication(this.curve.nu, this.Y).equals(BigInteger.ONE);
    }

    public boolean equals(Object o) {
        if (o instanceof EdwardCurvePoint) {
            EdwardCurvePoint Q = (EdwardCurvePoint)o;
            return this.X.equals(Q.getX()) && this.Y.equals(Q.getY());
        }
        return false;
    }
}

