/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.datatypes.Session;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class DeferrablePreparedStatement
implements PreparedStatement {
    private final String tag;
    private final PreparedStatement statement;
    private final Session session;

    DeferrablePreparedStatement(String tag, PreparedStatement statement, Session session) {
        this.tag = tag;
        this.statement = statement;
        this.session = session;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        long startTime = System.nanoTime();
        ResultSet res = this.statement.executeQuery();
        Session.registerQueryTime(this.tag, (System.nanoTime() - startTime) / 1000L);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int res;
        long startTime;
        if (this.session.getAutoCommit()) {
            try {
                Session.globalWriteLock.lock();
                startTime = System.nanoTime();
                res = this.statement.executeUpdate();
            }
            finally {
                Session.globalWriteLock.unlock();
            }
        } else {
            startTime = System.nanoTime();
            res = this.statement.executeUpdate();
        }
        Session.registerQueryTime(this.tag, (System.nanoTime() - startTime) / 1000L);
        return res;
    }

    @Override
    public boolean execute() throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public void setNull(int i, int i1) throws SQLException {
        this.statement.setNull(i, i1);
    }

    @Override
    public void setBoolean(int i, boolean b) throws SQLException {
        this.statement.setBoolean(i, b);
    }

    @Override
    public void setByte(int i, byte b) throws SQLException {
        this.statement.setByte(i, b);
    }

    @Override
    public void setShort(int i, short i1) throws SQLException {
        this.statement.setShort(i, i1);
    }

    @Override
    public void setInt(int i, int i1) throws SQLException {
        this.statement.setInt(i, i1);
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        this.statement.setLong(i, l);
    }

    @Override
    public void setFloat(int i, float v) throws SQLException {
        this.statement.setFloat(i, v);
    }

    @Override
    public void setDouble(int i, double v) throws SQLException {
        this.statement.setDouble(i, v);
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bigDecimal) throws SQLException {
        this.statement.setBigDecimal(i, bigDecimal);
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        this.statement.setString(i, s);
    }

    @Override
    public void setBytes(int i, byte[] bytes) throws SQLException {
        this.statement.setBytes(i, bytes);
    }

    @Override
    public void setDate(int i, Date date) throws SQLException {
        this.statement.setDate(i, date);
    }

    @Override
    public void setTime(int i, Time time) throws SQLException {
        this.statement.setTime(i, time);
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.statement.setTimestamp(i, timestamp);
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.statement.setAsciiStream(i, inputStream, i1);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.statement.setUnicodeStream(i, inputStream, i1);
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream, int i1) throws SQLException {
        this.statement.setBinaryStream(i, inputStream, i1);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
    }

    @Override
    public void setObject(int i, Object o, int i1) throws SQLException {
        this.statement.setObject(i, o, i1);
    }

    @Override
    public void setObject(int i, Object o) throws SQLException {
        this.statement.setObject(i, o);
    }

    @Override
    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int i1) throws SQLException {
        this.statement.setCharacterStream(i, reader, i1);
    }

    @Override
    public void setRef(int i, Ref ref) throws SQLException {
        this.statement.setRef(i, ref);
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        this.statement.setBlob(i, blob);
    }

    @Override
    public void setClob(int i, Clob clob) throws SQLException {
        this.statement.setClob(i, clob);
    }

    @Override
    public void setArray(int i, Array array) throws SQLException {
        this.statement.setArray(i, array);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.statement.getMetaData();
    }

    @Override
    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        this.statement.setDate(i, date, calendar);
    }

    @Override
    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        this.statement.setTime(i, time, calendar);
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.statement.setTimestamp(i, timestamp, calendar);
    }

    @Override
    public void setNull(int i, int i1, String s) throws SQLException {
        this.statement.setNull(i, i1, s);
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        this.statement.setURL(i, url);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.statement.getParameterMetaData();
    }

    @Override
    public void setRowId(int i, RowId rowId) throws SQLException {
        this.statement.setRowId(i, rowId);
    }

    @Override
    public void setNString(int i, String s) throws SQLException {
        this.statement.setNString(i, s);
    }

    @Override
    public void setNCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.statement.setNCharacterStream(i, reader, l);
    }

    @Override
    public void setNClob(int i, NClob nClob) throws SQLException {
        this.statement.setNClob(i, nClob);
    }

    @Override
    public void setClob(int i, Reader reader, long l) throws SQLException {
        this.statement.setClob(i, reader, l);
    }

    @Override
    public void setBlob(int i, InputStream inputStream, long l) throws SQLException {
        this.statement.setBlob(i, inputStream, l);
    }

    @Override
    public void setNClob(int i, Reader reader, long l) throws SQLException {
        this.statement.setNClob(i, reader, l);
    }

    @Override
    public void setSQLXML(int i, SQLXML sqlxml) throws SQLException {
        this.statement.setSQLXML(i, sqlxml);
    }

    @Override
    public void setObject(int i, Object o, int i1, int i2) throws SQLException {
        this.statement.setObject(i, o, i1, i2);
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream, long l) throws SQLException {
        this.statement.setAsciiStream(i, inputStream, l);
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream, long l) throws SQLException {
        this.statement.setBinaryStream(i, inputStream, l);
    }

    @Override
    public void setCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.statement.setCharacterStream(i, reader, l);
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream) throws SQLException {
        this.statement.setAsciiStream(i, inputStream);
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream) throws SQLException {
        this.statement.setBinaryStream(i, inputStream);
    }

    @Override
    public void setCharacterStream(int i, Reader reader) throws SQLException {
        this.statement.setCharacterStream(i, reader);
    }

    @Override
    public void setNCharacterStream(int i, Reader reader) throws SQLException {
        this.statement.setNCharacterStream(i, reader);
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        this.statement.setClob(i, reader);
    }

    @Override
    public void setBlob(int i, InputStream inputStream) throws SQLException {
        this.statement.setBlob(i, inputStream);
    }

    @Override
    public void setNClob(int i, Reader reader) throws SQLException {
        this.statement.setNClob(i, reader);
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this.statement.setMaxFieldSize(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this.statement.setMaxRows(i);
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        this.statement.setEscapeProcessing(b);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this.statement.setQueryTimeout(i);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        this.statement.setCursorName(s);
    }

    @Override
    public boolean execute(String s) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this.statement.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this.statement.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String s) throws SQLException {
        this.statement.addBatch(s);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this.statement.getMoreResults(i);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int executeUpdate(String s, int[] ints) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int executeUpdate(String s, String[] strings) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        this.statement.setPoolable(b);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return this.statement.unwrap(aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return this.statement.isWrapperFor(aClass);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }
}

