/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.datatypes.UID;
import java.nio.charset.StandardCharsets;

public abstract class Constants {
    public static final int CURRENT_ENGINE_DB_SCHEMA_VERSION = 48;
    public static final int SERVER_API_VERSION = 19;
    public static final int CURRENT_BACKUP_JSON_VERSION = 0;
    public static final String ENGINE_DB_FILENAME = "engine_db.sqlite";
    public static final String TMP_ENGINE_ENCRYPTED_DB_FILENAME = "engine_encrypted_db.sqlite";
    public static final String INBOUND_ATTACHMENTS_DIRECTORY = "inbound_attachments";
    public static final String IDENTITY_PHOTOS_DIRECTORY = "identity_photos";
    public static final String DOWNLOADED_USER_DATA_DIRECTORY = "downloaded_user_data";
    public static final int API_KEY_STATUS_VALID = 0;
    public static final int API_KEY_STATUS_UNKNOWN = 1;
    public static final int API_KEY_STATUS_LICENSES_EXHAUSTED = 2;
    public static final int API_KEY_STATUS_EXPIRED = 3;
    public static final int API_KEY_STATUS_OPEN_BETA_KEY = 4;
    public static final int API_KEY_STATUS_FREE_TRIAL_KEY = 5;
    public static final int API_KEY_STATUS_AWAITING_PAYMENT_GRACE_PERIOD = 6;
    public static final int API_KEY_STATUS_AWAITING_PAYMENT_ON_HOLD = 7;
    public static final int API_KEY_STATUS_FREE_TRIAL_KEY_EXPIRED = 8;
    public static final long API_KEY_PERMISSION_CALL = 1L;
    public static final long API_KEY_PERMISSION_WEB_CLIENT = 2L;
    public static final long API_KEY_PERMISSION_MULTI_DEVICE = 4L;
    public static final long THRESHOLD_TIME_INTERVAL_SINCE_LAST_FULL_RATCHET_SENT_MESSAGE = 2592000000L;
    public static final int THRESHOLD_NUMBER_OF_ENCRYPTED_MESSAGES_PER_FULL_RATCHET = 500;
    public static final long FULL_RATCHET_TIME_INTERVAL_VALIDITY = 2592000000L;
    public static final int REPROVISIONING_THRESHOLD = 50;
    public static final long PROVISIONED_KEY_MATERIAL_EXPIRATION_DELAY = 5184000000L;
    public static final long OUTBOX_MESSAGE_MAX_SEND_DELAY = 2592000000L;
    public static final long PROTOCOL_RECEIVED_MESSAGE_EXPIRATION_DELAY = 1296000000L;
    public static final long SERVER_QUERY_EXPIRATION_DELAY = 1296000000L;
    public static final long USER_DATA_REFRESH_INTERVAL = 604800000L;
    public static final long GET_USER_DATA_LOCAL_FILE_LIFESPAN = 604800000L;
    public static final long WELL_KNOWN_REFRESH_INTERVAL = 21600000L;
    public static final long MINIMUM_URL_REFRESH_INTERVAL = 3600000L;
    public static final long AUTOBACKUP_MAX_INTERVAL = 86400000L;
    public static final long AUTOBACKUP_START_DELAY = 120000L;
    public static final UID DEVICE_BACKUP_THREAD_ID = new UID(new byte[]{-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2});
    public static final long DEVICE_BACKUP_INTERVAL = 2592000000L;
    public static final long PROFILE_BACKUP_INTERVAL = 86400000L;
    public static final long BACKUP_START_DELAY = 300000L;
    public static final long PRE_KEY_VALIDITY_DURATION = 5184000000L;
    public static final long PRE_KEY_RENEWAL_INTERVAL = 604800000L;
    public static final long PRE_KEY_CONSERVATION_DURATION = 5184000000L;
    public static final long PRE_KEY_INBOX_NO_CONTACT_DURATION = 1296000000L;
    public static final long NO_DEVICE_CONTACT_DEVICE_DISCOVERY_INTERVAL = 259200000L;
    public static final long CONTACT_DEVICE_DISCOVERY_INTERVAL = 604800000L;
    public static final long OWNED_DEVICE_DISCOVERY_INTERVAL = 86400000L;
    public static final long CHANNEL_CREATION_PING_INTERVAL = 2592000000L;
    public static final int SERVER_SESSION_NONCE_LENGTH = 32;
    public static final int SERVER_SESSION_CHALLENGE_LENGTH = 32;
    public static final int SERVER_SESSION_TOKEN_LENGTH = 32;
    public static final int RETURN_RECEIPT_NONCE_LENGTH = 16;
    public static final int GROUP_V2_INVITATION_NONCE_LENGTH = 16;
    public static final int GROUP_V2_LOCK_NONCE_LENGTH = 32;
    public static final int DEFAULT_ATTACHMENT_CHUNK_LENGTH = 0x800000;
    public static final int MAX_MESSAGE_EXTENDED_CONTENT_LENGTH = 51200;
    public static final int MAX_UPLOAD_MESSAGE_BATCH_SIZE = 50;
    public static final int MAX_UPLOAD_MESSAGE_BATCH_HEADER_COUNT = 1000;
    public static final int MAX_UPLOAD_RETURN_RECEIPT_BATCH_SIZE = 50;
    public static final int MAX_DELETE_MESSAGE_ON_SERVER_BATCH_SIZE = 50;
    public static final UID BROADCAST_UID = new UID(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    public static final byte[] ANDROID_STORE_ID = new byte[]{1};
    public static final int DEFAULT_NUMBER_OF_DIGITS_FOR_SAS = 4;
    public static final String EPHEMERAL_IDENTITY_SERVER = "ephemeral_fake_server";
    public static final String TRANSFER_WS_SERVER_URL = "wss://transfer.olvid.io";
    public static final int TRANSFER_MAX_PAYLOAD_SIZE = 10000;
    public static final long BASE_RESCHEDULING_TIME = 250L;
    public static final long WEBSOCKET_PING_INTERVAL_MILLIS = 20000L;
    public static final long WEBSOCKET_RECONNECT_INTERVAL_MILLIS = 6000000L;
    public static final long KEYCLOAK_SIGNATURE_VALIDITY_MILLIS = 5184000000L;
    public static final int SIGNATURE_PADDING_LENGTH = 16;
    public static final byte[] SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX = "authentChallenge".getBytes(StandardCharsets.UTF_8);
    public static final byte[] MUTUAL_SCAN_SIGNATURE_CHALLENGE_PREFIX = "mutualScan".getBytes(StandardCharsets.UTF_8);
    public static final byte[] MUTUAL_INTRODUCTION_SIGNATURE_CHALLENGE_PREFIX = "mutualIntroduction".getBytes(StandardCharsets.UTF_8);
    public static final byte[] CHANNEL_CREATION_SIGNATURE_CHALLENGE_PREFIX = "channelCreation".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_ADMINISTRATORS_CHAIN_SIGNATURE_CHALLENGE_PREFIX = "groupAdministratorsChain".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_BLOB_SIGNATURE_CHALLENGE_PREFIX = "groupBlob".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_LEAVE_NONCE_SIGNATURE_CHALLENGE_PREFIX = "groupLeave".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_LOCK_SIGNATURE_CHALLENGE_PREFIX = "lockNonce".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_DELETE_ON_SERVER_SIGNATURE_CHALLENGE_PREFIX = "deleteGroup".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_JOIN_NONCE_SIGNATURE_CHALLENGE_PREFIX = "joinGroup".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_UPDATE_ON_SERVER_SIGNATURE_CHALLENGE_PREFIX = "updateGroup".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GROUP_KICK_SIGNATURE_CHALLENGE_PREFIX = "groupKick".getBytes(StandardCharsets.UTF_8);
    public static final byte[] OWNED_IDENTITY_DELETION_SIGNATURE_CHALLENGE_PREFIX = "ownedIdentityDeletion".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DEVICE_PRE_KEY_SIGNATURE_CHALLENGE_PREFIX = "devicePreKey".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ENCRYPTION_WITH_PRE_KEY_SIGNATURE_CHALLENGE_PREFIX = "encryptionWithPreKey".getBytes(StandardCharsets.UTF_8);
    public static final byte[] BACKUP_UPLOAD_SIGNATURE_CHALLENGE_PREFIX = "backupUpload".getBytes(StandardCharsets.UTF_8);
    public static final byte[] BACKUP_DELETE_SIGNATURE_CHALLENGE_PREFIX = "backupDelete".getBytes(StandardCharsets.UTF_8);

    public static byte[] getSignatureChallengePrefix(SignatureContext signatureContext) {
        switch (signatureContext.ordinal()) {
            case 0: {
                return SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 1: {
                return MUTUAL_SCAN_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 2: {
                return MUTUAL_INTRODUCTION_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 3: {
                return CHANNEL_CREATION_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 4: {
                return GROUP_ADMINISTRATORS_CHAIN_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 5: {
                return GROUP_BLOB_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 6: {
                return GROUP_LEAVE_NONCE_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 7: {
                return GROUP_LOCK_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 8: {
                return GROUP_DELETE_ON_SERVER_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 9: {
                return GROUP_JOIN_NONCE_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 10: {
                return GROUP_UPDATE_ON_SERVER_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 11: {
                return GROUP_KICK_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 12: {
                return OWNED_IDENTITY_DELETION_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 13: {
                return DEVICE_PRE_KEY_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 14: {
                return ENCRYPTION_WITH_PRE_KEY_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 15: {
                return BACKUP_UPLOAD_SIGNATURE_CHALLENGE_PREFIX;
            }
            case 16: {
                return BACKUP_DELETE_SIGNATURE_CHALLENGE_PREFIX;
            }
        }
        return null;
    }

    public static enum SignatureContext {
        SERVER_AUTHENTICATION,
        MUTUAL_SCAN,
        MUTUAL_INTRODUCTION,
        CHANNEL_CREATION,
        GROUP_ADMINISTRATORS_CHAIN,
        GROUP_BLOB,
        GROUP_LEAVE_NONCE,
        GROUP_LOCK_ON_SERVER,
        GROUP_DELETE_ON_SERVER,
        GROUP_JOIN_NONCE,
        GROUP_UPDATE_ON_SERVER,
        GROUP_KICK,
        OWNED_IDENTITY_DELETION,
        DEVICE_PRE_KEY,
        ENCRYPTION_WITH_PRE_KEY,
        BACKUP_UPLOAD,
        BACKUP_DELETE;

    }
}

