/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

public class Chunk {
    private final int chunkNumber;
    private final byte[] data;

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public byte[] getData() {
        return this.data;
    }

    public Chunk(int chunkNumber, byte[] data) {
        this.chunkNumber = chunkNumber;
        this.data = data;
    }

    public static Chunk of(Encoded encodedChunk) throws DecodingException {
        Encoded[] list = encodedChunk.decodeList();
        return new Chunk((int)list[0].decodeLong(), list[1].decodeBytes());
    }

    public Encoded encode() {
        return Encoded.of(new Encoded[]{Encoded.of(this.chunkNumber), Encoded.of(this.data)});
    }

    public static int lengthOfEncodedChunkFromLengthOfInnerData(int length) {
        return length + 15 + 8;
    }

    public static int lengthOfInnerDataFromLengthOfEncodedChunk(int length) {
        return length - 15 - 8;
    }
}

