/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesCurve25519KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519KeyPair;
import io.olvid.engine.datatypes.key.symmetric.AuthEncAES256ThenSHA256Key;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import java.util.Arrays;

public class BackupSeed {
    public static final int BACKUP_SEED_LENGTH = 20;
    private static final char[] seedArray = "0123456789ABCDEFGHJKLMNPQRTUVWXY".toCharArray();
    private static final byte[] seedInvArray = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 20, 21, 22, 0, 23, 24, 25, 5, 26, 27, 28, 29, 30, 31, 2, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 20, 21, 22, 0, 23, 24, 25, 5, 26, 27, 28, 29, 30, 31, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final byte[] backupSeedBytes;

    public byte[] getBackupSeedBytes() {
        return this.backupSeedBytes;
    }

    public BackupSeed(byte[] backupSeedBytes) throws Exception {
        if (backupSeedBytes.length != 20) {
            throw new Exception("Bad backupSeedBytes length");
        }
        this.backupSeedBytes = backupSeedBytes;
    }

    public BackupSeed(String seedString) throws SeedTooLongException, SeedTooShortException {
        this.backupSeedBytes = new byte[20];
        int written = 0;
        for (char letter : seedString.toCharArray()) {
            byte val = seedInvArray[letter];
            if (val == -1) continue;
            if (written > 155) {
                throw new SeedTooLongException();
            }
            int byteOffset = written & 7;
            if (byteOffset < 4) {
                int n = written >> 3;
                this.backupSeedBytes[n] = (byte)(this.backupSeedBytes[n] | (byte)(val << 3 - byteOffset));
            } else {
                int n = written >> 3;
                this.backupSeedBytes[n] = (byte)(this.backupSeedBytes[n] | (byte)(val >> byteOffset - 3));
                int n2 = (written >> 3) + 1;
                this.backupSeedBytes[n2] = (byte)(this.backupSeedBytes[n2] | (byte)(val << 11 - byteOffset));
            }
            written += 5;
        }
        if (written != 160) {
            throw new SeedTooShortException();
        }
    }

    public static BackupSeed generate(PRNG prng) {
        try {
            return new BackupSeed(prng.bytes(20));
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public String toString() {
        char[] chars = new char[39];
        int read = 0;
        for (int i = 0; i < 39; ++i) {
            int charVal;
            if (i % 5 == 4) {
                chars[i] = 32;
                continue;
            }
            int byteOffset = read & 7;
            if (byteOffset < 4) {
                charVal = this.backupSeedBytes[read >> 3] >> 3 - byteOffset & 0x1F;
            } else {
                charVal = this.backupSeedBytes[read >> 3] << byteOffset - 3 & 0x1F;
                charVal |= (this.backupSeedBytes[(read >> 3) + 1] & 0xFF) >> 11 - byteOffset;
            }
            chars[i] = seedArray[charVal];
            read += 5;
        }
        return new String(chars);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BackupSeed)) {
            return false;
        }
        return Arrays.equals(this.backupSeedBytes, ((BackupSeed)o).backupSeedBytes);
    }

    public DerivedKeys deriveKeys() {
        byte[] fullSeedBytes = new byte[32];
        System.arraycopy(this.backupSeedBytes, 0, fullSeedBytes, 0, 20);
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", new Seed(fullSeedBytes));
        UID backupKeyUid = new UID(prng);
        EncryptionEciesCurve25519KeyPair encryptionKeyPair = EncryptionEciesCurve25519KeyPair.generate(prng);
        MAC mac = Suite.getMAC("hmac_sha-256");
        if (mac == null) {
            return null;
        }
        MACKey macKey = mac.generateKey(prng);
        return new DerivedKeys(backupKeyUid, encryptionKeyPair, macKey);
    }

    public DerivedKeysV2 deriveKeysV2() {
        byte[] fullSeedBytes = new byte[32];
        System.arraycopy(this.backupSeedBytes, 0, fullSeedBytes, 0, 20);
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", new Seed(fullSeedBytes));
        UID backupKeyUid = new UID(prng);
        AuthEnc authEnc = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256");
        if (authEnc == null) {
            return null;
        }
        AuthEncAES256ThenSHA256Key encryptionKey = (AuthEncAES256ThenSHA256Key)authEnc.generateKey(prng);
        ServerAuthenticationECSdsaCurve25519KeyPair authenticationKeyPair = ServerAuthenticationECSdsaCurve25519KeyPair.generate(prng);
        return new DerivedKeysV2(backupKeyUid, encryptionKey, authenticationKeyPair);
    }

    public static class SeedTooLongException
    extends Exception {
    }

    public static class SeedTooShortException
    extends Exception {
    }

    public static class DerivedKeys {
        public final UID backupKeyUid;
        public final EncryptionEciesCurve25519KeyPair encryptionKeyPair;
        public final MACKey macKey;

        private DerivedKeys(UID backupKeyUid, EncryptionEciesCurve25519KeyPair encryptionKeyPair, MACKey macKey) {
            this.backupKeyUid = backupKeyUid;
            this.encryptionKeyPair = encryptionKeyPair;
            this.macKey = macKey;
        }
    }

    public static class DerivedKeysV2 {
        public final UID backupKeyUid;
        public final AuthEncAES256ThenSHA256Key encryptionKey;
        public final ServerAuthenticationECSdsaCurve25519KeyPair authenticationKeyPair;

        private DerivedKeysV2(UID backupKeyUid, AuthEncAES256ThenSHA256Key encryptionKey, ServerAuthenticationECSdsaCurve25519KeyPair authenticationKeyPair) {
            this.backupKeyUid = backupKeyUid;
            this.encryptionKey = encryptionKey;
            this.authenticationKeyPair = authenticationKeyPair;
        }
    }
}

