/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.AuthEncAES256ThenSHA256;
import io.olvid.engine.crypto.Commitment;
import io.olvid.engine.crypto.CommitmentWithSHA256;
import io.olvid.engine.crypto.Curve25519;
import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.HashSHA256;
import io.olvid.engine.crypto.HashSHA512;
import io.olvid.engine.crypto.KDF;
import io.olvid.engine.crypto.KDFSha256;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.MACHmacSha256;
import io.olvid.engine.crypto.MDC;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.PRNGHmacSHA256;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.PRNGServiceHmacSHA256;
import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.PublicKeyEncryptionEciesCurve25519;
import io.olvid.engine.crypto.PublicKeyEncryptionEciesMDC;
import io.olvid.engine.crypto.ServerAuthentication;
import io.olvid.engine.crypto.ServerAuthenticationECSdsaCurve25519;
import io.olvid.engine.crypto.ServerAuthenticationECSdsaMDC;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.SignatureECSdsaCurve25519;
import io.olvid.engine.crypto.SignatureECSdsaMDC;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.key.CryptographicKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesCurve25519KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesMDCKeyPair;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCKeyPair;
import io.olvid.engine.datatypes.key.symmetric.SymmetricKey;
import java.security.InvalidParameterException;

public class Suite {
    public static final int LATEST_VERSION = 0;
    public static final int MINIMUM_ACCEPTABLE_VERSION = 0;

    public static AuthEnc getAuthEnc(String authEncName) {
        switch (authEncName) {
            case "ctr-aes-256_then_hmac_sha-256": {
                return new AuthEncAES256ThenSHA256();
            }
        }
        return null;
    }

    public static AuthEnc getDefaultAuthEnc(int obliviousEngineVersion) {
        return Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256");
    }

    public static Hash getHash(String hashName) {
        switch (hashName) {
            case "sha-512": {
                return new HashSHA512();
            }
        }
        return new HashSHA256();
    }

    public static PRNG getPRNG(String prngName, Seed seed) throws InvalidParameterException {
        switch (prngName) {
            default: 
        }
        return new PRNGHmacSHA256(seed);
    }

    public static PRNG getDefaultPRNG(int obliviousEngineVersion, Seed seed) {
        return Suite.getPRNG("prng_hmac_sha-256", seed);
    }

    public static PRNGService getPRNGService(String prngName) {
        switch (prngName) {
            default: 
        }
        return PRNGServiceHmacSHA256.getInstance();
    }

    public static EdwardCurve getCurve(String curveName) {
        switch (curveName) {
            case "Curve_25519": {
                return Curve25519.getInstance();
            }
        }
        return MDC.getInstance();
    }

    public static KDF getKDF(String kdfName) {
        switch (kdfName) {
            default: 
        }
        return new KDFSha256();
    }

    public static PublicKeyEncryption getPublicKeyEncryption(CryptographicKey key) {
        if (!(key instanceof PublicKey) && !(key instanceof PrivateKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 18) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new PublicKeyEncryptionEciesMDC();
            }
            case 1: {
                return new PublicKeyEncryptionEciesCurve25519();
            }
        }
        return null;
    }

    public static KeyPair generateServerAuthenticationKeyPair(Byte serverAuthenticationAlgoImplByte, PRNGService prng) {
        if (serverAuthenticationAlgoImplByte == null) {
            serverAuthenticationAlgoImplByte = Suite.getDefaultServerAuthenticationAlgoImplByte(0);
        }
        switch (serverAuthenticationAlgoImplByte) {
            case 0: {
                return ServerAuthenticationECSdsaMDCKeyPair.generate(prng);
            }
            case 1: {
                return ServerAuthenticationECSdsaCurve25519KeyPair.generate(prng);
            }
        }
        return null;
    }

    private static byte getDefaultServerAuthenticationAlgoImplByte(int engineVersion) {
        switch (engineVersion) {
            default: 
        }
        return 0;
    }

    public static KeyPair generateEncryptionKeyPair(Byte encryptionAlgoImplByte, PRNGService prng) {
        if (encryptionAlgoImplByte == null) {
            encryptionAlgoImplByte = Suite.getDefaultEncryptionAlgoImplByte(0);
        }
        switch (encryptionAlgoImplByte) {
            case 0: {
                return EncryptionEciesMDCKeyPair.generate(prng);
            }
            case 1: {
                return EncryptionEciesCurve25519KeyPair.generate(prng);
            }
        }
        return null;
    }

    private static byte getDefaultEncryptionAlgoImplByte(int engineVersion) {
        switch (engineVersion) {
            default: 
        }
        return 1;
    }

    public static ServerAuthentication getServerAuthentication(CryptographicKey key) {
        if (!(key instanceof PublicKey) && !(key instanceof PrivateKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 20) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new ServerAuthenticationECSdsaMDC();
            }
            case 1: {
                return new ServerAuthenticationECSdsaCurve25519();
            }
        }
        return null;
    }

    public static Signature getSignature(CryptographicKey key) {
        if (!(key instanceof PublicKey) && !(key instanceof PrivateKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 17) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new SignatureECSdsaMDC();
            }
            case 1: {
                return new SignatureECSdsaCurve25519();
            }
        }
        return null;
    }

    public static AuthEnc getAuthEnc(CryptographicKey key) {
        if (!(key instanceof SymmetricKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 2) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new AuthEncAES256ThenSHA256();
            }
        }
        return null;
    }

    public static MAC getMAC(CryptographicKey key) {
        if (!(key instanceof SymmetricKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 1) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new MACHmacSha256();
            }
        }
        return null;
    }

    public static MAC getMAC(String macName) {
        switch (macName) {
            case "hmac_sha-256": {
                return new MACHmacSha256();
            }
        }
        return null;
    }

    public static KDF getDefaultKDF(int obliviousEngineVersion) {
        return new KDFSha256();
    }

    public static PRNGService getDefaultPRNGService(int obliviousEngineVersion) {
        return Suite.getPRNGService("prng_hmac_sha-256");
    }

    public static Commitment getDefaultCommitment(int obliviousEngineVersion) {
        return new CommitmentWithSHA256();
    }

    public static MAC getDefaultMAC(int obliviousEngineVersion) {
        return new MACHmacSha256();
    }
}

