/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.MDC;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.SignatureECSdsa;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaMDCPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaMDCPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import java.security.InvalidKeyException;

class SignatureECSdsaMDC
extends SignatureECSdsa {
    SignatureECSdsaMDC() {
        super(MDC.getInstance());
    }

    @Override
    public byte[] sign(SignaturePrivateKey privateKey, byte[] message, PRNGService prng) throws InvalidKeyException {
        if (!(privateKey instanceof SignatureECSdsaMDCPrivateKey)) {
            throw new InvalidKeyException();
        }
        return this.internalSign((SignatureECSdsaMDCPrivateKey)privateKey, message, prng);
    }

    @Override
    public byte[] sign(SignaturePrivateKey privateKey, SignaturePublicKey publicKey, byte[] message, PRNGService prng) throws InvalidKeyException {
        if (!(privateKey instanceof SignatureECSdsaMDCPrivateKey)) {
            throw new InvalidKeyException();
        }
        return this.internalSign((SignatureECSdsaPrivateKey)privateKey, (SignatureECSdsaPublicKey)publicKey, message, prng);
    }

    @Override
    public boolean verify(SignaturePublicKey publicKey, byte[] message, byte[] signature) throws InvalidKeyException {
        if (!(publicKey instanceof SignatureECSdsaMDCPublicKey)) {
            throw new InvalidKeyException();
        }
        return this.internalVerify((SignatureECSdsaPublicKey)publicKey, message, signature);
    }
}

