/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.util.Arrays;

public abstract class Signature {
    public abstract byte[] sign(SignaturePrivateKey var1, byte[] var2, PRNGService var3) throws InvalidKeyException;

    public abstract byte[] sign(SignaturePrivateKey var1, SignaturePublicKey var2, byte[] var3, PRNGService var4) throws InvalidKeyException;

    public abstract boolean verify(SignaturePublicKey var1, byte[] var2, byte[] var3) throws InvalidKeyException;

    public static boolean verify(Constants.SignatureContext signatureContext, Identity[] identities, Identity signerIdentity, byte[] signature) throws Exception {
        try {
            SignaturePublicKey signaturePublicKey = signerIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Constants.getSignatureChallengePrefix(signatureContext));
            for (Identity identity : identities) {
                baos.write(identity.getBytes());
            }
            baos.write(Arrays.copyOfRange(signature, 0, 16));
            byte[] challenge = baos.toByteArray();
            baos.close();
            Signature signatureAlgo = Suite.getSignature(signaturePublicKey);
            return signatureAlgo.verify(signaturePublicKey, challenge, Arrays.copyOfRange(signature, 16, signature.length));
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return false;
        }
    }

    public static boolean verify(Constants.SignatureContext signatureContext, UID deviceUidA, UID deviceUidB, Identity identityA, Identity identityB, Identity signerIdentity, byte[] signature) throws Exception {
        try {
            SignaturePublicKey signaturePublicKey = signerIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Constants.getSignatureChallengePrefix(signatureContext));
            baos.write(deviceUidA.getBytes());
            baos.write(deviceUidB.getBytes());
            baos.write(identityA.getBytes());
            baos.write(identityB.getBytes());
            baos.write(Arrays.copyOfRange(signature, 0, 16));
            byte[] challenge = baos.toByteArray();
            baos.close();
            Signature signatureAlgo = Suite.getSignature(signaturePublicKey);
            return signatureAlgo.verify(signaturePublicKey, challenge, Arrays.copyOfRange(signature, 16, signature.length));
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return false;
        }
    }

    public static boolean verify(Constants.SignatureContext signatureContext, byte[] block, Identity signerIdentity, byte[] signature) throws Exception {
        try {
            SignaturePublicKey signaturePublicKey = signerIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            byte[] prefix = Constants.getSignatureChallengePrefix(signatureContext);
            byte[] padding = Arrays.copyOfRange(signature, 0, 16);
            byte[] challenge = new byte[prefix.length + block.length + 16];
            System.arraycopy(prefix, 0, challenge, 0, prefix.length);
            System.arraycopy(block, 0, challenge, prefix.length, block.length);
            System.arraycopy(padding, 0, challenge, prefix.length + block.length, 16);
            Signature signatureAlgo = Suite.getSignature(signaturePublicKey);
            return signatureAlgo.verify(signaturePublicKey, challenge, Arrays.copyOfRange(signature, 16, signature.length));
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return false;
        }
    }

    public static boolean verify(Constants.SignatureContext signatureContext, GroupV2.Identifier groupIdentifier, byte[] nonce, Identity contactIdentity, Identity signerIdentity, byte[] signature) throws Exception {
        try {
            SignaturePublicKey signaturePublicKey = signerIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Constants.getSignatureChallengePrefix(signatureContext));
            baos.write(groupIdentifier.getBytes());
            baos.write(nonce);
            if (contactIdentity != null) {
                baos.write(contactIdentity.getBytes());
            }
            baos.write(Arrays.copyOfRange(signature, 0, 16));
            byte[] challenge = baos.toByteArray();
            baos.close();
            Signature signatureAlgo = Suite.getSignature(signaturePublicKey);
            return signatureAlgo.verify(signaturePublicKey, challenge, Arrays.copyOfRange(signature, 16, signature.length));
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return false;
        }
    }

    public static byte[] sign(Constants.SignatureContext signatureContext, SignaturePrivateKey signaturePrivateKey, PRNGService prng) {
        try {
            byte[] prefix = Constants.getSignatureChallengePrefix(signatureContext);
            byte[] padding = prng.bytes(16);
            byte[] challenge = new byte[prefix.length + 16];
            System.arraycopy(prefix, 0, challenge, 0, prefix.length);
            System.arraycopy(padding, 0, challenge, prefix.length, 16);
            byte[] signatureBytes = Suite.getSignature(signaturePrivateKey).sign(signaturePrivateKey, challenge, prng);
            byte[] output = new byte[16 + signatureBytes.length];
            System.arraycopy(padding, 0, output, 0, 16);
            System.arraycopy(signatureBytes, 0, output, 16, signatureBytes.length);
            return output;
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
    }

    public static byte[] sign(Constants.SignatureContext signatureContext, byte[] data, SignaturePrivateKey signaturePrivateKey, PRNGService prng) {
        try {
            byte[] prefix = Constants.getSignatureChallengePrefix(signatureContext);
            byte[] padding = prng.bytes(16);
            byte[] challenge = new byte[prefix.length + data.length + 16];
            System.arraycopy(prefix, 0, challenge, 0, prefix.length);
            System.arraycopy(data, 0, challenge, prefix.length, data.length);
            System.arraycopy(padding, 0, challenge, prefix.length + data.length, 16);
            byte[] signatureBytes = Suite.getSignature(signaturePrivateKey).sign(signaturePrivateKey, challenge, prng);
            byte[] output = new byte[16 + signatureBytes.length];
            System.arraycopy(padding, 0, output, 0, 16);
            System.arraycopy(signatureBytes, 0, output, 16, signatureBytes.length);
            return output;
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
    }
}

