/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.ServerAuthentication;
import io.olvid.engine.crypto.SignatureECSdsa;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaPublicKey;
import java.security.InvalidKeyException;

abstract class ServerAuthenticationECSdsa
implements ServerAuthentication {
    private final SignatureECSdsa signatureECSdsa;

    ServerAuthenticationECSdsa(SignatureECSdsa signatureECSdsa) {
        this.signatureECSdsa = signatureECSdsa;
    }

    byte[] internalSolveChallenge(byte[] challenge, ServerAuthenticationECSdsaPrivateKey privateKey, ServerAuthenticationECSdsaPublicKey publicKey, PRNGService prng) throws InvalidKeyException {
        byte[] padding = prng.bytes(16);
        byte[] formattedChallenge = new byte[Constants.SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX.length + challenge.length + 16];
        System.arraycopy(Constants.SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX, 0, formattedChallenge, 0, Constants.SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX.length);
        System.arraycopy(challenge, 0, formattedChallenge, Constants.SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX.length, challenge.length);
        System.arraycopy(padding, 0, formattedChallenge, Constants.SERVER_AUTHENTICATION_SIGNATURE_CHALLENGE_PREFIX.length + challenge.length, 16);
        byte[] signature = this.signatureECSdsa.sign(privateKey.getSignaturePrivateKey(), publicKey.getSignaturePublicKey(), formattedChallenge, prng);
        byte[] response = new byte[16 + signature.length];
        System.arraycopy(padding, 0, response, 0, 16);
        System.arraycopy(signature, 0, response, 16, signature.length);
        return response;
    }
}

