/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public abstract class SAS {
    public static byte[] compute(Seed seedAlice, Seed seedBob, int numberOfDigits) {
        Seed seed = new Seed(seedAlice, seedBob);
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", seed);
        BigInteger max = BigInteger.valueOf(10L).pow(numberOfDigits);
        BigInteger sas = prng.bigInt(max).add(max);
        return sas.toString(10).substring(1).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] computeDouble(Seed seedAlice, Seed seedBob, Identity identityBob, int numberOfDigits) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] bytesIdentity = identityBob.getBytes();
        byte[] toHash = new byte[bytesIdentity.length + seedAlice.length];
        System.arraycopy(bytesIdentity, 0, toHash, 0, bytesIdentity.length);
        System.arraycopy(seedAlice.getBytes(), 0, toHash, bytesIdentity.length, seedAlice.length);
        byte[] hash = sha256.digest(toHash);
        byte[] xor = new byte[Math.min(hash.length, seedBob.length)];
        for (int i = 0; i < xor.length; ++i) {
            xor[i] = (byte)(seedBob.getBytes()[i] ^ hash[i]);
        }
        Seed seed = new Seed(xor);
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", seed);
        BigInteger max = BigInteger.valueOf(10L).pow(2 * numberOfDigits);
        BigInteger sas = prng.bigInt(max).add(max);
        return sas.toString(10).substring(1).getBytes(StandardCharsets.UTF_8);
    }

    public static String computeSimple(Seed seedAlice, Seed seedBob, byte[] rawPublicKeyBob, int numberOfDigits) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] toHash = new byte[rawPublicKeyBob.length + seedAlice.length];
        System.arraycopy(rawPublicKeyBob, 0, toHash, 0, rawPublicKeyBob.length);
        System.arraycopy(seedAlice.getBytes(), 0, toHash, rawPublicKeyBob.length, seedAlice.length);
        byte[] hash = sha256.digest(toHash);
        byte[] xor = new byte[Math.min(hash.length, seedBob.length)];
        for (int i = 0; i < xor.length; ++i) {
            xor[i] = (byte)(seedBob.getBytes()[i] ^ hash[i]);
        }
        Seed seed = new Seed(xor);
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", seed);
        BigInteger max = BigInteger.valueOf(10L).pow(numberOfDigits);
        BigInteger sas = prng.bigInt(max).add(max);
        return sas.toString(10).substring(1);
    }
}

