/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.AuthEncAES256ThenSHA256;
import io.olvid.engine.crypto.KemEcies256Kem512;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.containers.CiphertextAndKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import java.security.InvalidKeyException;
import java.util.Arrays;

abstract class PublicKeyEncryptionEcies
implements PublicKeyEncryption {
    private final KemEcies256Kem512 kem;
    private final AuthEncAES256ThenSHA256 dem;

    protected PublicKeyEncryptionEcies(KemEcies256Kem512 kem) {
        this.kem = kem;
        this.dem = new AuthEncAES256ThenSHA256();
    }

    @Override
    public EncryptedBytes encrypt(EncryptionPublicKey publicKey, byte[] plaintext, PRNGService prng) throws InvalidKeyException {
        byte[] ciphertextBytes = new byte[this.kem.ciphertextLength() + this.dem.ciphertextLengthFromPlaintextLength(plaintext.length)];
        CiphertextAndKey ciphertextAndKey = this.kem.encrypt(publicKey, prng);
        System.arraycopy(ciphertextAndKey.getCiphertext().getBytes(), 0, ciphertextBytes, 0, this.kem.ciphertextLength());
        EncryptedBytes demCiphertext = this.dem.encrypt(ciphertextAndKey.getKey(), plaintext, prng);
        System.arraycopy(demCiphertext.getBytes(), 0, ciphertextBytes, this.kem.ciphertextLength(), this.dem.ciphertextLengthFromPlaintextLength(plaintext.length));
        return new EncryptedBytes(ciphertextBytes);
    }

    @Override
    public byte[] decrypt(EncryptionPrivateKey privateKey, EncryptedBytes ciphertext) throws InvalidKeyException, DecryptionException {
        byte[] ciphertextBytes = ciphertext.getBytes();
        byte[] kemCiphertext = Arrays.copyOfRange(ciphertext.getBytes(), 0, 32);
        AuthEncKey key = this.kem.decrypt(privateKey, kemCiphertext);
        EncryptedBytes demCiphertext = new EncryptedBytes(Arrays.copyOfRange(ciphertext.getBytes(), 32, ciphertextBytes.length));
        return this.dem.decrypt(key, demCiphertext);
    }

    @Override
    public CiphertextAndKey kemEncrypt(EncryptionPublicKey publicKey, PRNGService prng) throws InvalidKeyException {
        return this.kem.encrypt(publicKey, prng);
    }

    @Override
    public AuthEncKey kemDecrypt(EncryptionPrivateKey privateKey, EncryptedBytes ciphertext) throws InvalidKeyException, DecryptionException {
        if (ciphertext.length != 32) {
            throw new DecryptionException("Bad kem ciphertext length");
        }
        return this.kem.decrypt(privateKey, ciphertext.getBytes());
    }
}

