/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class ProofOfWorkEngine {
    private static final int N = 256;
    private static final int R = 128;
    private static final int W = 4;

    private static Column[] generateMatrix(Seed seed) {
        Column[] H = new Column[256];
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", seed);
        byte[] bytes = prng.bytes(4096);
        for (int i = 0; i < 256; ++i) {
            H[i] = new Column(new int[]{i}, bytes, i * 128 / 8);
        }
        return H;
    }

    public static Encoded solveChallenge(Encoded challenge) throws DecodingException {
        Encoded[] list = challenge.decodeList();
        if (list.length != 2) {
            throw new DecodingException();
        }
        Seed seed = list[0].decodeSeed();
        byte[] Sbytes = list[1].decodeBytes();
        if (Sbytes.length != 16) {
            throw new DecodingException();
        }
        Column S = new Column(new int[0], Sbytes);
        Column[] H = ProofOfWorkEngine.generateMatrix(seed);
        HashSet<Column> setHalf = new HashSet<Column>();
        HashSet<Column> setHalfS = new HashSet<Column>();
        for (int i = 1; i < 256; ++i) {
            for (int j = 0; j < i; ++j) {
                Column xor = H[i].xor(H[j]);
                setHalf.add(xor);
                setHalfS.add(xor.xor(S));
            }
        }
        setHalf.retainAll(setHalfS);
        Iterator iterator = setHalf.iterator();
        if (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            HashSet<Column> single = new HashSet<Column>();
            single.add(col);
            setHalfS.retainAll(single);
            Iterator iterator2 = setHalfS.iterator();
            if (iterator2.hasNext()) {
                Column col2 = (Column)iterator2.next();
                int[] indexes = col.xor((Column)col2).indexes;
                Arrays.sort(indexes);
                Encoded[] encodedIndexes = new Encoded[indexes.length];
                for (int i = 0; i < indexes.length; ++i) {
                    encodedIndexes[i] = Encoded.of(indexes[i]);
                }
                return Encoded.of(encodedIndexes);
            }
        }
        Logger.w("No solution was found for this challenge...");
        return null;
    }

    private static class Column {
        final long[] val = new long[2];
        final int[] indexes;

        Column(int[] indexes, byte[] bytes) {
            this.indexes = indexes;
            for (int i = 0; i < bytes.length; ++i) {
                int n = i / 8;
                this.val[n] = this.val[n] ^ (long)(bytes[i] & 0xFF) << (i & 7) * 8;
            }
        }

        Column(int[] indexes, byte[] bytes, int offset) {
            this.indexes = indexes;
            for (int i = 0; i < 16; ++i) {
                int n = i / 8;
                this.val[n] = this.val[n] ^ (long)(bytes[offset + i] & 0xFF) << (i & 7) * 8;
            }
        }

        Column(int[] indexes, long[] val) {
            this.indexes = indexes;
            System.arraycopy(val, 0, this.val, 0, 2);
        }

        public Column xor(Column other) {
            long[] xorVal = new long[this.val.length];
            for (int i = 0; i < this.val.length; ++i) {
                xorVal[i] = this.val[i] ^ other.val[i];
            }
            int[] xoredIndexes = new int[this.indexes.length + other.indexes.length];
            System.arraycopy(this.indexes, 0, xoredIndexes, 0, this.indexes.length);
            System.arraycopy(other.indexes, 0, xoredIndexes, this.indexes.length, other.indexes.length);
            return new Column(xoredIndexes, xorVal);
        }

        public boolean equals(Object o) {
            return o instanceof Column && Arrays.equals(this.val, ((Column)o).val);
        }

        public int hashCode() {
            return Arrays.hashCode(this.val);
        }
    }
}

