/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.KDF;
import io.olvid.engine.crypto.KDFDelegateForHmacSHA256;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class MACHmacSha256
implements MAC {
    static final int OUTPUT_LENGTH = 32;

    MACHmacSha256() {
    }

    @Override
    public int outputLength() {
        return 32;
    }

    @Override
    public byte[] digest(MACKey key, byte[] bytes) throws InvalidKeyException {
        try {
            Mac h = Mac.getInstance("HmacSHA256");
            h.init(new SecretKeySpec(key.getKeyBytes(), "HmacSHA256"));
            return h.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Override
    public byte[] digest(MACKey key, byte[] bytes, int inputLen) throws InvalidKeyException {
        try {
            Mac h = Mac.getInstance("HmacSHA256");
            h.init(new SecretKeySpec(key.getKeyBytes(), "HmacSHA256"));
            h.update(bytes, 0, inputLen);
            return h.doFinal();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Override
    public boolean verify(MACKey key, byte[] bytes, byte[] mac) throws InvalidKeyException {
        byte[] newMac = this.digest(key, bytes);
        return Arrays.equals(mac, newMac);
    }

    @Override
    public MACKey generateKey(PRNG prng) {
        KDF kdf = Suite.getKDF("kdf_sha-256");
        Seed kdfSeed = new Seed(prng);
        try {
            return (MACKey)kdf.gen(kdfSeed, new KDFDelegateForHmacSHA256())[0];
        }
        catch (Exception e) {
            return null;
        }
    }
}

