/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.datatypes.EdwardCurvePoint;
import java.math.BigInteger;

class Curve25519
extends EdwardCurve {
    private static final Curve25519 instance = new Curve25519();

    private Curve25519() {
        this.p = new BigInteger(1, new byte[]{127, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -19});
        this.G = EdwardCurvePoint.noCheckFactory(new BigInteger(1, new byte[]{21, -102, 104, 73, -28, 76, 60, 127, 6, 27, 61, 87, 15, -60, -19, 91, 93, 20, -56, -70, 66, 83, -33, 73, -52, 126, -33, -128, -11, 51, -83, -101}), new BigInteger(1, new byte[]{102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 88}), this);
        this.q = new BigInteger(1, new byte[]{16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, -34, -7, -34, -94, -9, -100, -42, 88, 18, 99, 26, 92, -11, -45, -19});
        this.d = new BigInteger(1, new byte[]{45, -4, -109, 17, -44, -112, 1, -116, 115, 56, -65, -122, -120, -122, 23, 103, -1, -113, -11, -78, -66, -66, 39, 84, -118, 20, -78, 53, -20, -90, -121, 74});
        this.nu = BigInteger.valueOf(8L);
        this.nuInv = this.nu.modInverse(this.q);
        this.cardinality = this.q.multiply(this.nu);
        this.tonelliNonQR = BigInteger.valueOf(2L);
        this.tonelliT = this.p.shiftRight(2);
        this.tonelliS = 2;
        this.byteLength = 32;
    }

    public static Curve25519 getInstance() {
        return instance;
    }
}

