/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.KDF;
import io.olvid.engine.crypto.KDFDelegateForAuthEncAES256ThenSHA256;
import io.olvid.engine.crypto.KDFDelegateForHmacSHA256;
import io.olvid.engine.crypto.KDFDelegateForSymEncCtrAES256;
import io.olvid.engine.crypto.MACHmacSha256;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.SymEncCtrAES256;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.key.symmetric.AuthEncAES256ThenSHA256Key;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.datatypes.key.symmetric.MACHmacSha256Key;
import io.olvid.engine.datatypes.key.symmetric.SymEncCTRAES256Key;
import java.security.InvalidKeyException;
import java.util.Arrays;

class AuthEncAES256ThenSHA256
implements AuthEnc {
    AuthEncAES256ThenSHA256() {
    }

    @Override
    public int keyByteLength() {
        return 64;
    }

    @Override
    public int ciphertextLengthFromPlaintextLength(int plaintextLength) {
        return plaintextLength + 8 + 32;
    }

    @Override
    public int plaintextLengthFromCiphertextLength(int ciphertextLength) {
        return ciphertextLength - 8 - 32;
    }

    @Override
    public EncryptedBytes encrypt(AuthEncKey key, byte[] plaintext, PRNG prng) throws InvalidKeyException {
        if (!(key instanceof AuthEncAES256ThenSHA256Key)) {
            throw new InvalidKeyException();
        }
        MACHmacSha256Key macKey = ((AuthEncAES256ThenSHA256Key)key).getMacKey();
        SymEncCTRAES256Key encKey = ((AuthEncAES256ThenSHA256Key)key).getEncKey();
        MACHmacSha256 mac = new MACHmacSha256();
        SymEncCtrAES256 enc = new SymEncCtrAES256(encKey);
        byte[] ciphertext = new byte[this.ciphertextLengthFromPlaintextLength(plaintext.length)];
        byte[] iv = prng.bytes(8);
        enc.encrypt(iv, plaintext, ciphertext);
        byte[] hash = mac.digest(macKey, ciphertext, enc.ciphertextLengthFromPlaintextLength(plaintext.length));
        System.arraycopy(hash, 0, ciphertext, enc.ciphertextLengthFromPlaintextLength(plaintext.length), hash.length);
        return new EncryptedBytes(ciphertext);
    }

    @Override
    public byte[] decrypt(AuthEncKey key, EncryptedBytes ciphertext) throws DecryptionException, InvalidKeyException {
        if (!(key instanceof AuthEncAES256ThenSHA256Key)) {
            throw new InvalidKeyException();
        }
        MACHmacSha256Key macKey = ((AuthEncAES256ThenSHA256Key)key).getMacKey();
        SymEncCTRAES256Key encKey = ((AuthEncAES256ThenSHA256Key)key).getEncKey();
        MACHmacSha256 mac = new MACHmacSha256();
        SymEncCtrAES256 enc = new SymEncCtrAES256(encKey);
        byte[] ciphertextBytes = ciphertext.getBytes();
        byte[] hash = Arrays.copyOfRange(ciphertextBytes, ciphertextBytes.length - mac.outputLength(), ciphertextBytes.length);
        byte[] encryptedBytes = Arrays.copyOfRange(ciphertextBytes, 0, ciphertextBytes.length - mac.outputLength());
        if (!mac.verify(macKey, encryptedBytes, hash)) {
            throw new DecryptionException();
        }
        return enc.decrypt(new EncryptedBytes(encryptedBytes));
    }

    @Override
    public KDF.Delegate getKDFDelegate() {
        return new KDFDelegateForAuthEncAES256ThenSHA256();
    }

    @Override
    public AuthEncKey generateKey(PRNG prng) {
        KDF kdf = Suite.getKDF("kdf_sha-256");
        Seed kdfSeed = new Seed(prng);
        try {
            return (AuthEncKey)kdf.gen(kdfSeed, this.getKDFDelegate())[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AuthEncKey generateMessageKey(PRNG prng, byte[] message) {
        KDF kdf = Suite.getKDF("kdf_sha-256");
        Seed encryptionKdfSeed = new Seed(prng);
        SymEncCTRAES256Key symEncCTRAES256Key = (SymEncCTRAES256Key)kdf.gen(encryptionKdfSeed, new KDFDelegateForSymEncCtrAES256())[0];
        byte[] concatenation = new byte[symEncCTRAES256Key.getKeyLength() + message.length];
        System.arraycopy(symEncCTRAES256Key.getKeyBytes(), 0, concatenation, 0, symEncCTRAES256Key.getKeyLength());
        System.arraycopy(message, 0, concatenation, symEncCTRAES256Key.getKeyLength(), message.length);
        MACHmacSha256Key hmacSha256Key = (MACHmacSha256Key)kdf.gen(new Seed(concatenation), new KDFDelegateForHmacSHA256())[0];
        return AuthEncAES256ThenSHA256Key.of(hmacSha256Key.getKeyBytes(), symEncCTRAES256Key.getKeyBytes());
    }

    @Override
    public boolean verifyMessageKey(AuthEncKey authEncKey, byte[] message) {
        KDF kdf = Suite.getKDF("kdf_sha-256");
        if (authEncKey instanceof AuthEncAES256ThenSHA256Key) {
            SymEncCTRAES256Key symEncCTRAES256Key = ((AuthEncAES256ThenSHA256Key)authEncKey).getEncKey();
            byte[] concatenation = new byte[symEncCTRAES256Key.getKeyLength() + message.length];
            System.arraycopy(symEncCTRAES256Key.getKeyBytes(), 0, concatenation, 0, symEncCTRAES256Key.getKeyLength());
            System.arraycopy(message, 0, concatenation, symEncCTRAES256Key.getKeyLength(), message.length);
            MACHmacSha256Key hmacSha256Key = (MACHmacSha256Key)kdf.gen(new Seed(concatenation), new KDFDelegateForHmacSHA256())[0];
            return Arrays.equals(hmacSha256Key.getKeyBytes(), ((AuthEncAES256ThenSHA256Key)authEncKey).getMacKey().getKeyBytes());
        }
        return false;
    }
}

