/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.datatypes.Channel;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;

public class UserInterfaceChannel
extends Channel {
    private UserInterfaceChannel() {
    }

    private void doPost(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        switch (message.getMessageType()) {
            case 2: {
                ChannelDialogMessageToSend channelDialogMessageToSend = (ChannelDialogMessageToSend)message;
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("session_key", channelManagerSession.session);
                userInfo.put("message_to_send_key", channelDialogMessageToSend);
                channelManagerSession.notificationPostingDelegate.postNotification("channel_notification_new_ui_dialog", userInfo);
                break;
            }
            default: {
                Logger.i("Trying to post a message of type " + message.getMessageType() + " on a UserInterfaceChannel.");
            }
        }
    }

    public static UID post(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        UserInterfaceChannel[] userInterfaceChannels = UserInterfaceChannel.acceptableChannelsForPosting(channelManagerSession, message);
        if (userInterfaceChannels.length == 0) {
            Logger.i("No acceptable channels were found for posting");
            throw new NoAcceptableChannelException();
        }
        for (UserInterfaceChannel userInterfaceChannel : userInterfaceChannels) {
            userInterfaceChannel.doPost(channelManagerSession, message, prng);
        }
        return null;
    }

    private static UserInterfaceChannel[] acceptableChannelsForPosting(ChannelManagerSession channelManagerSession, ChannelMessageToSend message) throws SQLException {
        switch (message.getSendChannelInfo().getChannelType()) {
            case 5: {
                if (channelManagerSession.identityDelegate.isOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getToIdentity()) || Objects.equals(message.getSendChannelInfo().getToIdentity().getServer(), "ephemeral_fake_server")) {
                    return new UserInterfaceChannel[]{new UserInterfaceChannel()};
                }
                return new UserInterfaceChannel[0];
            }
        }
        return new UserInterfaceChannel[0];
    }
}

