/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.datatypes.Channel;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.ServerQuery;
import java.sql.SQLException;
import java.util.Objects;

public class ServerQueryChannel
extends Channel {
    private ServerQueryChannel() {
    }

    private void doPost(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        switch (message.getMessageType()) {
            case 4: {
                ChannelServerQueryMessageToSend channelServerQueryMessageToSend = (ChannelServerQueryMessageToSend)message;
                ServerQuery serverQuery = new ServerQuery(channelServerQueryMessageToSend.getEncodedElements(), channelServerQueryMessageToSend.getSendChannelInfo().getToIdentity(), channelServerQueryMessageToSend.getSendChannelInfo().getServerQueryType());
                channelManagerSession.networkFetchDelegate.createPendingServerQuery(channelManagerSession.session, serverQuery);
                break;
            }
            default: {
                Logger.i("Trying to post a message of type " + message.getMessageType() + " on a ServerQueryChannel.");
            }
        }
    }

    public static UID post(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        ServerQueryChannel[] serverQueryChannels = ServerQueryChannel.acceptableChannelsForPosting(channelManagerSession, message);
        if (serverQueryChannels.length == 0) {
            Logger.i("No acceptable channels were found for posting");
            throw new NoAcceptableChannelException();
        }
        for (ServerQueryChannel serverQueryChannel : serverQueryChannels) {
            serverQueryChannel.doPost(channelManagerSession, message, prng);
        }
        return null;
    }

    private static ServerQueryChannel[] acceptableChannelsForPosting(ChannelManagerSession channelManagerSession, ChannelMessageToSend message) throws SQLException {
        switch (message.getSendChannelInfo().getChannelType()) {
            case 6: {
                if (channelManagerSession.identityDelegate.isOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getToIdentity()) || Objects.equals(message.getSendChannelInfo().getToIdentity().getServer(), "ephemeral_fake_server")) {
                    return new ServerQueryChannel[]{new ServerQueryChannel()};
                }
                return new ServerQueryChannel[0];
            }
        }
        return new ServerQueryChannel[0];
    }
}

