/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.NetworkChannel;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.AuthEncKeyAndChannelInfo;
import io.olvid.engine.datatypes.containers.MessageToSend;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.metamanager.PreKeyEncryptionDelegate;
import java.sql.SQLException;

public class PreKeyChannel
extends NetworkChannel {
    private final Session session;
    private final Identity fromIdentity;
    private final Identity toIdentity;
    private final UID toDeviceUid;
    private final PreKeyEncryptionDelegate preKeyEncryptionDelegate;

    public PreKeyChannel(Session session, Identity fromIdentity, Identity toIdentity, UID toDeviceUid, PreKeyEncryptionDelegate preKeyEncryptionDelegate) {
        this.session = session;
        this.fromIdentity = fromIdentity;
        this.toIdentity = toIdentity;
        this.toDeviceUid = toDeviceUid;
        this.preKeyEncryptionDelegate = preKeyEncryptionDelegate;
    }

    @Override
    public MessageToSend.Header wrapMessageKey(AuthEncKey messageKey, PRNGService prng, boolean partOfFullRatchetProtocol) {
        if (this.preKeyEncryptionDelegate == null) {
            return null;
        }
        EncryptedBytes wrappedKey = this.preKeyEncryptionDelegate.wrapWithPreKey(this.session, messageKey, this.fromIdentity, this.toIdentity, this.toDeviceUid, prng);
        return new MessageToSend.Header(this.toDeviceUid, this.toIdentity, wrappedKey);
    }

    public static AuthEncKeyAndChannelInfo unwrapMessageKey(ChannelManagerSession channelManagerSession, NetworkReceivedMessage.Header header) throws SQLException {
        if (channelManagerSession.preKeyEncryptionDelegate == null) {
            return null;
        }
        return channelManagerSession.preKeyEncryptionDelegate.unwrapWithPreKey(channelManagerSession.session, header.getWrappedKey(), header.getOwnedIdentity());
    }
}

