/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.databases.ObliviousChannel;
import io.olvid.engine.channel.datatypes.AsymmetricChannel;
import io.olvid.engine.channel.datatypes.Channel;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelApplicationMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.MessageToSend;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;

public abstract class NetworkChannel
extends Channel {
    public abstract MessageToSend.Header wrapMessageKey(AuthEncKey var1, PRNGService var2, boolean var3);

    public static NetworkChannel[] acceptableChannelsForPosting(ChannelManagerSession channelManagerSession, ChannelMessageToSend message) throws Exception {
        switch (message.getSendChannelInfo().getChannelType()) {
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                return ObliviousChannel.acceptableChannelsForPosting(channelManagerSession, message);
            }
            case 2: 
            case 4: {
                return AsymmetricChannel.acceptableChannelsForPosting(message, channelManagerSession.encryptionForIdentityDelegate);
            }
        }
        return new NetworkChannel[0];
    }

    public static UID post(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        if (channelManagerSession.networkSendDelegate == null) {
            Logger.w("NetworkSendDelegate not set yet when posting a ChannelMessageToSend.");
            throw new Exception();
        }
        NetworkChannel[] networkChannels = NetworkChannel.acceptableChannelsForPosting(channelManagerSession, message);
        if (networkChannels.length == 0) {
            Logger.i("No acceptable channels were found for posting");
            throw new NoAcceptableChannelException();
        }
        int suiteVersion = 0;
        for (NetworkChannel networkChannel : networkChannels) {
            if (networkChannel.getObliviousEngineVersion() >= suiteVersion) continue;
            suiteVersion = networkChannel.getObliviousEngineVersion();
        }
        AuthEnc authEnc = Suite.getDefaultAuthEnc(suiteVersion);
        UID messageUid = new UID(prng);
        channelManagerSession.networkSendDelegate.post(channelManagerSession.session, switch (message.getMessageType()) {
            case 1 -> {
                EncryptedBytes encryptedExtendedContent;
                if (!(message instanceof ChannelApplicationMessageToSend)) {
                    Logger.w("Trying to post a message of type " + message.getMessageType() + " that is not a ChannelApplicationMessageToSend.");
                    throw new Exception();
                }
                ChannelApplicationMessageToSend channelApplicationMessageToSend = (ChannelApplicationMessageToSend)message;
                ChannelApplicationMessageToSend.Attachment[] attachments = channelApplicationMessageToSend.getAttachments();
                Encoded[] listOfEncodedAttachments = new Encoded[attachments.length + 1];
                MessageToSend.Attachment[] messageToSendAttachments = new MessageToSend.Attachment[attachments.length];
                for (int i = 0; i < attachments.length; ++i) {
                    AuthEncKey attachmentKey = authEnc.generateKey(prng);
                    listOfEncodedAttachments[i] = Encoded.of(new Encoded[]{Encoded.of(attachmentKey), Encoded.of(attachments[i].getMetadata())});
                    messageToSendAttachments[i] = new MessageToSend.Attachment(attachments[i].getUrl(), attachments[i].isDeleteAfterSend(), attachments[i].getAttachmentLength(), attachmentKey);
                }
                listOfEncodedAttachments[attachments.length] = Encoded.of(channelApplicationMessageToSend.getMessagePayload());
                Encoded plaintextContent = Encoded.of(new Encoded[]{Encoded.of(1L), Encoded.of(listOfEncodedAttachments)});
                byte[] paddedPlaintext = new byte[(plaintextContent.getBytes().length - 1 | 0x1FF) + 1];
                System.arraycopy(plaintextContent.getBytes(), 0, paddedPlaintext, 0, plaintextContent.getBytes().length);
                AuthEncKey messageKey = authEnc.generateMessageKey(prng, paddedPlaintext);
                MessageToSend.Header[] headers = NetworkChannel.generateHeaders(networkChannels, false, messageKey, prng);
                String server = NetworkChannel.getServer(headers);
                EncryptedBytes encryptedContent = authEnc.encrypt(messageKey, paddedPlaintext, prng);
                if (channelApplicationMessageToSend.getExtendedMessagePayload() != null) {
                    PRNG extendedMessagePRNG = Suite.getDefaultPRNG(0, Seed.of(messageKey));
                    AuthEncKey extendedMessageAuthEncKey = authEnc.generateKey(extendedMessagePRNG);
                    encryptedExtendedContent = authEnc.encrypt(extendedMessageAuthEncKey, channelApplicationMessageToSend.getExtendedMessagePayload(), prng);
                } else {
                    encryptedExtendedContent = null;
                }
                yield new MessageToSend(message.getSendChannelInfo().getFromIdentity(), messageUid, server, encryptedContent, encryptedExtendedContent, headers, messageToSendAttachments, channelApplicationMessageToSend.hasUserContent(), channelApplicationMessageToSend.isVoipMessage());
            }
            case 0 -> {
                if (!(message instanceof ChannelProtocolMessageToSend)) {
                    Logger.w("Trying to post a message of type " + message.getMessageType() + " that is not a ChannelProtocolMessageToSend.");
                    throw new Exception();
                }
                ChannelProtocolMessageToSend channelProtocolMessageToSend = (ChannelProtocolMessageToSend)message;
                Encoded plaintextContent = Encoded.of(new Encoded[]{Encoded.of(0L), channelProtocolMessageToSend.getEncodedElements()});
                byte[] paddedPlaintext = new byte[(plaintextContent.getBytes().length - 1 | 0x1FF) + 1];
                System.arraycopy(plaintextContent.getBytes(), 0, paddedPlaintext, 0, plaintextContent.getBytes().length);
                AuthEncKey messageKey = authEnc.generateMessageKey(prng, paddedPlaintext);
                MessageToSend.Header[] headers = NetworkChannel.generateHeaders(networkChannels, true, messageKey, prng);
                String server = NetworkChannel.getServer(headers);
                EncryptedBytes encryptedContent = authEnc.encrypt(messageKey, paddedPlaintext, prng);
                yield new MessageToSend(message.getSendChannelInfo().getFromIdentity(), messageUid, server, encryptedContent, headers, channelProtocolMessageToSend.hasUserContent());
            }
            default -> {
                Logger.w("Trying to post a message of type " + message.getMessageType() + " on a network channel.");
                throw new Exception();
            }
        });
        return messageUid;
    }

    private static MessageToSend.Header[] generateHeaders(NetworkChannel[] networkChannels, boolean protocolMessage, AuthEncKey messageKey, PRNGService prng) {
        MessageToSend.Header[] headers = new MessageToSend.Header[networkChannels.length];
        for (int i = 0; i < networkChannels.length; ++i) {
            headers[i] = networkChannels[i].wrapMessageKey(messageKey, prng, protocolMessage);
        }
        return headers;
    }

    private static String getServer(MessageToSend.Header[] headers) throws Exception {
        String server = headers[0].getToIdentity().getServer();
        for (int i = 1; i < headers.length; ++i) {
            if (server.equals(headers[i].getToIdentity().getServer())) continue;
            Logger.w("Server mismatch in the headers of a ChannelMessageToSend");
            throw new Exception();
        }
        return server;
    }
}

