/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.datatypes.Channel;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogResponseMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerResponseMessageToSend;
import io.olvid.engine.datatypes.containers.ProtocolReceivedDialogResponse;
import io.olvid.engine.datatypes.containers.ProtocolReceivedMessage;
import io.olvid.engine.datatypes.containers.ProtocolReceivedServerResponse;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import java.sql.SQLException;
import java.util.Objects;

public class LocalChannel
extends Channel {
    private final Identity toIdentity;

    private LocalChannel(Identity toIdentity) {
        this.toIdentity = toIdentity;
    }

    private void doPost(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        switch (message.getMessageType()) {
            case 0: {
                ChannelProtocolMessageToSend protocolMessageToSend = (ChannelProtocolMessageToSend)message;
                UID messageUid = new UID(prng);
                ProtocolReceivedMessage receivedMessage = new ProtocolReceivedMessage(messageUid, this.toIdentity, protocolMessageToSend.getEncodedElements(), ReceptionChannelInfo.createLocalChannelInfo(), System.currentTimeMillis());
                channelManagerSession.protocolDelegate.process(channelManagerSession.session, receivedMessage);
                break;
            }
            case 3: {
                ChannelDialogResponseMessageToSend dialogMessageToSend = (ChannelDialogResponseMessageToSend)message;
                ProtocolReceivedDialogResponse protocolReceivedDialogResponse = new ProtocolReceivedDialogResponse(dialogMessageToSend.getUuid(), dialogMessageToSend.getEncodedUserDialogResponse(), this.toIdentity, dialogMessageToSend.getEncodedElements(), ReceptionChannelInfo.createLocalChannelInfo());
                channelManagerSession.protocolDelegate.process(channelManagerSession.session, protocolReceivedDialogResponse);
                break;
            }
            case 5: {
                ChannelServerResponseMessageToSend serverResponseMessageToSend = (ChannelServerResponseMessageToSend)message;
                ProtocolReceivedServerResponse protocolReceivedServerResponse = new ProtocolReceivedServerResponse(serverResponseMessageToSend.getEncodedServerResponse(), this.toIdentity, serverResponseMessageToSend.getEncodedElements(), ReceptionChannelInfo.createLocalChannelInfo());
                channelManagerSession.protocolDelegate.process(channelManagerSession.session, protocolReceivedServerResponse);
                break;
            }
            default: {
                Logger.i("Trying to post a message of type " + message.getMessageType() + " on a LocalChannel.");
            }
        }
    }

    public static UID post(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        LocalChannel[] localChannels = LocalChannel.acceptableChannelsForPosting(channelManagerSession, message);
        if (localChannels.length == 0) {
            Logger.i("No acceptable channels were found for posting");
            throw new NoAcceptableChannelException();
        }
        for (LocalChannel localChannel : localChannels) {
            localChannel.doPost(channelManagerSession, message, prng);
        }
        return null;
    }

    private static LocalChannel[] acceptableChannelsForPosting(ChannelManagerSession channelManagerSession, ChannelMessageToSend message) throws SQLException {
        switch (message.getSendChannelInfo().getChannelType()) {
            case 0: {
                if (channelManagerSession.identityDelegate.isOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getToIdentity()) || Objects.equals(message.getSendChannelInfo().getToIdentity().getServer(), "ephemeral_fake_server")) {
                    return new LocalChannel[]{new LocalChannel(message.getSendChannelInfo().getToIdentity())};
                }
                return new LocalChannel[0];
            }
        }
        return new LocalChannel[0];
    }
}

