/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;

public class ChannelReceivedMessage {
    private final int messageType;
    private final Encoded encodedElements;
    private final AuthEncKey extendedPayloadKey;
    private final ReceptionChannelInfo receptionChannelInfo;
    private final NetworkReceivedMessage message;

    public ChannelReceivedMessage(NetworkReceivedMessage message, AuthEncKey messageKey, ReceptionChannelInfo receptionChannelInfo) throws Exception {
        try {
            AuthEnc authEnc = Suite.getAuthEnc(messageKey);
            Encoded decryptedMessage = new Encoded(authEnc.decrypt(messageKey, message.getEncryptedContent()));
            boolean messageKeyCheckPassed = authEnc.verifyMessageKey(messageKey, decryptedMessage.getBytes());
            if (!messageKeyCheckPassed) {
                Logger.e("Received a message not passing the messageKey check. Discarding it!!!!");
                throw new Exception();
            }
            if (message.hasExtendedPayload()) {
                PRNG extendedPayloadPRNG = Suite.getDefaultPRNG(0, Seed.of(messageKey));
                this.extendedPayloadKey = authEnc.generateKey(extendedPayloadPRNG);
            } else {
                this.extendedPayloadKey = null;
            }
            Encoded[] listOfEncoded = decryptedMessage.decodeListWithPadding();
            if (listOfEncoded.length != 2) {
                throw new Exception();
            }
            this.messageType = (int)listOfEncoded[0].decodeLong();
            this.encodedElements = listOfEncoded[1];
            this.receptionChannelInfo = receptionChannelInfo;
            this.message = message;
        }
        catch (DecryptionException e) {
            throw new Exception("Undecipherable message.");
        }
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Encoded getEncodedElements() {
        return this.encodedElements;
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return this.receptionChannelInfo;
    }

    public NetworkReceivedMessage getMessage() {
        return this.message;
    }

    public Identity getOwnedIdentity() {
        return this.message.getOwnedIdentity();
    }

    public UID getMessageUid() {
        return this.message.getMessageUid();
    }

    public AuthEncKey getExtendedPayloadKey() {
        return this.extendedPayloadKey;
    }
}

