/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.channel.datatypes.ChannelReceivedMessage;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.AttachmentKeyAndMetadata;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

public class ChannelReceivedApplicationMessage {
    private final ChannelReceivedMessage message;
    private final AttachmentKeyAndMetadata[] attachmentsKeyAndMetadata;
    private final byte[] messagePayload;

    private ChannelReceivedApplicationMessage(ChannelReceivedMessage message, AttachmentKeyAndMetadata[] attachmentsKeyAndMetadata, byte[] messagePayload) {
        this.message = message;
        this.attachmentsKeyAndMetadata = attachmentsKeyAndMetadata;
        this.messagePayload = messagePayload;
    }

    public static ChannelReceivedApplicationMessage of(ChannelReceivedMessage channelReceivedMessage) {
        if (channelReceivedMessage.getMessageType() != 1) {
            return null;
        }
        ReceptionChannelInfo channelInfo = channelReceivedMessage.getReceptionChannelInfo();
        if (channelInfo.getChannelType() != 1 && channelInfo.getChannelType() != 5) {
            return null;
        }
        try {
            Encoded[] listOfEncoded = channelReceivedMessage.getEncodedElements().decodeList();
            AttachmentKeyAndMetadata[] attachmentsKeyAndMetadata = new AttachmentKeyAndMetadata[listOfEncoded.length - 1];
            for (int i = 0; i < listOfEncoded.length - 1; ++i) {
                Encoded[] encodedParts = listOfEncoded[i].decodeList();
                if (encodedParts.length != 2) {
                    throw new DecodingException();
                }
                attachmentsKeyAndMetadata[i] = new AttachmentKeyAndMetadata((AuthEncKey)encodedParts[0].decodeSymmetricKey(), encodedParts[1].decodeBytes());
            }
            byte[] messagePayload = listOfEncoded[listOfEncoded.length - 1].decodeBytes();
            return new ChannelReceivedApplicationMessage(channelReceivedMessage, attachmentsKeyAndMetadata, messagePayload);
        }
        catch (DecodingException | ClassCastException e) {
            return null;
        }
    }

    public ChannelReceivedMessage getMessage() {
        return this.message;
    }

    public AttachmentKeyAndMetadata[] getAttachmentsKeyAndMetadata() {
        return this.attachmentsKeyAndMetadata;
    }

    public Identity getOwnedIdentity() {
        return this.message.getOwnedIdentity();
    }

    public UID getMessageUid() {
        return this.message.getMessageUid();
    }

    public byte[] getMessagePayload() {
        return this.messagePayload;
    }
}

