/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.databases.ObliviousChannel;
import io.olvid.engine.channel.databases.Provision;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ProvisionedKeyMaterial
implements ObvDatabase {
    static final String TABLE_NAME = "provisioned_key_material";
    static final String GET_ALL_INDEX_NAME = "provisioned_key_material_get_all_index";
    static final String EXPIRE_INDEX_NAME = "provisioned_key_material_expire_index";
    private final ChannelManagerSession channelManagerSession;
    private final KeyId keyId;
    static final String KEY_ID = "key_id";
    private final AuthEncKey authEncKey;
    static final String AUTH_ENC_KEY = "auth_enc_key";
    private final Long expirationTimestamp;
    static final String EXPIRATION_TIMESTAMP = "expiration_timestamp";
    private final int selfRatchetingCount;
    static final String SELF_RATCHETING_COUNT = "self_ratcheting_count";
    private final int provisionFullRatchetingCount;
    static final String PROVISION_FULL_RATCHETING_COUNT = "provision_full_ratcheting_count";
    private final UID provisionObliviousChannelCurrentDeviceUid;
    static final String PROVISION_OBLIVIOUS_CHANNEL_CURRENT_DEVICE_UID = "provision_oblivious_channel_current_device_uid";
    private final UID provisionObliviousChannelRemoteDeviceUid;
    static final String PROVISION_OBLIVIOUS_CHANNEL_REMOTE_DEVICE_UID = "provision_oblivious_channel_remote_device_uid";
    private final Identity provisionObliviousChannelRemoteIdentity;
    static final String PROVISION_OBLIVIOUS_CHANNEL_REMOTE_IDENTITY = "provision_oblivious_channel_remote_identity";

    public AuthEncKey getAuthEncKey() {
        return this.authEncKey;
    }

    public int getSelfRatchetingCount() {
        return this.selfRatchetingCount;
    }

    public int getProvisionFullRatchetingCount() {
        return this.provisionFullRatchetingCount;
    }

    public UID getProvisionObliviousChannelCurrentDeviceUid() {
        return this.provisionObliviousChannelCurrentDeviceUid;
    }

    public UID getProvisionObliviousChannelRemoteDeviceUid() {
        return this.provisionObliviousChannelRemoteDeviceUid;
    }

    public Identity getProvisionObliviousChannelRemoteIdentity() {
        return this.provisionObliviousChannelRemoteIdentity;
    }

    ObliviousChannel getObliviousChannel() {
        return ObliviousChannel.get(this.channelManagerSession, this.provisionObliviousChannelCurrentDeviceUid, this.provisionObliviousChannelRemoteDeviceUid, this.provisionObliviousChannelRemoteIdentity, false);
    }

    public void setExpirationTimestampsOfOlderProvisionedKeyMaterials() {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ProvisionedKeyMaterial.setExpirationTimestampsOfOlderProvisionedKeyMaterials", "UPDATE provisioned_key_material SET expiration_timestamp = ?  WHERE expiration_timestamp IS NULL AND provision_oblivious_channel_current_device_uid = ? AND provision_oblivious_channel_remote_device_uid = ? AND provision_oblivious_channel_remote_identity = ? AND ( provision_full_ratcheting_count < ? OR ( provision_full_ratcheting_count = ? AND self_ratcheting_count < ?));");){
            long expirationTimestamp = System.currentTimeMillis() + 5184000000L;
            statement.setLong(1, expirationTimestamp);
            statement.setBytes(2, this.provisionObliviousChannelCurrentDeviceUid.getBytes());
            statement.setBytes(3, this.provisionObliviousChannelRemoteDeviceUid.getBytes());
            statement.setBytes(4, this.provisionObliviousChannelRemoteIdentity.getBytes());
            statement.setInt(5, this.provisionFullRatchetingCount);
            statement.setInt(6, this.provisionFullRatchetingCount);
            statement.setInt(7, this.selfRatchetingCount);
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void deleteAllExpired(ChannelManagerSession channelManagerSession) {
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ProvisionedKeyMaterial.deleteAllExpired", "DELETE FROM provisioned_key_material WHERE expiration_timestamp IS NOT NULL AND expiration_timestamp < ?;");){
            statement.setLong(1, System.currentTimeMillis());
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static ProvisionedKeyMaterial create(ChannelManagerSession channelManagerSession, KeyId keyId, AuthEncKey authEncKey, int selfRatchetingCount, Provision provision) {
        if (keyId == null || authEncKey == null || provision == null) {
            return null;
        }
        try {
            ProvisionedKeyMaterial provisionedKeyMaterial = new ProvisionedKeyMaterial(channelManagerSession, keyId, authEncKey, selfRatchetingCount, provision);
            provisionedKeyMaterial.insert();
            return provisionedKeyMaterial;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private ProvisionedKeyMaterial(ChannelManagerSession channelManagerSession, KeyId keyId, AuthEncKey authEncKey, int selfRatchetingCount, Provision provision) {
        this.channelManagerSession = channelManagerSession;
        this.keyId = keyId;
        this.authEncKey = authEncKey;
        this.expirationTimestamp = null;
        this.selfRatchetingCount = selfRatchetingCount;
        this.provisionFullRatchetingCount = provision.getFullRatchetingCount();
        this.provisionObliviousChannelCurrentDeviceUid = provision.getObliviousChannelCurrentDeviceUid();
        this.provisionObliviousChannelRemoteDeviceUid = provision.getObliviousChannelRemoteDeviceUid();
        this.provisionObliviousChannelRemoteIdentity = provision.getObliviousChannelRemoteIdentity();
    }

    private ProvisionedKeyMaterial(ChannelManagerSession channelManagerSession, ResultSet res) throws SQLException {
        this.channelManagerSession = channelManagerSession;
        this.keyId = new KeyId(res.getBytes(KEY_ID));
        AuthEncKey key = null;
        try {
            key = (AuthEncKey)new Encoded(res.getBytes(AUTH_ENC_KEY)).decodeSymmetricKey();
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.authEncKey = key;
        this.expirationTimestamp = res.getLong(EXPIRATION_TIMESTAMP);
        this.selfRatchetingCount = res.getInt(SELF_RATCHETING_COUNT);
        this.provisionFullRatchetingCount = res.getInt(PROVISION_FULL_RATCHETING_COUNT);
        this.provisionObliviousChannelCurrentDeviceUid = new UID(res.getBytes(PROVISION_OBLIVIOUS_CHANNEL_CURRENT_DEVICE_UID));
        this.provisionObliviousChannelRemoteDeviceUid = new UID(res.getBytes(PROVISION_OBLIVIOUS_CHANNEL_REMOTE_DEVICE_UID));
        try {
            this.provisionObliviousChannelRemoteIdentity = Identity.of(res.getBytes(PROVISION_OBLIVIOUS_CHANNEL_REMOTE_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS provisioned_key_material (key_id BLOB NOT NULL, auth_enc_key BLOB NOT NULL, expiration_timestamp BIGINT, self_ratcheting_count INT NOT NULL, provision_full_ratcheting_count INT NOT NULL, provision_oblivious_channel_current_device_uid BLOB NOT NULL, provision_oblivious_channel_remote_device_uid BLOB NOT NULL, provision_oblivious_channel_remote_identity BLOB NOT NULL, CONSTRAINT PK_provisioned_key_material PRIMARY KEY(self_ratcheting_count, provision_full_ratcheting_count, provision_oblivious_channel_current_device_uid, provision_oblivious_channel_remote_device_uid, provision_oblivious_channel_remote_identity), FOREIGN KEY (provision_full_ratcheting_count, provision_oblivious_channel_current_device_uid, provision_oblivious_channel_remote_device_uid, provision_oblivious_channel_remote_identity) REFERENCES provision(full_ratcheting_count, oblivious_channel_current_device_uid, oblivious_channel_remote_device_uid, oblivious_channel_remote_identity) ON DELETE CASCADE);");
            statement.execute("CREATE INDEX IF NOT EXISTS provisioned_key_material_get_all_index ON provisioned_key_material(key_id,provision_oblivious_channel_current_device_uid)");
            statement.execute("CREATE INDEX IF NOT EXISTS provisioned_key_material_expire_index ON provisioned_key_material(expiration_timestamp,provision_oblivious_channel_current_device_uid,provision_oblivious_channel_remote_device_uid,provision_oblivious_channel_remote_identity)");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 12 && newVersion >= 12) {
            try (Statement statement = session.createStatement();){
                statement.execute("DELETE FROM provisioned_key_material AS p  WHERE NOT EXISTS ( SELECT 1 FROM provision  WHERE full_ratcheting_count = p.provision_full_ratcheting_count AND oblivious_channel_current_device_uid = p.provision_oblivious_channel_current_device_uid AND oblivious_channel_remote_device_uid = p.provision_oblivious_channel_remote_device_uid AND oblivious_channel_remote_identity = p.provision_oblivious_channel_remote_identity )");
            }
            oldVersion = 12;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ProvisionedKeyMaterial.insert", "INSERT INTO provisioned_key_material VALUES (?,?,?,?,?, ?,?,?);");){
            statement.setBytes(1, this.keyId.getBytes());
            statement.setBytes(2, Encoded.of(this.authEncKey).getBytes());
            if (this.expirationTimestamp == null) {
                statement.setNull(3, -5);
            } else {
                statement.setLong(3, this.expirationTimestamp);
            }
            statement.setInt(4, this.selfRatchetingCount);
            statement.setInt(5, this.provisionFullRatchetingCount);
            statement.setBytes(6, this.provisionObliviousChannelCurrentDeviceUid.getBytes());
            statement.setBytes(7, this.provisionObliviousChannelRemoteDeviceUid.getBytes());
            statement.setBytes(8, this.provisionObliviousChannelRemoteIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ProvisionedKeyMaterial.delete", "DELETE FROM provisioned_key_material WHERE self_ratcheting_count = ? AND provision_full_ratcheting_count = ? AND provision_oblivious_channel_current_device_uid = ? AND provision_oblivious_channel_remote_device_uid = ? AND provision_oblivious_channel_remote_identity = ?;");){
            statement.setInt(1, this.selfRatchetingCount);
            statement.setInt(2, this.provisionFullRatchetingCount);
            statement.setBytes(3, this.provisionObliviousChannelCurrentDeviceUid.getBytes());
            statement.setBytes(4, this.provisionObliviousChannelRemoteDeviceUid.getBytes());
            statement.setBytes(5, this.provisionObliviousChannelRemoteIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ProvisionedKeyMaterial[] getAll(ChannelManagerSession channelManagerSession, KeyId keyId, UID currentDeviceUid) {
        if (keyId == null || currentDeviceUid == null) {
            return new ProvisionedKeyMaterial[0];
        }
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ProvisionedKeyMaterial.getAll", "SELECT * FROM provisioned_key_material WHERE key_id = ? AND provision_oblivious_channel_current_device_uid = ?;");){
            ProvisionedKeyMaterial[] provisionedKeyMaterialArray;
            block16: {
                statement.setBytes(1, keyId.getBytes());
                statement.setBytes(2, currentDeviceUid.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ProvisionedKeyMaterial> list = new ArrayList<ProvisionedKeyMaterial>();
                    while (res.next()) {
                        list.add(new ProvisionedKeyMaterial(channelManagerSession, res));
                    }
                    provisionedKeyMaterialArray = list.toArray(new ProvisionedKeyMaterial[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return provisionedKeyMaterialArray;
        }
        catch (SQLException e) {
            return new ProvisionedKeyMaterial[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static int countNotExpiringProvisionedReceiveKey(ChannelManagerSession channelManagerSession, Provision provision) {
        String COUNT = "count";
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ProvisionedKeyMaterial.countNotExpiringProvisionedReceiveKey", "SELECT COUNT(*) AS count FROM provisioned_key_material WHERE expiration_timestamp IS NULL AND provision_full_ratcheting_count = ? AND provision_oblivious_channel_current_device_uid = ? AND provision_oblivious_channel_remote_device_uid = ? AND provision_oblivious_channel_remote_identity = ?;");){
            int n;
            block18: {
                ResultSet res;
                block16: {
                    int n2;
                    block17: {
                        statement.setInt(1, provision.getFullRatchetingCount());
                        statement.setBytes(2, provision.getObliviousChannelCurrentDeviceUid().getBytes());
                        statement.setBytes(3, provision.getObliviousChannelRemoteDeviceUid().getBytes());
                        statement.setBytes(4, provision.getObliviousChannelRemoteIdentity().getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block16;
                            n2 = res.getInt("count");
                            if (res == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return n2;
                }
                n = 0;
                if (res == null) break block18;
                res.close();
            }
            return n;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public void wasCommitted() {
    }
}

