/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.databases.Provision;
import io.olvid.engine.channel.databases.ProvisionedKeyMaterial;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.NetworkChannel;
import io.olvid.engine.channel.datatypes.PreKeyChannel;
import io.olvid.engine.channel.datatypes.RatchetingOutput;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.KDF;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.AuthEncKeyAndChannelInfo;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.MessageToSend;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.containers.OwnedDeviceAndPreKey;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.UidAndPreKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.security.InvalidKeyException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ObliviousChannel
extends NetworkChannel
implements ObvDatabase {
    static final String TABLE_NAME = "oblivious_channel";
    private final ChannelManagerSession channelManagerSession;
    private final UID currentDeviceUid;
    static final String CURRENT_DEVICE_UID = "current_device_uid";
    private final UID remoteDeviceUid;
    static final String REMOTE_DEVICE_UID = "remote_device_uid";
    private final Identity remoteIdentity;
    static final String REMOTE_IDENTITY = "contact_identity";
    private boolean confirmed;
    static final String CONFIRMED = "confirmed";
    static final String OBLIVIOUS_ENGINE_VERSION = "oblivious_engine_version";
    private Seed seedForNextSendKey;
    static final String SEED_FOR_NEXT_SEND_KEY = "seed_for_next_send_key";
    private int fullRatchetingCountOfLastProvision;
    static final String FULL_RATCHETING_COUNT_OF_LAST_PROVISION = "full_ratcheting_count_of_last_provision";
    private int numberOfEncryptedMessages;
    static final String NUMBER_OF_ENCRYPTED_MESSAGES = "number_of_encrypted_messages";
    private int numberOfEncryptedMessagesAtTheTimeOfTheLastFullRatchet;
    static final String NUMBER_OF_ENCRYPTED_MESSAGES_AT_THE_TIME_OF_THE_LAST_FULL_RATCHET = "number_of_encrypted_messages_at_the_time_of_the_last_full_ratchet";
    private long timestampOfLastFullRatchet;
    static final String TIMESTAMP_OF_LAST_FULL_RATCHET = "timestamp_of_last_full_ratchet";
    private long timestampOfLastFullRatchetSentMessage;
    static final String TIMESTAMP_OF_LAST_FULL_RATCHET_SENT_MESSAGE = "timestamp_of_last_full_ratchet_sent_message";
    private boolean fullRatchetOfTheSendSeedInProgress;
    static final String FULL_RATCHET_OF_THE_SEND_SEED_IN_PROGRESS = "full_ratchet_of_the_send_seed_in_progress";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_NEED_FULL_RATCHET = 1L;
    private static final long HOOK_BIT_CHANNEL_CONFIRMED = 2L;
    private static final long HOOK_BIT_CHANNEL_DELETED = 4L;

    public UID getCurrentDeviceUid() {
        return this.currentDeviceUid;
    }

    public UID getRemoteDeviceUid() {
        return this.remoteDeviceUid;
    }

    public Identity getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return ReceptionChannelInfo.createObliviousChannelInfo(this.remoteDeviceUid, this.remoteIdentity);
    }

    public int getNumberOfEncryptedMessagesSinceLastFullRatchet() {
        return this.numberOfEncryptedMessages - this.numberOfEncryptedMessagesAtTheTimeOfTheLastFullRatchet;
    }

    public boolean requiresFullRatchet() {
        if (this.fullRatchetOfTheSendSeedInProgress) {
            if (System.currentTimeMillis() - this.timestampOfLastFullRatchetSentMessage >= 2592000000L) {
                return true;
            }
        } else {
            if (this.getNumberOfEncryptedMessagesSinceLastFullRatchet() >= 500) {
                return true;
            }
            if (System.currentTimeMillis() - this.timestampOfLastFullRatchet >= 2592000000L) {
                return true;
            }
        }
        return false;
    }

    public void aSendSeedFullRatchetMessageWasSent() {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.aSendSeedFullRatchetMessageWasSent", "UPDATE oblivious_channel SET full_ratchet_of_the_send_seed_in_progress = 1, timestamp_of_last_full_ratchet_sent_message = ?  WHERE current_device_uid = ? AND remote_device_uid = ? AND contact_identity = ?;");){
            long now = System.currentTimeMillis();
            statement.setLong(1, now);
            statement.setBytes(2, this.currentDeviceUid.getBytes());
            statement.setBytes(3, this.remoteDeviceUid.getBytes());
            statement.setBytes(4, this.remoteIdentity.getBytes());
            statement.executeUpdate();
            this.fullRatchetOfTheSendSeedInProgress = true;
            this.timestampOfLastFullRatchetSentMessage = now;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void confirm() throws SQLException {
        if (this.confirmed) {
            return;
        }
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.confirm", "UPDATE oblivious_channel SET confirmed = 1  WHERE current_device_uid = ?  AND remote_device_uid = ?  AND contact_identity = ?;");){
            statement.setBytes(1, this.currentDeviceUid.getBytes());
            statement.setBytes(2, this.remoteDeviceUid.getBytes());
            statement.setBytes(3, this.remoteIdentity.getBytes());
            statement.executeUpdate();
            this.confirmed = true;
            this.commitHookBits |= 2L;
            this.channelManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void updateSendSeed(Seed seed, int obliviousEngineVersion) {
        Seed sendSeed = ObliviousChannel.generateDiversifiedSeed(seed, this.currentDeviceUid, obliviousEngineVersion);
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.updateSendSeed", "UPDATE oblivious_channel SET seed_for_next_send_key = ?, oblivious_engine_version = ?, number_of_encrypted_messages_at_the_time_of_the_last_full_ratchet = ?, timestamp_of_last_full_ratchet = ?, full_ratchet_of_the_send_seed_in_progress = 0  WHERE current_device_uid = ? AND remote_device_uid = ? AND contact_identity = ?;");){
            long now = System.currentTimeMillis();
            statement.setBytes(1, sendSeed.getBytes());
            statement.setInt(2, obliviousEngineVersion);
            statement.setInt(3, this.numberOfEncryptedMessages);
            statement.setLong(4, now);
            statement.setBytes(5, this.currentDeviceUid.getBytes());
            statement.setBytes(6, this.remoteDeviceUid.getBytes());
            statement.setBytes(7, this.remoteIdentity.getBytes());
            statement.executeUpdate();
            this.seedForNextSendKey = sendSeed;
            this.obliviousEngineVersion = obliviousEngineVersion;
            this.numberOfEncryptedMessagesAtTheTimeOfTheLastFullRatchet = this.numberOfEncryptedMessages;
            this.timestampOfLastFullRatchet = now;
            this.fullRatchetOfTheSendSeedInProgress = false;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void createNewProvision(Seed seed, int obliviousEngineVersion) throws SQLException {
        Seed receiveSeed = ObliviousChannel.generateDiversifiedSeed(seed, this.remoteDeviceUid, obliviousEngineVersion);
        Provision provision = Provision.createOrReplace(this.channelManagerSession, this.fullRatchetingCountOfLastProvision + 1, this, receiveSeed, obliviousEngineVersion);
        if (provision == null) {
            throw new SQLException();
        }
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.createNewProvision", "UPDATE oblivious_channel SET full_ratcheting_count_of_last_provision = ?  WHERE current_device_uid = ? AND remote_device_uid = ? AND contact_identity = ?;");){
            statement.setInt(1, this.fullRatchetingCountOfLastProvision + 1);
            statement.setBytes(2, this.currentDeviceUid.getBytes());
            statement.setBytes(3, this.remoteDeviceUid.getBytes());
            statement.setBytes(4, this.remoteIdentity.getBytes());
            statement.executeUpdate();
            ++this.fullRatchetingCountOfLastProvision;
        }
    }

    public static void clean(ChannelManagerSession channelManagerSession) {
        ProvisionedKeyMaterial.deleteAllExpired(channelManagerSession);
        Provision.deleteAllEmpty(channelManagerSession);
    }

    public static ObliviousChannel create(ChannelManagerSession channelManagerSession, UID currentDeviceUid, UID remoteDeviceUid, Identity remoteIdentity, Seed seed, int obliviousEngineVersion) {
        if (currentDeviceUid == null || remoteDeviceUid == null || remoteIdentity == null || seed == null) {
            return null;
        }
        Seed sendSeed = ObliviousChannel.generateDiversifiedSeed(seed, currentDeviceUid, obliviousEngineVersion);
        Seed receiveSeed = ObliviousChannel.generateDiversifiedSeed(seed, remoteDeviceUid, obliviousEngineVersion);
        try {
            ObliviousChannel obliviousChannel = new ObliviousChannel(channelManagerSession, currentDeviceUid, remoteDeviceUid, remoteIdentity, sendSeed, obliviousEngineVersion);
            obliviousChannel.insert();
            Provision provision = Provision.createOrReplace(channelManagerSession, 0, obliviousChannel, receiveSeed, obliviousEngineVersion);
            if (provision == null) {
                obliviousChannel.delete();
                throw new SQLException();
            }
            return obliviousChannel;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private ObliviousChannel(ChannelManagerSession channelManagerSession, UID currentDeviceUid, UID remoteDeviceUid, Identity remoteIdentity, Seed seedForNextSendKey, int obliviousEngineVersion) {
        this.channelManagerSession = channelManagerSession;
        this.currentDeviceUid = currentDeviceUid;
        this.remoteDeviceUid = remoteDeviceUid;
        this.remoteIdentity = remoteIdentity;
        this.confirmed = false;
        this.obliviousEngineVersion = obliviousEngineVersion;
        this.seedForNextSendKey = seedForNextSendKey;
        this.fullRatchetingCountOfLastProvision = 0;
        this.numberOfEncryptedMessages = 0;
        this.numberOfEncryptedMessagesAtTheTimeOfTheLastFullRatchet = 0;
        this.timestampOfLastFullRatchetSentMessage = this.timestampOfLastFullRatchet = System.currentTimeMillis();
        this.fullRatchetOfTheSendSeedInProgress = false;
    }

    private ObliviousChannel(ChannelManagerSession channelManagerSession, ResultSet res) throws SQLException {
        this.channelManagerSession = channelManagerSession;
        this.currentDeviceUid = new UID(res.getBytes(CURRENT_DEVICE_UID));
        this.remoteDeviceUid = new UID(res.getBytes(REMOTE_DEVICE_UID));
        try {
            this.remoteIdentity = Identity.of(res.getBytes(REMOTE_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.confirmed = res.getBoolean(CONFIRMED);
        this.obliviousEngineVersion = res.getInt(OBLIVIOUS_ENGINE_VERSION);
        this.seedForNextSendKey = new Seed(res.getBytes(SEED_FOR_NEXT_SEND_KEY));
        this.fullRatchetingCountOfLastProvision = res.getInt(FULL_RATCHETING_COUNT_OF_LAST_PROVISION);
        this.numberOfEncryptedMessages = res.getInt(NUMBER_OF_ENCRYPTED_MESSAGES);
        this.numberOfEncryptedMessagesAtTheTimeOfTheLastFullRatchet = res.getInt(NUMBER_OF_ENCRYPTED_MESSAGES_AT_THE_TIME_OF_THE_LAST_FULL_RATCHET);
        this.timestampOfLastFullRatchet = res.getLong(TIMESTAMP_OF_LAST_FULL_RATCHET);
        this.timestampOfLastFullRatchetSentMessage = res.getLong(TIMESTAMP_OF_LAST_FULL_RATCHET_SENT_MESSAGE);
        this.fullRatchetOfTheSendSeedInProgress = res.getBoolean(FULL_RATCHET_OF_THE_SEND_SEED_IN_PROGRESS);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS oblivious_channel (current_device_uid BLOB NOT NULL, remote_device_uid BLOB NOT NULL, contact_identity BLOB NOT NULL, confirmed BIT NOT NULL, oblivious_engine_version INT NOT NULL, seed_for_next_send_key BLOB NOT NULL, full_ratcheting_count_of_last_provision INT NOT NULL, number_of_encrypted_messages INT NOT NULL, number_of_encrypted_messages_at_the_time_of_the_last_full_ratchet INT NOT NULL, timestamp_of_last_full_ratchet BIGINT NOT NULL, timestamp_of_last_full_ratchet_sent_message BIGINT NOT NULL, full_ratchet_of_the_send_seed_in_progress BIT NOT NULL, CONSTRAINT PK_oblivious_channel PRIMARY KEY(current_device_uid, remote_device_uid, contact_identity));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 39 && newVersion >= 39) {
            Logger.d("MIGRATING `oblivious_channel` DATABASE FROM VERSION " + oldVersion + " TO 39");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE oblivious_channel ADD COLUMN `supports_gkmv_2` BIT NOT NULL DEFAULT 0");
                statement.execute("ALTER TABLE oblivious_channel ADD COLUMN `full_ratcheting_count_with_gkmv_2_support` INT NOT NULL DEFAULT -1");
                statement.execute("ALTER TABLE oblivious_channel ADD COLUMN `self_ratcheting_count_with_gkmv_2_support` INT NOT NULL DEFAULT -1");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 39;
        }
        if (oldVersion < 46 && newVersion >= 46) {
            Logger.d("MIGRATING `oblivious_channel` DATABASE FROM VERSION " + oldVersion + " TO 46");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE oblivious_channel DROP COLUMN `number_of_encrypted_messages_since_last_full_ratchet_sent_message`");
                statement.execute("ALTER TABLE oblivious_channel DROP COLUMN `number_of_decrypted_messages_since_last_full_ratchet_sent_message`");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 46;
        }
        if (oldVersion < 47 && newVersion >= 47) {
            Logger.d("MIGRATING `oblivious_channel` DATABASE FROM VERSION " + oldVersion + " TO 47");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE oblivious_channel DROP COLUMN `supports_gkmv_2`");
                statement.execute("ALTER TABLE oblivious_channel DROP COLUMN `full_ratcheting_count_with_gkmv_2_support`");
                statement.execute("ALTER TABLE oblivious_channel DROP COLUMN `self_ratcheting_count_with_gkmv_2_support`");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 47;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.insert", "INSERT INTO oblivious_channel VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?);");){
            statement.setBytes(1, this.currentDeviceUid.getBytes());
            statement.setBytes(2, this.remoteDeviceUid.getBytes());
            statement.setBytes(3, this.remoteIdentity.getBytes());
            statement.setBoolean(4, this.confirmed);
            statement.setInt(5, this.obliviousEngineVersion);
            statement.setBytes(6, this.seedForNextSendKey.getBytes());
            statement.setInt(7, this.fullRatchetingCountOfLastProvision);
            statement.setInt(8, this.numberOfEncryptedMessages);
            statement.setInt(9, this.numberOfEncryptedMessagesAtTheTimeOfTheLastFullRatchet);
            statement.setLong(10, this.timestampOfLastFullRatchet);
            statement.setLong(11, this.timestampOfLastFullRatchetSentMessage);
            statement.setBoolean(12, this.fullRatchetOfTheSendSeedInProgress);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.delete", "DELETE FROM oblivious_channel WHERE current_device_uid = ? AND remote_device_uid = ? AND contact_identity = ?;");){
            statement.setBytes(1, this.currentDeviceUid.getBytes());
            statement.setBytes(2, this.remoteDeviceUid.getBytes());
            statement.setBytes(3, this.remoteIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 4L;
            this.channelManagerSession.session.addSessionCommitListener(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObliviousChannel get(ChannelManagerSession channelManagerSession, UID currentDeviceUid, UID remoteDeviceUid, Identity remoteIdentity, boolean necessarilyConfirmed) {
        if (currentDeviceUid == null) return null;
        if (remoteDeviceUid == null) return null;
        if (remoteIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ObliviousChannel.get", "SELECT * FROM oblivious_channel WHERE " + (necessarilyConfirmed ? "confirmed = 1 AND " : "") + "current_device_uid = ? AND remote_device_uid = ? AND contact_identity = ?;");){
            statement.setBytes(1, currentDeviceUid.getBytes());
            statement.setBytes(2, remoteDeviceUid.getBytes());
            statement.setBytes(3, remoteIdentity.getBytes());
            try (ResultSet res = statement.executeQuery();){
                if (!res.next()) return null;
                ObliviousChannel obliviousChannel = new ObliviousChannel(channelManagerSession, res);
                return obliviousChannel;
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ObliviousChannel[] getAll(ChannelManagerSession channelManagerSession) {
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ObliviousChannel.getAll", "SELECT * FROM oblivious_channel");){
            ObliviousChannel[] obliviousChannelArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ObliviousChannel> list = new ArrayList<ObliviousChannel>();
                    while (res.next()) {
                        list.add(new ObliviousChannel(channelManagerSession, res));
                    }
                    obliviousChannelArray = list.toArray(new ObliviousChannel[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return obliviousChannelArray;
        }
        catch (SQLException e) {
            return new ObliviousChannel[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ObliviousChannel[] getMany(ChannelManagerSession channelManagerSession, UID currentDeviceUid, UID[] remoteDeviceUids, Identity remoteIdentity, boolean necessarilyConfirmed) {
        if (currentDeviceUid == null || remoteDeviceUids == null || remoteDeviceUids.length == 0 || remoteIdentity == null) {
            return null;
        }
        Object questionMarks = "(";
        for (int i = 0; i < remoteDeviceUids.length; ++i) {
            questionMarks = i == 0 ? (String)questionMarks + "?" : (String)questionMarks + ",?";
        }
        questionMarks = (String)questionMarks + ")";
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ObliviousChannel.getMany", "SELECT * FROM oblivious_channel WHERE " + (necessarilyConfirmed ? "confirmed = 1 AND " : "") + "current_device_uid = ? AND contact_identity = ? AND remote_device_uid IN " + (String)questionMarks + ";");){
            ObliviousChannel[] obliviousChannelArray;
            block18: {
                statement.setBytes(1, currentDeviceUid.getBytes());
                statement.setBytes(2, remoteIdentity.getBytes());
                for (int i = 0; i < remoteDeviceUids.length; ++i) {
                    statement.setBytes(3 + i, remoteDeviceUids[i].getBytes());
                }
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ObliviousChannel> list = new ArrayList<ObliviousChannel>();
                    while (res.next()) {
                        list.add(new ObliviousChannel(channelManagerSession, res));
                    }
                    obliviousChannelArray = list.toArray(new ObliviousChannel[0]);
                    if (res == null) break block18;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return obliviousChannelArray;
        }
        catch (SQLException e) {
            return new ObliviousChannel[0];
        }
    }

    public static void deleteMany(ChannelManagerSession channelManagerSession, UID currentDeviceUid, UID[] remoteDeviceUids, Identity remoteIdentity) {
        if (currentDeviceUid == null || remoteDeviceUids == null || remoteDeviceUids.length == 0 || remoteIdentity == null) {
            return;
        }
        Object questionMarks = "(";
        for (int i = 0; i < remoteDeviceUids.length; ++i) {
            questionMarks = i == 0 ? (String)questionMarks + "?" : (String)questionMarks + ",?";
        }
        questionMarks = (String)questionMarks + ")";
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ObliviousChannel.deleteMany", "DELETE FROM oblivious_channel WHERE current_device_uid = ? AND contact_identity = ? AND remote_device_uid IN " + (String)questionMarks + ";");){
            statement.setBytes(1, currentDeviceUid.getBytes());
            statement.setBytes(2, remoteIdentity.getBytes());
            for (int i = 0; i < remoteDeviceUids.length; ++i) {
                statement.setBytes(3 + i, remoteDeviceUids[i].getBytes());
            }
            statement.executeUpdate();
            channelManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("current_device_uid_key", currentDeviceUid);
                userInfo.put("remote_identity_key", remoteIdentity);
                channelManagerSession.notificationPostingDelegate.postNotification("channel_notification_channel_deleted", userInfo);
            });
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static void deleteAll(ChannelManagerSession channelManagerSession, UID currentDeviceUid) throws SQLException {
        if (currentDeviceUid == null) {
            return;
        }
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("ObliviousChannel.deleteAll", "SELECT * FROM oblivious_channel WHERE current_device_uid = ?;");){
            statement.setBytes(1, currentDeviceUid.getBytes());
            try (ResultSet res = statement.executeQuery();){
                while (res.next()) {
                    try {
                        ObliviousChannel obliviousChannel = new ObliviousChannel(channelManagerSession, res);
                        obliviousChannel.delete();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            if (this.channelManagerSession.fullRatchetProtocolStarterDelegate != null) {
                try {
                    this.channelManagerSession.fullRatchetProtocolStarterDelegate.startFullRatchetProtocolForObliviousChannel(this.currentDeviceUid, this.remoteDeviceUid, this.remoteIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            } else {
                Logger.w("Full ratchet required, but no FullRatchetProtocolStarterDelegate is set.");
            }
        }
        if ((this.commitHookBits & 2L) != 0L) {
            this.channelManagerSession.identityDelegate.refreshMembersOfGroupsOwnedByGroupOwner(this.currentDeviceUid, this.remoteIdentity);
            this.channelManagerSession.identityDelegate.pushMembersOfOwnedGroupsToContact(this.currentDeviceUid, this.remoteIdentity);
            this.channelManagerSession.identityDelegate.initiateGroupV2BatchKeysResend(this.currentDeviceUid, this.remoteIdentity, this.remoteDeviceUid);
            userInfo = new HashMap();
            userInfo.put("current_device_uid_key", this.currentDeviceUid);
            userInfo.put("remote_identity_key", this.remoteIdentity);
            this.channelManagerSession.notificationPostingDelegate.postNotification("channel_notification_channel_confirmed", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put("current_device_uid_key", this.currentDeviceUid);
            userInfo.put("remote_identity_key", this.remoteIdentity);
            this.channelManagerSession.notificationPostingDelegate.postNotification("channel_notification_channel_deleted", userInfo);
        }
        this.commitHookBits = 0L;
    }

    static RatchetingOutput computeSelfRatchet(Seed seed, int obliviousEngineVersion) {
        AuthEncKey authEncKey;
        PRNG prng = Suite.getDefaultPRNG(obliviousEngineVersion, seed);
        Seed ratchetedSeed = new Seed(prng);
        KeyId keyId = new KeyId(prng.bytes(32));
        KDF kdf = Suite.getDefaultKDF(obliviousEngineVersion);
        Seed kdfSeed = new Seed(prng);
        try {
            authEncKey = (AuthEncKey)kdf.gen(kdfSeed, Suite.getDefaultAuthEnc(obliviousEngineVersion).getKDFDelegate())[0];
        }
        catch (Exception e) {
            return null;
        }
        return new RatchetingOutput(ratchetedSeed, keyId, authEncKey);
    }

    private static Seed generateDiversifiedSeed(Seed seed, UID uid, int obliviousEngineVersion) {
        byte[] longSeedBytes = new byte[seed.length + uid.getBytes().length];
        System.arraycopy(seed.getBytes(), 0, longSeedBytes, 0, seed.length);
        System.arraycopy(uid.getBytes(), 0, longSeedBytes, seed.length, uid.getBytes().length);
        PRNG prng = Suite.getDefaultPRNG(obliviousEngineVersion, new Seed(longSeedBytes));
        return new Seed(prng);
    }

    public static NetworkChannel[] acceptableChannelsForPosting(ChannelManagerSession channelManagerSession, ChannelMessageToSend message) throws SQLException {
        if (channelManagerSession.identityDelegate == null) {
            Logger.w("Calling acceptableChannelsForPosting with no IdentityDelegate set.");
            return new ObliviousChannel[0];
        }
        switch (message.getSendChannelInfo().getChannelType()) {
            case 1: {
                if (!message.getSendChannelInfo().getNecessarilyConfirmed().booleanValue() && message.getMessageType() != 0) {
                    return new ObliviousChannel[0];
                }
                HashSet<UID> remoteDeviceUidSet = Objects.equals(message.getSendChannelInfo().getFromIdentity(), message.getSendChannelInfo().getToIdentity()) ? new HashSet<UID>(Arrays.asList(channelManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity()))) : new HashSet<UID>(Arrays.asList(channelManagerSession.identityDelegate.getDeviceUidsOfContactIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity(), message.getSendChannelInfo().getToIdentity())));
                remoteDeviceUidSet.retainAll(Arrays.asList(message.getSendChannelInfo().getRemoteDeviceUids()));
                UID currentDeviceUid = channelManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                return ObliviousChannel.getAcceptableObliviousChannels(channelManagerSession, currentDeviceUid, remoteDeviceUidSet.toArray(new UID[0]), message.getSendChannelInfo().getToIdentity(), message.getSendChannelInfo().getNecessarilyConfirmed()).toArray(new ObliviousChannel[0]);
            }
            case 3: {
                ArrayList<NetworkChannel> acceptableChannels = new ArrayList<NetworkChannel>();
                UID currentDeviceUid = channelManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                for (int i = 0; i < message.getSendChannelInfo().getToIdentities().length; ++i) {
                    Identity identity = message.getSendChannelInfo().getToIdentities()[i];
                    UID uID = message.getSendChannelInfo().getRemoteDeviceUids()[i];
                    List<Object> uidsAndPreKeys = new ArrayList();
                    if (Objects.equals(message.getSendChannelInfo().getFromIdentity(), identity)) {
                        List<OwnedDeviceAndPreKey> ownedDeviceAndPreKeys = channelManagerSession.identityDelegate.getDevicesAndPreKeysOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                        for (OwnedDeviceAndPreKey ownedDeviceAndPreKey : ownedDeviceAndPreKeys) {
                            if (ownedDeviceAndPreKey.currentDevice) continue;
                            uidsAndPreKeys.add(new UidAndPreKey(ownedDeviceAndPreKey.deviceUid, ownedDeviceAndPreKey.preKey));
                        }
                    } else {
                        uidsAndPreKeys = channelManagerSession.identityDelegate.getDeviceUidsAndPreKeysOfContactIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity(), identity);
                    }
                    if (uID != null) {
                        UidAndPreKey uidAndPreKeyFound = null;
                        for (UidAndPreKey uidAndPreKey : uidsAndPreKeys) {
                            if (!uidAndPreKey.uid.equals(uID)) continue;
                            uidAndPreKeyFound = uidAndPreKey;
                            break;
                        }
                        if (uidAndPreKeyFound != null) {
                            acceptableChannels.addAll(ObliviousChannel.getAcceptableObliviousOrPreKeyChannels(channelManagerSession, message.getSendChannelInfo().getFromIdentity(), currentDeviceUid, new UidAndPreKey[]{uidAndPreKeyFound}, identity));
                            continue;
                        }
                    }
                    acceptableChannels.addAll(ObliviousChannel.getAcceptableObliviousOrPreKeyChannels(channelManagerSession, message.getSendChannelInfo().getFromIdentity(), currentDeviceUid, uidsAndPreKeys.toArray(new UidAndPreKey[0]), identity));
                }
                return acceptableChannels.toArray(new NetworkChannel[0]);
            }
            case 7: {
                ArrayList<UidAndPreKey> uidsAndPreKeys = new ArrayList<UidAndPreKey>();
                List<OwnedDeviceAndPreKey> ownedDeviceAndPreKeys = channelManagerSession.identityDelegate.getDevicesAndPreKeysOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                for (OwnedDeviceAndPreKey ownedDeviceAndPreKey : ownedDeviceAndPreKeys) {
                    if (ownedDeviceAndPreKey.currentDevice) continue;
                    uidsAndPreKeys.add(new UidAndPreKey(ownedDeviceAndPreKey.deviceUid, ownedDeviceAndPreKey.preKey));
                }
                UID currentDeviceUid = channelManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                return ObliviousChannel.getAcceptableObliviousOrPreKeyChannels(channelManagerSession, message.getSendChannelInfo().getFromIdentity(), currentDeviceUid, uidsAndPreKeys.toArray(new UidAndPreKey[0]), message.getSendChannelInfo().getToIdentity()).toArray(new NetworkChannel[0]);
            }
            case 8: {
                List<Object> uidsAndPreKeys = new ArrayList();
                if (Objects.equals(message.getSendChannelInfo().getFromIdentity(), message.getSendChannelInfo().getToIdentity())) {
                    List<OwnedDeviceAndPreKey> ownedDeviceAndPreKeys = channelManagerSession.identityDelegate.getDevicesAndPreKeysOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                    for (OwnedDeviceAndPreKey ownedDeviceAndPreKey : ownedDeviceAndPreKeys) {
                        if (ownedDeviceAndPreKey.currentDevice) continue;
                        uidsAndPreKeys.add(new UidAndPreKey(ownedDeviceAndPreKey.deviceUid, ownedDeviceAndPreKey.preKey));
                    }
                } else {
                    uidsAndPreKeys = channelManagerSession.identityDelegate.getDeviceUidsAndPreKeysOfContactIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity(), message.getSendChannelInfo().getToIdentity());
                }
                HashSet<UID> remoteUids = new HashSet<UID>(Arrays.asList(message.getSendChannelInfo().getRemoteDeviceUids()));
                ArrayList<UidAndPreKey> remoteUidsAndPreKeys = new ArrayList<UidAndPreKey>();
                for (UidAndPreKey uidAndPreKey : uidsAndPreKeys) {
                    if (!remoteUids.contains(uidAndPreKey.uid)) continue;
                    remoteUidsAndPreKeys.add(uidAndPreKey);
                }
                UID uID = channelManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(channelManagerSession.session, message.getSendChannelInfo().getFromIdentity());
                return ObliviousChannel.getAcceptableObliviousOrPreKeyChannels(channelManagerSession, message.getSendChannelInfo().getFromIdentity(), uID, remoteUidsAndPreKeys.toArray(new UidAndPreKey[0]), message.getSendChannelInfo().getToIdentity()).toArray(new NetworkChannel[0]);
            }
        }
        return new ObliviousChannel[0];
    }

    private static List<NetworkChannel> getAcceptableObliviousOrPreKeyChannels(ChannelManagerSession channelManagerSession, Identity ownedIdentity, UID currentDeviceUid, UidAndPreKey[] remoteDeviceUidsAndPreKeys, Identity remoteIdentity) {
        UID[] uids = new UID[remoteDeviceUidsAndPreKeys.length];
        for (int i = 0; i < remoteDeviceUidsAndPreKeys.length; ++i) {
            uids[i] = remoteDeviceUidsAndPreKeys[i].uid;
        }
        List<ObliviousChannel> obliviousChannels = ObliviousChannel.getAcceptableObliviousChannels(channelManagerSession, currentDeviceUid, uids, remoteIdentity, true);
        HashSet<UID> obliviousChannelUids = new HashSet<UID>();
        for (ObliviousChannel obliviousChannel : obliviousChannels) {
            obliviousChannelUids.add(obliviousChannel.remoteDeviceUid);
        }
        ArrayList<NetworkChannel> acceptableChannels = new ArrayList<NetworkChannel>();
        for (UidAndPreKey uidAndPreKey : remoteDeviceUidsAndPreKeys) {
            if (obliviousChannelUids.contains(uidAndPreKey.uid) || uidAndPreKey.preKey == null) continue;
            acceptableChannels.add(new PreKeyChannel(channelManagerSession.session, ownedIdentity, remoteIdentity, uidAndPreKey.uid, channelManagerSession.preKeyEncryptionDelegate));
        }
        acceptableChannels.addAll(obliviousChannels);
        return acceptableChannels;
    }

    private static List<ObliviousChannel> getAcceptableObliviousChannels(ChannelManagerSession channelManagerSession, UID currentDeviceUid, UID[] remoteDeviceUids, Identity remoteIdentity, boolean necessarilyConfirmed) {
        ObliviousChannel[] channels = ObliviousChannel.getMany(channelManagerSession, currentDeviceUid, remoteDeviceUids, remoteIdentity, necessarilyConfirmed);
        if (channels == null) {
            return Collections.emptyList();
        }
        ArrayList<ObliviousChannel> channelList = new ArrayList<ObliviousChannel>();
        for (ObliviousChannel channel : channels) {
            if (channel.getObliviousEngineVersion() < 0) continue;
            channelList.add(channel);
        }
        return channelList;
    }

    @Override
    public MessageToSend.Header wrapMessageKey(AuthEncKey messageKey, PRNGService prng, boolean protocolMessage) {
        EncryptedBytes encryptedMessageKey;
        RatchetingOutput ratchetingOutput = ObliviousChannel.computeSelfRatchet(this.seedForNextSendKey, this.obliviousEngineVersion);
        if (ratchetingOutput == null) {
            return null;
        }
        AuthEnc authEnc = Suite.getAuthEnc(ratchetingOutput.getAuthEncKey());
        try {
            encryptedMessageKey = authEnc.encrypt(ratchetingOutput.getAuthEncKey(), Encoded.of(messageKey).getBytes(), prng);
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
        byte[] headerBytes = new byte[32 + encryptedMessageKey.length];
        System.arraycopy(ratchetingOutput.getKeyId().getBytes(), 0, headerBytes, 0, 32);
        System.arraycopy(encryptedMessageKey.getBytes(), 0, headerBytes, 32, encryptedMessageKey.length);
        MessageToSend.Header header = new MessageToSend.Header(this.remoteDeviceUid, this.remoteIdentity, new EncryptedBytes(headerBytes));
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("ObliviousChannel.wrapMessageKey", "UPDATE oblivious_channel SET seed_for_next_send_key = ?, number_of_encrypted_messages = ?  WHERE current_device_uid = ? AND remote_device_uid = ? AND contact_identity = ?;");){
            statement.setBytes(1, ratchetingOutput.getRatchetedSeed().getBytes());
            statement.setInt(2, this.numberOfEncryptedMessages + 1);
            statement.setBytes(3, this.currentDeviceUid.getBytes());
            statement.setBytes(4, this.remoteDeviceUid.getBytes());
            statement.setBytes(5, this.remoteIdentity.getBytes());
            statement.executeUpdate();
            this.seedForNextSendKey = ratchetingOutput.getRatchetedSeed();
            ++this.numberOfEncryptedMessages;
            if (!protocolMessage && this.requiresFullRatchet()) {
                this.aSendSeedFullRatchetMessageWasSent();
                this.commitHookBits |= 1L;
                this.channelManagerSession.session.addSessionCommitListener(this);
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
        return header;
    }

    public static AuthEncKeyAndChannelInfo unwrapMessageKey(ChannelManagerSession channelManagerSession, NetworkReceivedMessage.Header header) {
        ProvisionedKeyMaterial[] provisionedKeys;
        UID deviceUid;
        byte[] bytes = header.getWrappedKey().getBytes();
        if (bytes.length < 32) {
            return null;
        }
        KeyId keyId = new KeyId(Arrays.copyOfRange(bytes, 0, 32));
        EncryptedBytes encryptedMessageKey = new EncryptedBytes(Arrays.copyOfRange(bytes, 32, bytes.length));
        try {
            deviceUid = channelManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(channelManagerSession.session, header.getOwnedIdentity());
        }
        catch (SQLException e) {
            Logger.e("Error retrieving a currentDeviceUid -> a received message might have been lost...");
            Logger.x(e);
            return null;
        }
        for (ProvisionedKeyMaterial provisionedKey : provisionedKeys = ProvisionedKeyMaterial.getAll(channelManagerSession, keyId, deviceUid)) {
            try {
                AuthEnc authEnc = Suite.getAuthEnc(provisionedKey.getAuthEncKey());
                Encoded encodedMessageKey = new Encoded(authEnc.decrypt(provisionedKey.getAuthEncKey(), encryptedMessageKey));
                AuthEncKey messageKey = (AuthEncKey)encodedMessageKey.decodeSymmetricKey();
                ObliviousChannel obliviousChannel = provisionedKey.getObliviousChannel();
                if (obliviousChannel != null) {
                    provisionedKey.setExpirationTimestampsOfOlderProvisionedKeyMaterials();
                    Provision provision = Provision.get(channelManagerSession, provisionedKey.getProvisionFullRatchetingCount(), provisionedKey.getProvisionObliviousChannelCurrentDeviceUid(), provisionedKey.getProvisionObliviousChannelRemoteDeviceUid(), provisionedKey.getProvisionObliviousChannelRemoteIdentity());
                    if (provision != null) {
                        provision.selfRatchetIfRequired();
                    }
                    try {
                        provisionedKey.delete();
                        if (!obliviousChannel.confirmed) {
                            obliviousChannel.confirm();
                        }
                    }
                    catch (SQLException e) {
                        Logger.x(e);
                    }
                    return new AuthEncKeyAndChannelInfo(messageKey, obliviousChannel.getReceptionChannelInfo());
                }
                Logger.w("While unwrapping a message key, a provision was found without a corresponding channel.");
            }
            catch (DecryptionException | DecodingException | ClassCastException | InvalidKeyException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

