/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.databases.ObliviousChannel;
import io.olvid.engine.channel.datatypes.AsymmetricChannel;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.ChannelManagerSessionFactory;
import io.olvid.engine.channel.datatypes.ChannelReceivedApplicationMessage;
import io.olvid.engine.channel.datatypes.ChannelReceivedMessage;
import io.olvid.engine.channel.datatypes.PreKeyChannel;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.containers.AuthEncKeyAndChannelInfo;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.containers.ProtocolReceivedMessage;
import io.olvid.engine.engine.types.identities.ObvContactActiveOrInactiveReason;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Objects;

public class ChannelCoordinator {
    private final ChannelManagerSessionFactory channelManagerSessionFactory;

    public ChannelCoordinator(ChannelManagerSessionFactory channelManagerSessionFactory) {
        this.channelManagerSessionFactory = channelManagerSessionFactory;
    }

    public void decryptAndProcess(NetworkReceivedMessage networkReceivedMessage) {
        try (ChannelManagerSession channelManagerSession = this.channelManagerSessionFactory.getSession();){
            channelManagerSession.session.startTransaction();
            AuthEncKeyAndChannelInfo authEncKeyAndChannelInfo = ObliviousChannel.unwrapMessageKey(channelManagerSession, networkReceivedMessage.getHeader());
            if (authEncKeyAndChannelInfo != null) {
                Logger.d("The message can be decrypted through an ObliviousChannel.");
                this.decryptAndProcess(channelManagerSession, networkReceivedMessage, authEncKeyAndChannelInfo);
                channelManagerSession.session.commit();
                return;
            }
            authEncKeyAndChannelInfo = PreKeyChannel.unwrapMessageKey(channelManagerSession, networkReceivedMessage.getHeader());
            if (authEncKeyAndChannelInfo != null) {
                Logger.d("The message can be decrypted with a PreKey. ");
                this.decryptAndProcess(channelManagerSession, networkReceivedMessage, authEncKeyAndChannelInfo);
                channelManagerSession.session.commit();
                return;
            }
            authEncKeyAndChannelInfo = AsymmetricChannel.unwrapMessageKey(channelManagerSession, networkReceivedMessage.getHeader());
            if (authEncKeyAndChannelInfo != null) {
                Logger.d("The message can be decrypted through an AsymmetricChannel.");
                this.decryptAndProcess(channelManagerSession, networkReceivedMessage, authEncKeyAndChannelInfo);
                channelManagerSession.session.commit();
                return;
            }
            if (channelManagerSession.networkFetchDelegate != null) {
                Logger.d("The message cannot be decrypted.");
                channelManagerSession.networkFetchDelegate.messageCannotBeDecrypted(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid());
                channelManagerSession.session.commit();
            } else {
                Logger.w("Unable to delete a networkReceivedMessage because the NetworkFetchDelegate is not set yet.");
            }
        }
        catch (SQLException e) {
            Logger.i("Unable to decryptAndProcess networkReceivedMessage with uid " + String.valueOf(networkReceivedMessage.getMessageUid()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decryptAndProcess(ChannelManagerSession channelManagerSession, NetworkReceivedMessage networkReceivedMessage, AuthEncKeyAndChannelInfo authEncKeyAndChannelInfo) {
        Identity contactIdentity;
        Identity ownedIdentity;
        ChannelReceivedMessage channelReceivedMessage;
        if (channelManagerSession.networkFetchDelegate == null) {
            return;
        }
        try {
            channelReceivedMessage = new ChannelReceivedMessage(networkReceivedMessage, authEncKeyAndChannelInfo.getAuthEncKey(), authEncKeyAndChannelInfo.getReceptionChannelInfo());
        }
        catch (Exception e) {
            channelManagerSession.networkFetchDelegate.deleteMessageAndAttachments(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid());
            return;
        }
        if (channelReceivedMessage.getReceptionChannelInfo().getChannelType() == 5 && !Objects.equals(ownedIdentity = networkReceivedMessage.getOwnedIdentity(), contactIdentity = channelReceivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
            try {
                if (!channelManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(channelManagerSession.session, ownedIdentity, contactIdentity)) {
                    Logger.i("Received a PreKey encrypted message from an unknown contact, putting it on hold...");
                    channelManagerSession.networkFetchDelegate.setInboxMessageFromIdentityForMissingPreKeyContact(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid(), contactIdentity);
                    return;
                }
                EnumSet<ObvContactActiveOrInactiveReason> reasons = channelManagerSession.identityDelegate.getContactActiveOrInactiveReasons(channelManagerSession.session, ownedIdentity, contactIdentity);
                if (reasons != null && reasons.contains((Object)ObvContactActiveOrInactiveReason.REVOKED) && !reasons.contains((Object)ObvContactActiveOrInactiveReason.FORCEFULLY_UNBLOCKED)) {
                    Logger.w("Received a PreKey encrypted message from a blocked contact, discarding it!");
                    channelManagerSession.networkFetchDelegate.deleteMessageAndAttachments(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid());
                    return;
                }
                if (!channelManagerSession.identityDelegate.isContactDeviceKnown(channelManagerSession.session, ownedIdentity, contactIdentity, channelReceivedMessage.getReceptionChannelInfo().getRemoteDeviceUid())) {
                    channelManagerSession.protocolStarterDelegate.startDeviceDiscoveryProtocolWithinTransaction(channelManagerSession.session, ownedIdentity, contactIdentity);
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        switch (channelReceivedMessage.getMessageType()) {
            case 0: {
                if (channelManagerSession.protocolDelegate == null) {
                    Logger.w("Received a protocol message, but no ProtocolDelegate is set.");
                    return;
                }
                try {
                    ProtocolReceivedMessage protocolReceivedMessage = ProtocolReceivedMessage.of(channelReceivedMessage);
                    channelManagerSession.protocolDelegate.process(channelManagerSession.session, protocolReceivedMessage);
                    break;
                }
                catch (Exception e) {
                    Logger.i("Error while processing a ProtocolReceivedMessage.");
                    break;
                }
                finally {
                    channelManagerSession.networkFetchDelegate.deleteMessageAndAttachments(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid());
                }
            }
            case 1: {
                try {
                    ChannelReceivedApplicationMessage channelReceivedApplicationMessage = ChannelReceivedApplicationMessage.of(channelReceivedMessage);
                    if (channelReceivedApplicationMessage == null) {
                        Logger.e("Error parsing a ChannelReceivedMessage, deleting it");
                        channelManagerSession.networkFetchDelegate.deleteMessageAndAttachments(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid());
                        break;
                    }
                    channelManagerSession.networkFetchDelegate.setAttachmentKeyAndMetadataAndMessagePayload(channelManagerSession.session, channelReceivedApplicationMessage.getOwnedIdentity(), channelReceivedApplicationMessage.getMessageUid(), authEncKeyAndChannelInfo.getReceptionChannelInfo().getRemoteIdentity(), authEncKeyAndChannelInfo.getReceptionChannelInfo().getRemoteDeviceUid(), channelReceivedApplicationMessage.getAttachmentsKeyAndMetadata(), channelReceivedApplicationMessage.getMessagePayload(), channelReceivedMessage.getExtendedPayloadKey());
                }
                catch (Exception e) {
                    Logger.x(e);
                    Logger.i("Error while processing a ChannelReceivedApplicationMessage.");
                    channelManagerSession.networkFetchDelegate.deleteMessageAndAttachments(channelManagerSession.session, networkReceivedMessage.getOwnedIdentity(), networkReceivedMessage.getMessageUid());
                }
                break;
            }
            default: {
                Logger.w("The ChannelReceivedMessage contains an unknown MessageType: " + channelReceivedMessage.getMessageType());
            }
        }
    }
}

