/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.coordinators.ChannelCoordinator;
import io.olvid.engine.channel.databases.ObliviousChannel;
import io.olvid.engine.channel.databases.Provision;
import io.olvid.engine.channel.databases.ProvisionedKeyMaterial;
import io.olvid.engine.channel.datatypes.Channel;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.ChannelManagerSessionFactory;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.containers.OwnedDeviceAndPreKey;
import io.olvid.engine.datatypes.containers.UidAndPreKey;
import io.olvid.engine.metamanager.ChannelDelegate;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.EncryptionForIdentityDelegate;
import io.olvid.engine.metamanager.FullRatchetProtocolStarterDelegate;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NetworkFetchDelegate;
import io.olvid.engine.metamanager.NetworkSendDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import io.olvid.engine.metamanager.PreKeyEncryptionDelegate;
import io.olvid.engine.metamanager.ProcessDownloadedMessageDelegate;
import io.olvid.engine.metamanager.ProtocolDelegate;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ChannelManager
implements ChannelDelegate,
ProcessDownloadedMessageDelegate,
ChannelManagerSessionFactory,
ObvManager {
    private final ChannelCoordinator channelCoordinator = new ChannelCoordinator(this);
    private CreateSessionDelegate createSessionDelegate;
    private NetworkSendDelegate networkSendDelegate;
    private NetworkFetchDelegate networkFetchDelegate;
    private FullRatchetProtocolStarterDelegate fullRatchetProtocolStarterDelegate;
    private ProtocolDelegate protocolDelegate;
    private ProtocolStarterDelegate protocolStarterDelegate;
    private IdentityDelegate identityDelegate;
    private EncryptionForIdentityDelegate encryptionForIdentityDelegate;
    private PreKeyEncryptionDelegate preKeyEncryptionDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;

    public ChannelManager(MetaManager metaManager) {
        metaManager.requestDelegate(this, CreateSessionDelegate.class);
        metaManager.requestDelegate(this, FullRatchetProtocolStarterDelegate.class);
        metaManager.requestDelegate(this, NetworkFetchDelegate.class);
        metaManager.requestDelegate(this, NetworkSendDelegate.class);
        metaManager.requestDelegate(this, ProtocolDelegate.class);
        metaManager.requestDelegate(this, ProtocolStarterDelegate.class);
        metaManager.requestDelegate(this, IdentityDelegate.class);
        metaManager.requestDelegate(this, EncryptionForIdentityDelegate.class);
        metaManager.requestDelegate(this, PreKeyEncryptionDelegate.class);
        metaManager.requestDelegate(this, NotificationPostingDelegate.class);
        metaManager.registerImplementedDelegates(this);
    }

    @Override
    public int initialQueueingPriority() {
        return 30;
    }

    @Override
    public void initialisationComplete() {
        ChannelManagerSession channelManagerSession;
        try {
            channelManagerSession = this.getSession();
            try {
                ObliviousChannel.clean(channelManagerSession);
                channelManagerSession.session.commit();
            }
            finally {
                if (channelManagerSession != null) {
                    channelManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            channelManagerSession = this.getSession();
            try {
                HashMap<UID, Identity> ownedIdentityFromDeviceUid = new HashMap<UID, Identity>();
                ObliviousChannel[] obliviousChannels = ObliviousChannel.getAll(channelManagerSession);
                Map<Identity, Map<Identity, Set<UID>>> deviceUidsMap = this.identityDelegate.getAllDeviceUidsOfAllContactsOfAllOwnedIdentities(channelManagerSession.session);
                for (Identity ownedIdentity : this.identityDelegate.getOwnedIdentities(channelManagerSession.session)) {
                    UID[] ownedDeviceUids = this.identityDelegate.getDeviceUidsOfOwnedIdentity(channelManagerSession.session, ownedIdentity);
                    if (!deviceUidsMap.containsKey(ownedIdentity)) {
                        deviceUidsMap.put(ownedIdentity, new HashMap());
                    }
                    Map<Identity, Set<UID>> ownedIdentityMap = deviceUidsMap.get(ownedIdentity);
                    ownedIdentityMap.put(ownedIdentity, new HashSet<UID>(Arrays.asList(ownedDeviceUids)));
                }
                for (ObliviousChannel obliviousChannel : obliviousChannels) {
                    Set<UID> deviceUids;
                    Identity ownedIdentity = (Identity)ownedIdentityFromDeviceUid.get(obliviousChannel.getCurrentDeviceUid());
                    if (ownedIdentity == null) {
                        ownedIdentity = this.identityDelegate.getOwnedIdentityForCurrentDeviceUid(channelManagerSession.session, obliviousChannel.getCurrentDeviceUid());
                        if (ownedIdentity == null) continue;
                        ownedIdentityFromDeviceUid.put(obliviousChannel.getCurrentDeviceUid(), ownedIdentity);
                    }
                    boolean found = false;
                    Map<Identity, Set<UID>> ownedIdentityMap = deviceUidsMap.get(ownedIdentity);
                    if (ownedIdentityMap != null && (deviceUids = ownedIdentityMap.get(obliviousChannel.getRemoteIdentity())) != null) {
                        found = deviceUids.remove(obliviousChannel.getRemoteDeviceUid());
                    }
                    if (found) continue;
                    Logger.i("Found an orphan oblivious channel -> deleting it!");
                    obliviousChannel.delete();
                }
                for (Identity ownedIdentity : deviceUidsMap.keySet()) {
                    Map<Identity, Set<UID>> ownedIdentityMap;
                    if (this.identityDelegate.isActiveOwnedIdentity(channelManagerSession.session, ownedIdentity)) {
                        for (UID ownedDeviceUid : this.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(channelManagerSession.session, ownedIdentity)) {
                            try {
                                long latestPing;
                                boolean channelExists = this.checkIfObliviousChannelExists(channelManagerSession.session, ownedIdentity, ownedDeviceUid, ownedIdentity);
                                boolean channelCreationInProgress = this.protocolDelegate.isChannelCreationInProgress(channelManagerSession.session, ownedIdentity, ownedIdentity, ownedDeviceUid);
                                if (channelExists || channelCreationInProgress || (latestPing = this.identityDelegate.getLatestChannelCreationPingTimestampForOwnedDevice(channelManagerSession.session, ownedIdentity, ownedDeviceUid)) == -1L || latestPing >= System.currentTimeMillis() - 2592000000L) continue;
                                Logger.i("Found an owned device with no channel and no channel creation. Restarting channel creation.");
                                this.protocolStarterDelegate.startChannelCreationProtocolWithOwnedDevice(channelManagerSession.session, ownedIdentity, ownedDeviceUid);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if ((ownedIdentityMap = deviceUidsMap.get(ownedIdentity)) == null) continue;
                    block22: for (Identity contactIdentity : ownedIdentityMap.keySet()) {
                        Set<UID> deviceUidSet;
                        if (contactIdentity.equals(ownedIdentity) || (deviceUidSet = ownedIdentityMap.get(contactIdentity)) == null) continue;
                        for (UID contactDeviceUid : deviceUidSet) {
                            try {
                                if (this.protocolDelegate.isChannelCreationInProgress(channelManagerSession.session, ownedIdentity, contactIdentity, contactDeviceUid)) continue;
                                long latestPing = this.identityDelegate.getLatestChannelCreationPingTimestampForContactDevice(channelManagerSession.session, ownedIdentity, contactIdentity, contactDeviceUid);
                                if (latestPing == -1L || latestPing >= System.currentTimeMillis() - 2592000000L) continue block22;
                                Logger.i("Found a contact device with no channel and no channel creation. Restarting channel creation.");
                                this.protocolStarterDelegate.startChannelCreationProtocolWithContactDevice(channelManagerSession.session, ownedIdentity, contactIdentity, contactDeviceUid);
                                continue block22;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }
                channelManagerSession.session.commit();
            }
            finally {
                if (channelManagerSession != null) {
                    channelManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void setDelegate(CreateSessionDelegate createSessionDelegate) {
        this.createSessionDelegate = createSessionDelegate;
        try (ChannelManagerSession channelManagerSession = this.getSession();){
            ObliviousChannel.createTable(channelManagerSession.session);
            Provision.createTable(channelManagerSession.session);
            ProvisionedKeyMaterial.createTable(channelManagerSession.session);
            channelManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to create channel databases");
        }
    }

    public static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        ObliviousChannel.upgradeTable(session, oldVersion, newVersion);
        Provision.upgradeTable(session, oldVersion, newVersion);
        ProvisionedKeyMaterial.upgradeTable(session, oldVersion, newVersion);
    }

    public void setDelegate(FullRatchetProtocolStarterDelegate fullRatchetProtocolStarterDelegate) {
        this.fullRatchetProtocolStarterDelegate = fullRatchetProtocolStarterDelegate;
    }

    public void setDelegate(NetworkSendDelegate networkSendDelegate) {
        this.networkSendDelegate = networkSendDelegate;
    }

    public void setDelegate(NetworkFetchDelegate networkFetchDelegate) {
        this.networkFetchDelegate = networkFetchDelegate;
    }

    public void setDelegate(ProtocolDelegate protocolDelegate) {
        this.protocolDelegate = protocolDelegate;
    }

    public void setDelegate(ProtocolStarterDelegate protocolStarterDelegate) {
        this.protocolStarterDelegate = protocolStarterDelegate;
    }

    public void setDelegate(IdentityDelegate identityDelegate) {
        this.identityDelegate = identityDelegate;
    }

    public void setDelegate(EncryptionForIdentityDelegate encryptionForIdentityDelegate) {
        this.encryptionForIdentityDelegate = encryptionForIdentityDelegate;
    }

    public void setDelegate(PreKeyEncryptionDelegate preKeyEncryptionDelegate) {
        this.preKeyEncryptionDelegate = preKeyEncryptionDelegate;
    }

    public void setDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    @Override
    public void processDownloadedMessage(NetworkReceivedMessage networkReceivedMessage) {
        if (networkReceivedMessage == null) {
            Logger.i("Could not process null NetworkReceivedMessage");
            return;
        }
        this.channelCoordinator.decryptAndProcess(networkReceivedMessage);
    }

    @Override
    public UID post(Session session, ChannelMessageToSend message, PRNGService prng) throws Exception {
        return Channel.post(this.wrapSession(session), message, prng);
    }

    @Override
    public void createObliviousChannel(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity, Seed seed, int obliviousEngineVersion) throws Exception {
        if (this.identityDelegate == null) {
            Logger.w("Calling createObliviousChannel while the IdentityDelegate is not yet set");
            throw new Exception();
        }
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel.create(this.wrapSession(session), currentDeviceUid, remoteDeviceUid, remoteIdentity, seed, obliviousEngineVersion);
    }

    @Override
    public void confirmObliviousChannel(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity) throws Exception {
        ObliviousChannel channel = this.getObliviousChannel(session, ownedIdentity, remoteDeviceUid, remoteIdentity);
        if (channel != null) {
            channel.confirm();
        }
    }

    @Override
    public void updateObliviousChannelSendSeed(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity, Seed seed, int obliviousEngineVersion) throws Exception {
        ObliviousChannel channel = this.getObliviousChannel(session, ownedIdentity, remoteDeviceUid, remoteIdentity);
        if (channel != null) {
            channel.updateSendSeed(seed, obliviousEngineVersion);
        }
    }

    @Override
    public void updateObliviousChannelReceiveSeed(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity, Seed seed, int obliviousEngineVersion) throws Exception {
        ObliviousChannel channel = this.getObliviousChannel(session, ownedIdentity, remoteDeviceUid, remoteIdentity);
        if (channel != null) {
            channel.createNewProvision(seed, obliviousEngineVersion);
        }
    }

    private ObliviousChannel getObliviousChannel(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity) throws Exception {
        if (this.identityDelegate == null) {
            Logger.w("Calling getObliviousChannel while the IdentityDelegate is not yet set");
            return null;
        }
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        return ObliviousChannel.get(this.wrapSession(session), currentDeviceUid, remoteDeviceUid, remoteIdentity, false);
    }

    @Override
    public UID[] getConfirmedObliviousChannelDeviceUids(Session session, Identity ownedIdentity, Identity remoteIdentity) throws Exception {
        UID[] remoteUids = Objects.equals(ownedIdentity, remoteIdentity) ? this.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(session, ownedIdentity) : this.identityDelegate.getDeviceUidsOfContactIdentity(session, ownedIdentity, remoteIdentity);
        if (remoteUids == null || remoteUids.length == 0) {
            return new UID[0];
        }
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel[] obliviousChannels = ObliviousChannel.getMany(this.wrapSession(session), currentDeviceUid, remoteUids, remoteIdentity, true);
        UID[] uids = new UID[obliviousChannels.length];
        for (int i = 0; i < obliviousChannels.length; ++i) {
            uids[i] = obliviousChannels[i].getRemoteDeviceUid();
        }
        return uids;
    }

    @Override
    public UID[] getConfirmedObliviousChannelOrPreKeyDeviceUids(Session session, Identity ownedIdentity, Identity remoteIdentity) throws Exception {
        if (Objects.equals(ownedIdentity, remoteIdentity)) {
            UID currentDeviceUid = null;
            List<OwnedDeviceAndPreKey> ownedDeviceAndPreKeys = this.identityDelegate.getDevicesAndPreKeysOfOwnedIdentity(session, ownedIdentity);
            ArrayList<UID> deviceWithoutPreKey = new ArrayList<UID>();
            ArrayList<UID> uids = new ArrayList<UID>();
            for (OwnedDeviceAndPreKey ownedDeviceAndPreKey : ownedDeviceAndPreKeys) {
                if (ownedDeviceAndPreKey.currentDevice) {
                    currentDeviceUid = ownedDeviceAndPreKey.deviceUid;
                    continue;
                }
                if (ownedDeviceAndPreKey.preKey == null) {
                    deviceWithoutPreKey.add(ownedDeviceAndPreKey.deviceUid);
                    continue;
                }
                uids.add(ownedDeviceAndPreKey.deviceUid);
            }
            if (currentDeviceUid != null && !deviceWithoutPreKey.isEmpty()) {
                ObliviousChannel[] obliviousChannels;
                for (ObliviousChannel obliviousChannel : obliviousChannels = ObliviousChannel.getMany(this.wrapSession(session), currentDeviceUid, deviceWithoutPreKey.toArray(new UID[0]), remoteIdentity, true)) {
                    uids.add(obliviousChannel.getRemoteDeviceUid());
                }
            }
            return uids.toArray(new UID[0]);
        }
        List<UidAndPreKey> uidAndPreKeys = this.identityDelegate.getDeviceUidsAndPreKeysOfContactIdentity(session, ownedIdentity, remoteIdentity);
        ArrayList<UID> deviceWithoutPreKey = new ArrayList<UID>();
        ArrayList<UID> uids = new ArrayList<UID>();
        for (UidAndPreKey uidAndPreKey : uidAndPreKeys) {
            if (uidAndPreKey.preKey == null) {
                deviceWithoutPreKey.add(uidAndPreKey.uid);
                continue;
            }
            uids.add(uidAndPreKey.uid);
        }
        if (!deviceWithoutPreKey.isEmpty()) {
            ObliviousChannel[] obliviousChannels;
            UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
            for (ObliviousChannel obliviousChannel : obliviousChannels = ObliviousChannel.getMany(this.wrapSession(session), currentDeviceUid, deviceWithoutPreKey.toArray(new UID[0]), remoteIdentity, true)) {
                uids.add(obliviousChannel.getRemoteDeviceUid());
            }
        }
        return uids.toArray(new UID[0]);
    }

    @Override
    public void deleteObliviousChannelsWithContact(Session session, Identity ownedIdentity, Identity remoteIdentity) throws Exception {
        UID[] remoteUids = this.identityDelegate.getDeviceUidsOfContactIdentity(session, ownedIdentity, remoteIdentity);
        if (remoteUids == null || remoteUids.length == 0) {
            return;
        }
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel.deleteMany(this.wrapSession(session), currentDeviceUid, remoteUids, remoteIdentity);
    }

    @Override
    public void deleteObliviousChannelIfItExists(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity) throws Exception {
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel obliviousChannel = ObliviousChannel.get(this.wrapSession(session), currentDeviceUid, remoteDeviceUid, remoteIdentity, false);
        if (obliviousChannel != null) {
            obliviousChannel.delete();
        }
    }

    @Override
    public void deleteAllChannelsForOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel.deleteAll(this.wrapSession(session), currentDeviceUid);
    }

    @Override
    public boolean checkIfObliviousChannelExists(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity) throws SQLException {
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel obliviousChannel = ObliviousChannel.get(this.wrapSession(session), currentDeviceUid, remoteDeviceUid, remoteIdentity, false);
        return obliviousChannel != null;
    }

    @Override
    public boolean checkIfObliviousChannelIsConfirmed(Session session, Identity ownedIdentity, UID remoteDeviceUid, Identity remoteIdentity) throws SQLException {
        UID currentDeviceUid = this.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
        ObliviousChannel obliviousChannel = ObliviousChannel.get(this.wrapSession(session), currentDeviceUid, remoteDeviceUid, remoteIdentity, true);
        return obliviousChannel != null;
    }

    @Override
    public ChannelManagerSession getSession() throws SQLException {
        if (this.createSessionDelegate == null) {
            throw new SQLException("No CreateSessionDelegate was set in ChannelManager.");
        }
        return new ChannelManagerSession(this.createSessionDelegate.getSession(), this.fullRatchetProtocolStarterDelegate, this.networkFetchDelegate, this.networkSendDelegate, this.protocolDelegate, this.encryptionForIdentityDelegate, this.preKeyEncryptionDelegate, this.identityDelegate, this.notificationPostingDelegate, this.protocolStarterDelegate);
    }

    private ChannelManagerSession wrapSession(Session session) {
        return new ChannelManagerSession(session, this.fullRatchetProtocolStarterDelegate, this.networkFetchDelegate, this.networkSendDelegate, this.protocolDelegate, this.encryptionForIdentityDelegate, this.preKeyEncryptionDelegate, this.identityDelegate, this.notificationPostingDelegate, this.protocolStarterDelegate);
    }
}

