/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.tasks;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.databases.ProfileBackupThreadId;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.backup.datatypes.BackupManagerSessionFactory;
import io.olvid.engine.backup.datatypes.BackupTaskStatus;
import io.olvid.engine.backup.tasks.DownloadBackupFromServer;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.BackupsV2ListItem;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvDeviceList;
import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvProfileBackupSnapshot;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.sync.IdentityManagerSyncSnapshot;
import io.olvid.engine.identity.databases.sync.OwnedIdentitySyncSnapshot;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;

public class ProfileBackupsFetchTask {
    private final String server;
    private final BackupSeed profileBackupSeed;
    private final BackupManagerSessionFactory backupManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private ObvProfileBackupsForRestore obvProfileBackupsForRestore;

    public ProfileBackupsFetchTask(String server, BackupSeed profileBackupSeed, BackupManagerSessionFactory backupManagerSessionFactory, SSLSocketFactory sslSocketFactory) {
        this.server = server;
        this.profileBackupSeed = profileBackupSeed;
        this.backupManagerSessionFactory = backupManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
    }

    public BackupTaskStatus execute() {
        ObvBackupAndSyncDelegate appBackupAndSyncDelegates;
        IdentityDelegate identityDelegate;
        BackupSeed.DerivedKeysV2 derivedKeysV2 = this.profileBackupSeed.deriveKeysV2();
        StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2ListBackupsQuery(this.server, derivedKeysV2.backupKeyUid)), this.sslSocketFactory);
        OperationQueue queue = new OperationQueue();
        queue.queue(standaloneServerQueryOperation);
        queue.execute(1, "Engine-ProfileBackupsFetchTask");
        queue.join();
        ArrayList<BackupsV2ListItem> profilesToDownload = new ArrayList<BackupsV2ListItem>();
        if (standaloneServerQueryOperation.isFinished()) {
            List<BackupsV2ListItem> backupsV2ListItems;
            try {
                backupsV2ListItems = BackupsV2ListItem.manyOf(standaloneServerQueryOperation.getServerResponse().decodeList());
            }
            catch (Exception e) {
                Logger.x(e);
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
            for (BackupsV2ListItem backupsV2ListItem : backupsV2ListItems) {
                if (Objects.equals(backupsV2ListItem.threadId, Constants.DEVICE_BACKUP_THREAD_ID)) continue;
                profilesToDownload.add(backupsV2ListItem);
            }
        } else {
            Integer rfc = standaloneServerQueryOperation.getReasonForCancel();
            if (rfc == null) {
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
            if (rfc == 1) {
                this.obvProfileBackupsForRestore = new ObvProfileBackupsForRestore(ObvProfileBackupsForRestore.Status.NETWORK_ERROR, null, null);
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
            if (rfc != 7) {
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
        }
        HashMap<Identity, UID> thisDeviceThreadIds = new HashMap<Identity, UID>();
        try (BackupManagerSession backupManagerSession = this.backupManagerSessionFactory.getSession();){
            identityDelegate = backupManagerSession.identityDelegate;
            appBackupAndSyncDelegates = backupManagerSession.appBackupAndSyncDelegate;
            for (ProfileBackupThreadId profileBackupThreadId : ProfileBackupThreadId.getAll(backupManagerSession)) {
                thisDeviceThreadIds.put(profileBackupThreadId.getOwnedIdentity(), profileBackupThreadId.getThreadId());
            }
        }
        catch (Exception e) {
            Logger.x(e);
            return BackupTaskStatus.RETRIABLE_FAILURE;
        }
        ArrayList<ObvProfileBackupsForRestore.ObvProfileBackupForRestore> profileBackupsForRestore = new ArrayList<ObvProfileBackupsForRestore.ObvProfileBackupForRestore>();
        boolean truncated = false;
        OwnedIdentitySyncSnapshot.PrivateIdentity privateIdentity = null;
        byte[] bytesIdentity = null;
        for (BackupsV2ListItem profileToDownload : profilesToDownload) {
            ObvProfileBackupSnapshot obvProfileBackupSnapshot;
            DownloadBackupFromServer serverMethod = new DownloadBackupFromServer(profileToDownload.downloadUrl);
            if (!serverMethod.execute()) {
                truncated = true;
                continue;
            }
            try {
                EncryptedBytes encryptedBackup = new EncryptedBytes(serverMethod.getEncryptedBackup());
                AuthEnc authEnc = Suite.getAuthEnc(derivedKeysV2.encryptionKey);
                byte[] paddedPlaintext = authEnc.decrypt(derivedKeysV2.encryptionKey, encryptedBackup);
                HashMap<DictionaryKey, Encoded> encodedDictionary = new Encoded(paddedPlaintext).decodeDictionaryWithPadding();
                obvProfileBackupSnapshot = ObvProfileBackupSnapshot.fromEncodedDictionary(encodedDictionary, identityDelegate.getSyncDelegate(), appBackupAndSyncDelegates);
            }
            catch (Exception e) {
                Logger.x(e);
                truncated = true;
                continue;
            }
            if (obvProfileBackupSnapshot == null) {
                truncated = true;
                continue;
            }
            ObvProfileBackupsForRestore.ObvProfileBackupForRestore obvProfileBackupForRestore = new ObvProfileBackupsForRestore.ObvProfileBackupForRestore();
            obvProfileBackupForRestore.bytesBackupThreadId = profileToDownload.threadId.getBytes();
            obvProfileBackupForRestore.version = profileToDownload.version;
            obvProfileBackupForRestore.timestamp = obvProfileBackupSnapshot.getTimestamp();
            obvProfileBackupForRestore.additionalInfo = obvProfileBackupSnapshot.getAdditionalInfo();
            obvProfileBackupForRestore.snapshot = obvProfileBackupSnapshot.getSnapshot();
            ObvSyncSnapshotNode obvSyncSnapshotNode = obvProfileBackupForRestore.snapshot.getSnapshotNode(identityDelegate.getSyncDelegate().getTag());
            if (obvSyncSnapshotNode instanceof IdentityManagerSyncSnapshot) {
                OwnedIdentitySyncSnapshot ownedIdentityNode = ((IdentityManagerSyncSnapshot)obvSyncSnapshotNode).owned_identity_node;
                if (privateIdentity == null) {
                    privateIdentity = ownedIdentityNode.private_identity;
                    bytesIdentity = ((IdentityManagerSyncSnapshot)obvSyncSnapshotNode).owned_identity;
                }
                obvProfileBackupForRestore.contactCount = ownedIdentityNode.contacts.size();
                obvProfileBackupForRestore.groupCount = ownedIdentityNode.groups.size() + ownedIdentityNode.groups2.size();
                try {
                    obvProfileBackupForRestore.fromThisDevice = Objects.equals(profileToDownload.threadId, thisDeviceThreadIds.get(Identity.of(((IdentityManagerSyncSnapshot)obvSyncSnapshotNode).owned_identity)));
                }
                catch (Exception e) {
                    Logger.x(e);
                    obvProfileBackupForRestore.fromThisDevice = false;
                }
                if (ownedIdentityNode.keycloak != null) {
                    obvProfileBackupForRestore.keycloakStatus = ownedIdentityNode.keycloak.transfer_restricted ? ObvProfileBackupsForRestore.KeycloakStatus.TRANSFER_RESTRICTED : ObvProfileBackupsForRestore.KeycloakStatus.MANAGED;
                    obvProfileBackupForRestore.keycloakServerUrl = ownedIdentityNode.keycloak.server_url;
                    obvProfileBackupForRestore.keycloakClientId = ownedIdentityNode.keycloak.client_id;
                    obvProfileBackupForRestore.keycloakClientSecret = ownedIdentityNode.keycloak.client_secret;
                } else {
                    obvProfileBackupForRestore.keycloakStatus = ObvProfileBackupsForRestore.KeycloakStatus.UNMANAGED;
                    obvProfileBackupForRestore.keycloakServerUrl = null;
                    obvProfileBackupForRestore.keycloakClientId = null;
                    obvProfileBackupForRestore.keycloakClientSecret = null;
                }
            } else {
                truncated = true;
                continue;
            }
            profileBackupsForRestore.add(obvProfileBackupForRestore);
        }
        profileBackupsForRestore.sort(Comparator.comparingLong(o -> -o.timestamp));
        ObvDeviceList deviceList = null;
        if (privateIdentity != null) {
            try {
                Identity identity = Identity.of(bytesIdentity);
                EncryptionPrivateKey privateKey = (EncryptionPrivateKey)new Encoded(privateIdentity.encryption_private_key).decodePrivateKey();
                standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, identity, new ServerQuery.OwnedDeviceDiscoveryQuery(identity)), this.sslSocketFactory);
                queue = new OperationQueue();
                queue.queue(standaloneServerQueryOperation);
                queue.execute(1, "Engine-ProfileBackupsFetchTask");
                queue.join();
                if (standaloneServerQueryOperation.isFinished() && standaloneServerQueryOperation.getServerResponse() != null) {
                    deviceList = ObvDeviceList.of(standaloneServerQueryOperation.getServerResponse().decodeEncryptedData(), privateKey);
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        this.obvProfileBackupsForRestore = new ObvProfileBackupsForRestore(truncated ? ObvProfileBackupsForRestore.Status.TRUNCATED : ObvProfileBackupsForRestore.Status.SUCCESS, profileBackupsForRestore, deviceList);
        return BackupTaskStatus.SUCCESS;
    }

    public ObvProfileBackupsForRestore getObvProfileBackupsForRestore() {
        return this.obvProfileBackupsForRestore;
    }
}

