/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.tasks;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.backup.datatypes.BackupManagerSessionFactory;
import io.olvid.engine.backup.datatypes.BackupTaskStatus;
import io.olvid.engine.backup.tasks.DownloadBackupFromServer;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.containers.BackupsV2ListItem;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.sync.ObvDeviceBackupSnapshot;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;

public class DeviceBackupFetchTask {
    private final String server;
    private final BackupSeed deviceBackupSeed;
    private final BackupManagerSessionFactory backupManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private ObvDeviceBackupForRestore obvDeviceBackupForRestore;

    public DeviceBackupFetchTask(String server, BackupSeed deviceBackupSeed, BackupManagerSessionFactory backupManagerSessionFactory, SSLSocketFactory sslSocketFactory) {
        this.server = server;
        this.deviceBackupSeed = deviceBackupSeed;
        this.backupManagerSessionFactory = backupManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackupTaskStatus execute() {
        BackupSeed.DerivedKeysV2 derivedKeysV2 = this.deviceBackupSeed.deriveKeysV2();
        StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2ListBackupsQuery(this.server, derivedKeysV2.backupKeyUid)), this.sslSocketFactory);
        OperationQueue queue = new OperationQueue();
        queue.queue(standaloneServerQueryOperation);
        queue.execute(1, "Engine-DeviceBackupFetchTask");
        queue.join();
        String deviceBackupDownloadUrl = null;
        if (standaloneServerQueryOperation.isFinished()) {
            List<BackupsV2ListItem> backupsV2ListItems;
            try {
                backupsV2ListItems = BackupsV2ListItem.manyOf(standaloneServerQueryOperation.getServerResponse().decodeList());
            }
            catch (Exception e) {
                Logger.x(e);
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
            for (BackupsV2ListItem backupsV2ListItem : backupsV2ListItems) {
                if (!Objects.equals(backupsV2ListItem.threadId, Constants.DEVICE_BACKUP_THREAD_ID)) continue;
                deviceBackupDownloadUrl = backupsV2ListItem.downloadUrl;
                break;
            }
        } else {
            Integer rfc = standaloneServerQueryOperation.getReasonForCancel();
            if (rfc == null) {
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
            if (rfc == 1) {
                this.obvDeviceBackupForRestore = new ObvDeviceBackupForRestore(ObvDeviceBackupForRestore.Status.NETWORK_ERROR, null, null);
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
            if (rfc != 7) {
                return BackupTaskStatus.RETRIABLE_FAILURE;
            }
        }
        if (deviceBackupDownloadUrl == null) {
            return BackupTaskStatus.PERMANENT_FAILURE;
        }
        DownloadBackupFromServer serverMethod = new DownloadBackupFromServer(deviceBackupDownloadUrl);
        if (!serverMethod.execute()) {
            this.obvDeviceBackupForRestore = new ObvDeviceBackupForRestore(ObvDeviceBackupForRestore.Status.NETWORK_ERROR, null, null);
            return BackupTaskStatus.RETRIABLE_FAILURE;
        }
        try {
            BackupManagerSession backupManagerSession = this.backupManagerSessionFactory.getSession();
            try {
                ObvDeviceBackupSnapshot obvDeviceBackupSnapshot;
                try {
                    EncryptedBytes encryptedBackup = new EncryptedBytes(serverMethod.getEncryptedBackup());
                    AuthEnc authEnc = Suite.getAuthEnc(derivedKeysV2.encryptionKey);
                    byte[] paddedPlaintext = authEnc.decrypt(derivedKeysV2.encryptionKey, encryptedBackup);
                    HashMap<DictionaryKey, Encoded> encodedDictionary = new Encoded(paddedPlaintext).decodeDictionaryWithPadding();
                    obvDeviceBackupSnapshot = ObvDeviceBackupSnapshot.fromEncodedDictionary(encodedDictionary, backupManagerSession.identityDelegate.getSyncDelegate(), backupManagerSession.appBackupAndSyncDelegate);
                }
                catch (Exception e) {
                    Logger.x(e);
                    BackupTaskStatus backupTaskStatus = BackupTaskStatus.PERMANENT_FAILURE;
                    if (backupManagerSession == null) return backupTaskStatus;
                    backupManagerSession.close();
                    return backupTaskStatus;
                }
                if (obvDeviceBackupSnapshot == null) {
                    BackupTaskStatus e = BackupTaskStatus.PERMANENT_FAILURE;
                    return e;
                }
                List<ObvDeviceBackupForRestore.ObvDeviceBackupProfile> profiles = backupManagerSession.identityDelegate.getDeviceBackupProfileListFromDeviceBackup(backupManagerSession.session, obvDeviceBackupSnapshot.getSnapshotNode(backupManagerSession.identityDelegate.getSyncDelegate().getTag()));
                this.obvDeviceBackupForRestore = new ObvDeviceBackupForRestore(ObvDeviceBackupForRestore.Status.SUCCESS, profiles, obvDeviceBackupSnapshot.getSnapshotNode(backupManagerSession.appBackupAndSyncDelegate.getTag()));
                return BackupTaskStatus.SUCCESS;
            }
            finally {
                if (backupManagerSession != null) {
                    try {
                        backupManagerSession.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
            return BackupTaskStatus.PERMANENT_FAILURE;
        }
    }

    public ObvDeviceBackupForRestore getObvDeviceBackupForRestore() {
        return this.obvDeviceBackupForRestore;
    }
}

