/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.databases.Backup;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class BackupKey
implements ObvDatabase {
    static final String TABLE_NAME = "backup_key";
    private final BackupManagerSession backupManagerSession;
    private UID uid;
    static final String UID_ = "uid";
    private EncryptionPublicKey encryptionPublicKey;
    static final String ENCRYPTION_PUBLIC_KEY = "encryption_public_key";
    private MACKey macKey;
    static final String MAC_KEY = "mac_key";
    private long keyGenerationTimestamp;
    static final String KEY_GENERATION_TIMESTAMP = "key_generation_timestamp";
    private long lastSuccessfulKeyVerificationTimestamp;
    static final String LAST_SUCCESSFUL_KEY_VERIFICATION_TIMESTAMP = "last_successful_key_verification_timestamp";
    private long lastKeyVerificationPromptTimestamp;
    static final String LAST_KEY_VERIFICATION_PROMPT_TIMESTAMP = "last_key_verification_prompt_timestamp";
    private int successfulVerificationCount;
    static final String SUCCESSFUL_VERIFICATION_COUNT = "successful_verification_count";
    private Integer uploadedBackupVersion;
    static final String UPLOADED_BACKUP_VERSION = "uploaded_backup_version";
    private Integer exportedBackupVersion;
    static final String EXPORTED_BACKUP_VERSION = "exported_backup_version";
    private Integer latestBackupVersion;
    static final String LATEST_BACKUP_VERSION = "latest_backup_version";

    public UID getUid() {
        return this.uid;
    }

    public EncryptionPublicKey getEncryptionPublicKey() {
        return this.encryptionPublicKey;
    }

    public MACKey getMacKey() {
        return this.macKey;
    }

    public Integer getLatestBackupVersion() {
        return this.latestBackupVersion;
    }

    public long getKeyGenerationTimestamp() {
        return this.keyGenerationTimestamp;
    }

    public long getLastSuccessfulKeyVerificationTimestamp() {
        return this.lastSuccessfulKeyVerificationTimestamp;
    }

    public int getSuccessfulVerificationCount() {
        return this.successfulVerificationCount;
    }

    public Integer getUploadedBackupVersion() {
        return this.uploadedBackupVersion;
    }

    public Integer getExportedBackupVersion() {
        return this.exportedBackupVersion;
    }

    public static BackupKey create(BackupManagerSession backupManagerSession, UID uid, EncryptionPublicKey encryptionPublicKey, MACKey macKey) {
        if (uid == null || encryptionPublicKey == null || macKey == null) {
            return null;
        }
        try {
            BackupKey backupKey = new BackupKey(backupManagerSession, uid, encryptionPublicKey, macKey, System.currentTimeMillis(), 0L, 0L, 0, null, null, null);
            backupKey.insert();
            return backupKey;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private BackupKey(BackupManagerSession backupManagerSession, UID uid, EncryptionPublicKey encryptionPublicKey, MACKey macKey, long keyGenerationTimestamp, long lastSuccessfulKeyVerificationTimestamp, long lastKeyVerificationPromptTimestamp, int successfulVerificationCount, Integer uploadedBackupVersion, Integer exportedBackupVersion, Integer latestBackupVersion) {
        this.backupManagerSession = backupManagerSession;
        this.uid = uid;
        this.encryptionPublicKey = encryptionPublicKey;
        this.macKey = macKey;
        this.keyGenerationTimestamp = keyGenerationTimestamp;
        this.lastSuccessfulKeyVerificationTimestamp = lastSuccessfulKeyVerificationTimestamp;
        this.lastKeyVerificationPromptTimestamp = lastKeyVerificationPromptTimestamp;
        this.successfulVerificationCount = successfulVerificationCount;
        this.uploadedBackupVersion = uploadedBackupVersion;
        this.exportedBackupVersion = exportedBackupVersion;
        this.latestBackupVersion = latestBackupVersion;
    }

    private BackupKey(BackupManagerSession backupManagerSession, ResultSet res) throws SQLException {
        this.backupManagerSession = backupManagerSession;
        this.uid = new UID(res.getBytes(UID_));
        try {
            this.encryptionPublicKey = (EncryptionPublicKey)new Encoded(res.getBytes(ENCRYPTION_PUBLIC_KEY)).decodePublicKey();
            this.macKey = (MACKey)new Encoded(res.getBytes(MAC_KEY)).decodeSymmetricKey();
        }
        catch (DecodingException | ClassCastException e) {
            Logger.e("Unable to parse encryption public key or MAC key in BackupKey database!!!");
        }
        this.keyGenerationTimestamp = res.getLong(KEY_GENERATION_TIMESTAMP);
        this.lastSuccessfulKeyVerificationTimestamp = res.getLong(LAST_SUCCESSFUL_KEY_VERIFICATION_TIMESTAMP);
        this.lastKeyVerificationPromptTimestamp = res.getLong(LAST_KEY_VERIFICATION_PROMPT_TIMESTAMP);
        this.successfulVerificationCount = res.getInt(SUCCESSFUL_VERIFICATION_COUNT);
        this.uploadedBackupVersion = res.getInt(UPLOADED_BACKUP_VERSION);
        if (res.wasNull()) {
            this.uploadedBackupVersion = null;
        }
        this.exportedBackupVersion = res.getInt(EXPORTED_BACKUP_VERSION);
        if (res.wasNull()) {
            this.exportedBackupVersion = null;
        }
        this.latestBackupVersion = res.getInt(LATEST_BACKUP_VERSION);
        if (res.wasNull()) {
            this.latestBackupVersion = null;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS backup_key (uid BLOB PRIMARY KEY, encryption_public_key BLOB NOT NULL, mac_key BLOB NOT NULL, key_generation_timestamp INTEGER NOT NULL, last_successful_key_verification_timestamp INTEGER NOT NULL, last_key_verification_prompt_timestamp INTEGER NOT NULL, successful_verification_count INTEGER NOT NULL, uploaded_backup_version INTEGER, exported_backup_version INTEGER, latest_backup_version INTEGER, FOREIGN KEY (uid,uploaded_backup_version) REFERENCES backup (backup_key_uid,version), FOREIGN KEY (uid,exported_backup_version) REFERENCES backup (backup_key_uid,version), FOREIGN KEY (uid,latest_backup_version) REFERENCES backup (backup_key_uid,version));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 36 && newVersion >= 36) {
            Logger.d("MIGRATING `backup_key` DATABASE FROM VERSION " + oldVersion + " TO 36");
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE backup_key_new ( uid BLOB PRIMARY KEY,  encryption_public_key BLOB NOT NULL,  mac_key BLOB NOT NULL,  key_generation_timestamp INTEGER NOT NULL,  last_successful_key_verification_timestamp INTEGER NOT NULL,  last_key_verification_prompt_timestamp INTEGER NOT NULL,  successful_verification_count INTEGER NOT NULL,  uploaded_backup_version INTEGER,  exported_backup_version INTEGER,  latest_backup_version INTEGER, FOREIGN KEY (uid, uploaded_backup_version) REFERENCES backup (backup_key_uid, version), FOREIGN KEY (uid, exported_backup_version) REFERENCES backup (backup_key_uid, version), FOREIGN KEY (uid, latest_backup_version) REFERENCES backup (backup_key_uid, version));");
                ResultSet res = statement.executeQuery("SELECT * FROM backup_key WHERE uid IS NULL");
                if (res.next()) {
                    try (PreparedStatement ps = session.prepareStatement("INSERT INTO backup_key_new VALUES (?,?,?,?,?, ?,?,?,?,?)");){
                        ps.setBytes(1, new UID(Suite.getDefaultPRNGService(0)).getBytes());
                        ps.setBytes(2, res.getBytes(ENCRYPTION_PUBLIC_KEY));
                        ps.setBytes(3, res.getBytes(MAC_KEY));
                        ps.setLong(4, res.getLong(KEY_GENERATION_TIMESTAMP));
                        ps.setLong(5, res.getLong(LAST_SUCCESSFUL_KEY_VERIFICATION_TIMESTAMP));
                        ps.setLong(6, res.getLong(LAST_KEY_VERIFICATION_PROMPT_TIMESTAMP));
                        ps.setInt(7, res.getInt(SUCCESSFUL_VERIFICATION_COUNT));
                        ps.setNull(8, 4);
                        ps.setNull(9, 4);
                        ps.setNull(10, 4);
                        ps.executeUpdate();
                    }
                    statement.execute("DELETE FROM backup");
                } else {
                    statement.execute("INSERT into backup_key_new (uid, encryption_public_key, mac_key, key_generation_timestamp, last_successful_key_verification_timestamp, last_key_verification_prompt_timestamp, successful_verification_count, uploaded_backup_version, exported_backup_version, latest_backup_version) SELECT uid, encryption_public_key, mac_key, key_generation_timestamp, last_successful_key_verification_timestamp, last_key_verification_prompt_timestamp, successful_verification_count, uploaded_backup_version, exported_backup_version, latest_backup_version FROM backup_key");
                }
                statement.execute("DROP TABLE backup_key");
                statement.execute("ALTER TABLE backup_key_new RENAME TO backup_key");
            }
            oldVersion = 36;
        }
    }

    public static void deleteAll(BackupManagerSession backupManagerSession) throws SQLException {
        try (PreparedStatement statement = backupManagerSession.session.prepareStatement("BackupKey.deleteAll", "DELETE FROM backup_key;");){
            statement.executeUpdate();
        }
        Backup.deleteAll(backupManagerSession);
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.insert", "INSERT INTO backup_key VALUES (?,?,?,?,?, ?,?,?,?,?);");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, Encoded.of(this.encryptionPublicKey).getBytes());
            statement.setBytes(3, Encoded.of(this.macKey).getBytes());
            statement.setLong(4, this.keyGenerationTimestamp);
            statement.setLong(5, this.lastSuccessfulKeyVerificationTimestamp);
            statement.setLong(6, this.lastKeyVerificationPromptTimestamp);
            statement.setInt(7, this.successfulVerificationCount);
            if (this.uploadedBackupVersion == null) {
                statement.setNull(8, 4);
            } else {
                statement.setInt(8, this.uploadedBackupVersion);
            }
            if (this.exportedBackupVersion == null) {
                statement.setNull(9, 4);
            } else {
                statement.setInt(9, this.exportedBackupVersion);
            }
            if (this.latestBackupVersion == null) {
                statement.setNull(10, 4);
            } else {
                statement.setInt(10, this.latestBackupVersion);
            }
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.delete", "DELETE FROM backup_key WHERE uid = ?;");){
            statement.setBytes(1, this.uid.getBytes());
            statement.executeUpdate();
        }
    }

    public void addSuccessfulVerification() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.addSuccessfulVerification", "UPDATE backup_key SET successful_verification_count = ?, last_successful_key_verification_timestamp = ?  WHERE uid = ?;");){
            long timestamp = System.currentTimeMillis();
            statement.setInt(1, this.successfulVerificationCount + 1);
            statement.setLong(2, timestamp);
            statement.setBytes(3, this.uid.getBytes());
            statement.executeUpdate();
            ++this.successfulVerificationCount;
            this.lastSuccessfulKeyVerificationTimestamp = timestamp;
        }
    }

    public void setLastKeyVerificationPromptTimestamp() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.setLastKeyVerificationPromptTimestamp", "UPDATE backup_key SET last_key_verification_prompt_timestamp = ?  WHERE uid = ?;");){
            long timestamp = System.currentTimeMillis();
            statement.setLong(1, timestamp);
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
            this.lastKeyVerificationPromptTimestamp = timestamp;
        }
    }

    public void setLatestBackupVersion(int version) throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.setLatestBackupVersion", "UPDATE backup_key SET latest_backup_version = ?  WHERE uid = ?;");){
            statement.setInt(1, version);
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
            this.latestBackupVersion = version;
        }
    }

    public void setExportedBackupVersion(int version) throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.setExportedBackupVersion", "UPDATE backup_key SET exported_backup_version = ?  WHERE uid = ?;");){
            statement.setInt(1, version);
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
            this.exportedBackupVersion = version;
        }
    }

    public void setUploadedBackupVersion(int version) throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("BackupKey.setUploadedBackupVersion", "UPDATE backup_key SET uploaded_backup_version = ?  WHERE uid = ?;");){
            statement.setInt(1, version);
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
            this.uploadedBackupVersion = version;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BackupKey get(BackupManagerSession backupManagerSession, UID backupKeyUid) {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("BackupKey.get", "SELECT * FROM backup_key WHERE uid = ?;");){
            preparedStatement.setBytes(1, backupKeyUid.getBytes());
            ResultSet res = preparedStatement.executeQuery();
            if (res.next()) {
                BackupKey backupKey2 = new BackupKey(backupManagerSession, res);
                return backupKey2;
            }
            BackupKey backupKey = null;
            return backupKey;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static BackupKey[] getAll(BackupManagerSession backupManagerSession) {
        BackupKey[] backupKeyArray;
        block9: {
            PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("BackupKey.getAll", "SELECT * FROM backup_key;");
            try {
                ResultSet res = preparedStatement.executeQuery();
                ArrayList<BackupKey> list = new ArrayList<BackupKey>();
                while (res.next()) {
                    list.add(new BackupKey(backupManagerSession, res));
                }
                backupKeyArray = list.toArray(new BackupKey[0]);
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return new BackupKey[0];
                }
            }
            preparedStatement.close();
        }
        return backupKeyArray;
    }

    public Backup getUploadedBackup() {
        if (this.uploadedBackupVersion == null) {
            return null;
        }
        return Backup.get(this.backupManagerSession, this.uid, this.uploadedBackupVersion);
    }

    public Backup getExportedBackup() {
        if (this.exportedBackupVersion == null) {
            return null;
        }
        return Backup.get(this.backupManagerSession, this.uid, this.exportedBackupVersion);
    }

    @Override
    public void wasCommitted() {
    }
}

