/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.databases;

import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Backup
implements ObvDatabase {
    static final String TABLE_NAME = "backup";
    private final BackupManagerSession backupManagerSession;
    private UID backupKeyUid;
    static final String BACKUP_KEY_UID = "backup_key_uid";
    private int version;
    static final String VERSION = "version";
    private boolean forExport;
    static final String FOR_EXPORT = "for_export";
    private int status;
    static final String STATUS = "status";
    private long statusChangeTimestamp;
    static final String STATUS_CHANGE_TIMESTAMP = "status_change_timestamp";
    private byte[] encryptedContent;
    static final String ENCRYPTED_CONTENT = "encrypted_content";
    private int backupJsonVersion;
    static final String BACKUP_JSON_VERSION = "backup_json_version";
    public static final int STATUS_ONGOING = 0;
    public static final int STATUS_READY = 1;
    public static final int STATUS_UPLOADED_OR_EXPORTED = 2;
    public static final int STATUS_FAILED = -1;

    public static void cleanup(BackupManagerSession backupManagerSession, UID backupKeyUid, Integer uploadedBackupVersion, Integer exportedBackupVersion, Integer latestBackupVersion) throws SQLException {
        try (PreparedStatement statement = backupManagerSession.session.prepareStatement("Backup.cleanup", "DELETE FROM backup WHERE backup_key_uid = ?  AND version NOT IN (?,?,?);");){
            statement.setBytes(1, backupKeyUid.getBytes());
            statement.setInt(2, uploadedBackupVersion != null ? uploadedBackupVersion : -1);
            statement.setInt(3, exportedBackupVersion != null ? exportedBackupVersion : -1);
            statement.setInt(4, latestBackupVersion != null ? latestBackupVersion : -1);
            statement.executeUpdate();
        }
    }

    public boolean isForExport() {
        return this.forExport;
    }

    public int getStatus() {
        return this.status;
    }

    public int getBackupJsonVersion() {
        return this.backupJsonVersion;
    }

    public long getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public int getVersion() {
        return this.version;
    }

    public static Backup createOngoingBackup(BackupManagerSession backupManagerSession, UID backupKeyUid, int version, boolean forExport) {
        if (backupKeyUid == null) {
            return null;
        }
        try {
            Backup backup = new Backup(backupManagerSession, backupKeyUid, version, forExport, 0, System.currentTimeMillis(), null, 0);
            backup.insert();
            return backup;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private Backup(BackupManagerSession backupManagerSession, UID backupKeyUid, int version, boolean forExport, int status, long statusChangeTimestamp, byte[] encryptedContent, int backupJsonVersion) {
        this.backupManagerSession = backupManagerSession;
        this.backupKeyUid = backupKeyUid;
        this.version = version;
        this.forExport = forExport;
        this.status = status;
        this.statusChangeTimestamp = statusChangeTimestamp;
        this.encryptedContent = encryptedContent;
        this.backupJsonVersion = backupJsonVersion;
    }

    private Backup(BackupManagerSession backupManagerSession, ResultSet res) throws SQLException {
        this.backupManagerSession = backupManagerSession;
        this.backupKeyUid = new UID(res.getBytes(BACKUP_KEY_UID));
        this.version = res.getInt(VERSION);
        this.forExport = res.getBoolean(FOR_EXPORT);
        this.status = res.getInt(STATUS);
        this.statusChangeTimestamp = res.getLong(STATUS_CHANGE_TIMESTAMP);
        this.encryptedContent = res.getBytes(ENCRYPTED_CONTENT);
        this.backupJsonVersion = res.getInt(BACKUP_JSON_VERSION);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS backup (backup_key_uid BLOB NOT NULL, version INTEGER NOT NULL, for_export BIT NOT NULL, status INTEGER NOT NULL, status_change_timestamp INTEGER NOT NULL, encrypted_content BLOB, backup_json_version INTEGER NOT NULL, CONSTRAINT PK_backup PRIMARY KEY(backup_key_uid, version));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("Backup.insert", "INSERT INTO backup VALUES (?,?,?,?,?, ?,?);");){
            statement.setBytes(1, this.backupKeyUid.getBytes());
            statement.setInt(2, this.version);
            statement.setBoolean(3, this.forExport);
            statement.setInt(4, this.status);
            statement.setLong(5, this.statusChangeTimestamp);
            statement.setBytes(6, this.encryptedContent);
            statement.setInt(7, this.backupJsonVersion);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("Backup.delete", "DELETE FROM backup WHERE backup_key_uid = ? AND version = ?;");){
            statement.setBytes(1, this.backupKeyUid.getBytes());
            statement.setInt(2, this.version);
            statement.executeUpdate();
        }
    }

    static void deleteAll(BackupManagerSession backupManagerSession) throws SQLException {
        try (PreparedStatement statement = backupManagerSession.session.prepareStatement("Backup.deleteAll", " DELETE FROM backup;");){
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Backup get(BackupManagerSession backupManagerSession, UID backupKeyUid, int version) {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("Backup.get", "SELECT * FROM backup WHERE backup_key_uid = ? AND version = ?;");){
            preparedStatement.setBytes(1, backupKeyUid.getBytes());
            preparedStatement.setInt(2, version);
            ResultSet res = preparedStatement.executeQuery();
            if (res.next()) {
                Backup backup2 = new Backup(backupManagerSession, res);
                return backup2;
            }
            Backup backup = null;
            return backup;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void setReady(byte[] encryptedContent) throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("Backup.setReady", "UPDATE backup SET status = ?, encrypted_content = ?, status_change_timestamp = ?  WHERE backup_key_uid = ? AND version = ?;");){
            long timestamp = System.currentTimeMillis();
            statement.setInt(1, 1);
            statement.setBytes(2, encryptedContent);
            statement.setLong(3, timestamp);
            statement.setBytes(4, this.backupKeyUid.getBytes());
            statement.setInt(5, this.version);
            statement.executeUpdate();
            this.status = 1;
            this.encryptedContent = encryptedContent;
            this.statusChangeTimestamp = timestamp;
        }
    }

    public void setUploadedOrExported() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("Backup.setUploadedOrExported", "UPDATE backup SET status = ?, status_change_timestamp = ?  WHERE backup_key_uid = ? AND version = ? AND for_export = 0;");){
            long timestamp = System.currentTimeMillis();
            statement.setInt(1, 2);
            statement.setLong(2, timestamp);
            statement.setBytes(3, this.backupKeyUid.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.status = 2;
            this.statusChangeTimestamp = timestamp;
        }
    }

    public void setFailed() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("Backup.setFailed", "UPDATE backup SET status = ?, status_change_timestamp = ?  WHERE backup_key_uid = ? AND version = ? AND for_export = 0;");){
            long timestamp = System.currentTimeMillis();
            statement.setInt(1, -1);
            statement.setLong(2, timestamp);
            statement.setBytes(3, this.backupKeyUid.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.status = -1;
            this.statusChangeTimestamp = timestamp;
        }
    }

    @Override
    public void wasCommitted() {
    }
}

