/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine;

import java.util.UUID;

public class Logger {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int NONE = 10;
    private static int outputLogLevel = 10;
    private static LogOutputter outputter = null;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static void setOutputter(LogOutputter outputter) {
        Logger.outputter = outputter;
    }

    private static void log(int logLevel, String message) {
        if (logLevel >= outputLogLevel) {
            if (outputter == null) {
                System.out.println(message);
            } else {
                switch (logLevel) {
                    case 0: {
                        outputter.d("Logger", message);
                        break;
                    }
                    case 1: {
                        outputter.i("Logger", message);
                        break;
                    }
                    case 2: {
                        outputter.w("Logger", message);
                        break;
                    }
                    case 3: {
                        outputter.e("Logger", message);
                    }
                }
            }
        }
    }

    public static void setOutputLogLevel(int outputLogLevel) {
        Logger.outputLogLevel = outputLogLevel;
    }

    public static void d(String message) {
        Logger.log(0, message);
    }

    public static void i(String message) {
        Logger.log(1, message);
    }

    public static void w(String message) {
        Logger.log(2, message);
    }

    public static void e(String message) {
        Logger.log(3, message);
    }

    public static void e(String message, Exception e) {
        Logger.log(3, message + "( " + e.toString() + ")");
        Logger.x(e);
    }

    public static void x(Throwable throwable) {
        if (2 >= outputLogLevel) {
            outputter.x("Logger", throwable);
        }
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] fromHexString(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static String getUuidString(UUID uuid) {
        if (uuid == null) {
            return "";
        }
        return Logger.digits(uuid.getMostSignificantBits() >> 32, 8) + "-" + Logger.digits(uuid.getMostSignificantBits() >> 16, 4) + "-" + Logger.digits(uuid.getMostSignificantBits(), 4) + "-" + Logger.digits(uuid.getLeastSignificantBits() >> 48, 4) + "-" + Logger.digits(uuid.getLeastSignificantBits(), 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static interface LogOutputter {
        public void d(String var1, String var2);

        public void i(String var1, String var2);

        public void w(String var1, String var2);

        public void e(String var1, String var2);

        public void x(String var1, Throwable var2);
    }
}

