/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.List;
import org.reactfx.collection.ListModificationLike;
import org.reactfx.collection.MaterializedListModificationImpl;
import org.reactfx.util.Lists;

public interface MaterializedListModification<E>
extends ListModificationLike<E> {
    public static <E> MaterializedListModification<E> create(int pos, List<? extends E> removed, List<? extends E> added) {
        return new MaterializedListModificationImpl<E>(pos, removed, added);
    }

    public List<? extends E> getAdded();

    @Override
    default public int getAddedSize() {
        return this.getAdded().size();
    }

    default public MaterializedListModification<E> trim() {
        return Lists.commonPrefixSuffixLengths(this.getRemoved(), this.getAdded()).map((pref, suff) -> {
            if (pref == 0 && suff == 0) {
                return this;
            }
            return MaterializedListModification.create(this.getFrom() + pref, this.getRemoved().subList((int)pref, this.getRemovedSize() - suff), this.getAdded().subList((int)pref, this.getAddedSize() - suff));
        });
    }
}

