/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.utils.mail;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class Email {
    public static String getCreateUserEmailSubject(KeycloakSession session, String isocode, UserModel userModel) {
        if (isocode == null) {
            isocode = "fr";
        }
        String template = switch (isocode) {
            case "en" -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.EN, TemplateEngine.Template.CREATE_USER, TemplateEngine.EmailPart.SUBJECT), "Olvid Management Console: your password");
            default -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.FR, TemplateEngine.Template.CREATE_USER, TemplateEngine.EmailPart.SUBJECT), "Console de Gestion Olvid\u00a0: votre mot de passe");
        };
        if (userModel == null) {
            return template;
        }
        return TemplateEngine.replaceTemplateFields(userModel, null, template, false);
    }

    public static String getCreateUserEmailBodyText(KeycloakSession session, String isocode, UserModel userModel, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        String template = switch (isocode) {
            case "en" -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.EN, TemplateEngine.Template.CREATE_USER, TemplateEngine.EmailPart.TEXT_BODY), "Hello [[username]]!\n\nYour temporary password is: [[password]]\nYou will be requested to change it on your first connection.\n\nRegards,\n\n-- The Olvid Management Console\n");
            default -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.FR, TemplateEngine.Template.CREATE_USER, TemplateEngine.EmailPart.TEXT_BODY), "Bonjour [[username]]\u00a0!\n\nVotre mot de passe temporaire est\u00a0: [[password]]\nIl vous sera demand\u00e9 de le changer lors de votre premi\u00e8re connexion.\n\nRespectueusement,\n\n-- La Console de Gestion Olvid\n");
        };
        if (userModel == null) {
            return template;
        }
        return TemplateEngine.replaceTemplateFields(userModel, password, template, false);
    }

    public static String getCreateUserEmailBodyHTML(KeycloakSession session, String isocode, UserModel userModel, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        String template = switch (isocode) {
            case "en" -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.EN, TemplateEngine.Template.CREATE_USER, TemplateEngine.EmailPart.HTML_BODY), "<p>Hello [[username]]!</p>\n\n<p>Your temporary password is: <strong>[[password]]</strong></p>\n<p>You will be requested to change it on your first connection.</p>\n\n<p>Regards,</p>\n\n<p>-- The Olvid Management Console</p>\n");
            default -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.FR, TemplateEngine.Template.CREATE_USER, TemplateEngine.EmailPart.HTML_BODY), "<p>Bonjour [[username]]\u00a0!</p>\n\n<p>Votre mot de passe temporaire est\u00a0: <strong>[[password]]</strong></p>\n<p>Il vous sera demand\u00e9 de le changer lors de votre premi\u00e8re connexion.</p>\n\n<p>Respectueusement,</p>\n\n<p>-- La Console de Gestion Olvid</p>\n");
        };
        if (userModel == null) {
            return template;
        }
        return TemplateEngine.replaceTemplateFields(userModel, password, template, true);
    }

    public static String getPasswordResetEmailSubject(KeycloakSession session, String isocode, UserModel userModel) {
        if (isocode == null) {
            isocode = "fr";
        }
        String template = switch (isocode) {
            case "en" -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.EN, TemplateEngine.Template.RESET_PASSWORD, TemplateEngine.EmailPart.SUBJECT), "Olvid Management Console: password reset");
            default -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.FR, TemplateEngine.Template.RESET_PASSWORD, TemplateEngine.EmailPart.SUBJECT), "Console de Gestion Olvid\u00a0: r\u00e9initialisation de mot de passe");
        };
        if (userModel == null) {
            return template;
        }
        return TemplateEngine.replaceTemplateFields(userModel, null, template, false);
    }

    public static String getPasswordResetEmailBodyText(KeycloakSession session, String isocode, UserModel userModel, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        String template = switch (isocode) {
            case "en" -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.EN, TemplateEngine.Template.RESET_PASSWORD, TemplateEngine.EmailPart.TEXT_BODY), "Hello [[username]]!\n\nYour password has been reset.\nYour temporary password is: [[password]]\nYou will be requested to change it on your next connection.\n\nRegards,\n\n-- The Olvid Management Console\n");
            default -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.FR, TemplateEngine.Template.RESET_PASSWORD, TemplateEngine.EmailPart.TEXT_BODY), "Bonjour [[username]]\u00a0!\n\nVotre mot de passe a \u00e9t\u00e9 r\u00e9initialis\u00e9.\nVotre mot de passe temporaire est\u00a0: [[password]]\nIl vous sera demand\u00e9 de le changer lors de votre prochaine connexion.\n\nRespectueusement,\n\n-- La Console de Gestion Olvid\n");
        };
        if (userModel == null) {
            return template;
        }
        return TemplateEngine.replaceTemplateFields(userModel, password, template, false);
    }

    public static String getPasswordResetEmailBodyHTML(KeycloakSession session, String isocode, UserModel userModel, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        String template = switch (isocode) {
            case "en" -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.EN, TemplateEngine.Template.RESET_PASSWORD, TemplateEngine.EmailPart.HTML_BODY), "<p>Hello [[username]]!</p>\n<p>Your password has been reset.</p>\n<p>Your temporary password is: <strong>[[password]]</strong></p>\n<p>You will be requested to change it on your next connection.</p>\n<p>Regards,</p>\n<p>-- The Olvid Management Console</p>\n");
            default -> Objects.requireNonNullElse(TemplateEngine.getTemplateIfExists(session.getClass().getClassLoader(), TemplateEngine.Lang.FR, TemplateEngine.Template.RESET_PASSWORD, TemplateEngine.EmailPart.HTML_BODY), "<p>Bonjour [[username]]\u00a0!</p>\n<p>Votre mot de passe a \u00e9t\u00e9 r\u00e9initialis\u00e9.</p>\n<p>Votre mot de passe temporaire est\u00a0: <strong>[[password]]</strong></p>\n<p>Il vous sera demand\u00e9 de le changer lors de votre prochaine connexion.</p>\n<p>Respectueusement,</p>\n<p>-- La Console de Gestion Olvid</p>\n");
        };
        if (userModel == null) {
            return template;
        }
        return TemplateEngine.replaceTemplateFields(userModel, password, template, true);
    }

    public static String getUserOldDeviceAlertSubject(String isocode) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Olvid Management Console: Old Device Alert";
            }
        }
        return "TODO FR Console de Gestion Olvid\u00a0: Old Device Alert";
    }

    public static String getUserOldDeviceAlertBodyText(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Hello " + username + "!\n\nYour device " + displayName + " has on old device sync.\nRegards,\n\n-- The Olvid Management Console";
            }
        }
        return "TODO FR Hello " + username + "!\n\nTODO FR Your device " + displayName + "has on old device sync.\nRespectueusement,\n\n-- La Console de Gestion Olvid";
    }

    public static String getUserOldDeviceAlertBodyHTML(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "<p>Hello " + username + "!</p><p>Your device: <strong>" + displayName + "</strong> has on old device sync.</p><p>Regards,</p><p>-- The Olvid Management Console</p>";
            }
        }
        return "<p>TODO FR Bonjour " + username + "\u00a0!</p><p>Your device: <strong>" + displayName + "</strong> has on old device sync.</p><p>Respectueusement,</p><p>-- La Console de Gestion Olvid</p>";
    }

    public static String getUserUnknownDeviceAlertBodyHTML(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "<p>Hello " + username + "!</p><p>Your device: <strong>" + displayName + "</strong> is not known by our service.</p><p>Please, Contact us for set is : known </p><p>Regards,</p><p>-- The Olvid Management Console</p>";
            }
        }
        return "<p>TODO FR Bonjour " + username + "\u00a0!</p><p>Your device: <strong>" + displayName + "</strong> is not known by our service.</p><p>S'il vous plait, Contactez nous pour que nous puissions le passer \u00e0 : connu </p><p>Respectueusement,</p><p>-- La Console de Gestion Olvid</p>";
    }

    public static String getUserUnknownDeviceAlertBodyText(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Hello " + username + "!\n\nYour device " + displayName + " has on old device sync.\nRegards,\n\n-- The Olvid Management Console";
            }
        }
        return "TODO FR Hello " + username + "!\n\nYour device " + displayName + "has on old device sync.\nRespectueusement,\n\n-- La Console de Gestion Olvid";
    }

    public static String getUserUnknownDeviceAlertSubject(String isocode) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Olvid Management Console: Unknown Device Alert";
            }
        }
        return "TODO FR Console de Gestion Olvid\u00a0: Unknown Device Alert";
    }

    static class TemplateEngine {
        TemplateEngine() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static String getTemplateIfExists(ClassLoader classLoader, Lang lang, Template template, EmailPart emailPart) {
            Object templateFileName = "/olvid_";
            switch (lang.ordinal()) {
                case 0: {
                    templateFileName = (String)templateFileName + "fr_";
                    break;
                }
                case 1: {
                    templateFileName = (String)templateFileName + "en_";
                    break;
                }
            }
            switch (template.ordinal()) {
                case 0: {
                    templateFileName = (String)templateFileName + "create_user_";
                    break;
                }
                case 1: {
                    templateFileName = (String)templateFileName + "reset_password_";
                    break;
                }
            }
            switch (emailPart.ordinal()) {
                case 0: {
                    templateFileName = (String)templateFileName + "subject.txt";
                    break;
                }
                case 1: {
                    templateFileName = (String)templateFileName + "text_body.txt";
                    break;
                }
                case 2: {
                    templateFileName = (String)templateFileName + "html_body.txt";
                    break;
                }
            }
            try (InputStream is = classLoader.getResourceAsStream((String)templateFileName);){
                if (is == null) {
                    String string2 = null;
                    return string2;
                }
                String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
            catch (Exception e) {
                return null;
            }
        }

        static String replaceTemplateFields(UserModel userModel, String password, String templateText, boolean isHtml) {
            String out = templateText;
            block8: for (TemplateField field : TemplateField.values()) {
                switch (field.ordinal()) {
                    case 0: {
                        if (userModel == null || userModel.getUsername() == null) continue block8;
                        out = out.replaceAll(Pattern.quote(field.value), isHtml ? StringEscapeUtils.escapeHtml3(userModel.getUsername()) : userModel.getUsername());
                        continue block8;
                    }
                    case 1: {
                        if (userModel == null || userModel.getFirstName() == null) continue block8;
                        out = out.replaceAll(Pattern.quote(field.value), isHtml ? StringEscapeUtils.escapeHtml3(userModel.getFirstName()) : userModel.getFirstName());
                        continue block8;
                    }
                    case 2: {
                        if (userModel == null || userModel.getLastName() == null) continue block8;
                        out = out.replaceAll(Pattern.quote(field.value), isHtml ? StringEscapeUtils.escapeHtml3(userModel.getLastName()) : userModel.getLastName());
                        continue block8;
                    }
                    case 3: {
                        if (userModel == null) continue block8;
                        Object fullName = userModel.getFirstName() == null || userModel.getFirstName().isBlank() ? userModel.getLastName() : (userModel.getLastName() == null || userModel.getLastName().isBlank() ? userModel.getFirstName() : userModel.getFirstName() + " " + userModel.getLastName());
                        out = out.replaceAll(Pattern.quote(field.value), (String)(isHtml ? StringEscapeUtils.escapeHtml3((String)fullName) : fullName));
                        continue block8;
                    }
                    case 4: {
                        if (userModel == null || userModel.getEmail() == null) continue block8;
                        out = out.replaceAll(Pattern.quote(field.value), isHtml ? StringEscapeUtils.escapeHtml3(userModel.getEmail()) : userModel.getEmail());
                        continue block8;
                    }
                    case 5: {
                        if (password == null) continue block8;
                        out = out.replaceAll(Pattern.quote(field.value), isHtml ? StringEscapeUtils.escapeHtml3(password) : password);
                    }
                }
            }
            return out;
        }

        static enum Lang {
            FR,
            EN;

        }

        static enum Template {
            CREATE_USER,
            RESET_PASSWORD;

        }

        static enum EmailPart {
            SUBJECT,
            TEXT_BODY,
            HTML_BODY;

        }

        static enum TemplateField {
            USERNAME("[[username]]"),
            FIRST_NAME("[[first_name]]"),
            LAST_NAME("[[last_name]]"),
            FULL_NAME("[[full_name]]"),
            EMAIL("[[email]]"),
            PASSWORD("[[password]]");

            public final String value;

            private TemplateField(String value) {
                this.value = value;
            }
        }
    }
}

