/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.oneTimeJob;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidNotifications;
import io.olvid.keycloak.jpa.OlvidNotificationsDao;
import io.olvid.keycloak.timer.CronScheduler;
import io.olvid.keycloak.timer.oneTimeJob.ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;

public class PluginVersionUpgradeOneTimeJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public PluginVersionUpgradeOneTimeJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info((Object)"Starting PluginVersionUpgradeOneTimeJob one time job");
        try (KeycloakSession session = this.factory.create();){
            KeycloakTransactionManager transactionManager = session.getTransactionManager();
            ObjectMapper jsonObjectMapper = new ObjectMapper();
            jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            boolean transactionCompletedSuccessfully = false;
            try {
                transactionManager.begin();
                String lastRunPluginVersionString = OlvidConfigurationDao.getStringConfiguration(em, "master", "pluginVersion");
                if (!Objects.equals(lastRunPluginVersionString, "4.5.1")) {
                    int lastRunPluginVersion = lastRunPluginVersionString == null ? 0 : PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(lastRunPluginVersionString);
                    if (lastRunPluginVersion < 30003) {
                        this.logger.info((Object)"Performing 3.0.3 version migration");
                        em.createNamedQuery("OlvidConsoleLogs.applyVersion30003").executeUpdate();
                        em.createNamedQuery("OlvidRevocation.applyVersion30003").executeUpdate();
                        CronScheduler.scheduleOneTimeJob(new ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob(this.factory, this.logger));
                        lastRunPluginVersion = 30003;
                    }
                    if (lastRunPluginVersion < 40001) {
                        this.logger.info((Object)"Performing 4.0.1 version migration");
                        OlvidConfigurationDao.setConfiguration(em, "master", "enablePrometheusMetrics", null);
                        lastRunPluginVersion = 40001;
                    }
                    OlvidConfigurationDao.setConfiguration(em, "master", "pluginVersion", "4.5.1");
                    int currentVersion = PluginVersionUpgradeOneTimeJob.getPluginVersionFromString("4.5.1");
                    List<OlvidNotifications> onList = OlvidNotificationsDao.getOlvidNotificationsVersion(em);
                    long timestamp = System.currentTimeMillis();
                    onList.forEach(on -> {
                        if (PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(on.getValue()) <= currentVersion) {
                            on.setIsRead(true);
                            on.setReadDate(timestamp);
                            on.setReaderUserId("cronJob");
                            em.merge(on);
                        }
                    });
                }
                transactionCompletedSuccessfully = true;
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception in PluginVersionUpgradeOneTimeJob", (Throwable)e);
            }
            finally {
                if (transactionCompletedSuccessfully) {
                    transactionManager.commit();
                } else {
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending PluginVersionUpgradeOneTimeJob one time job");
            }
        }
    }

    public static int getPluginVersionFromString(String pluginVersionString) {
        try {
            int pluginVersion = 0;
            String[] pluginVersionStringSplit = pluginVersionString.split("\\.");
            for (int i = 0; i < pluginVersionStringSplit.length; ++i) {
                if (i == 0) {
                    pluginVersion += Integer.parseInt(pluginVersionStringSplit[i]) * 10000;
                    continue;
                }
                if (i == 1) {
                    pluginVersion += Integer.parseInt(pluginVersionStringSplit[i]) * 100;
                    continue;
                }
                if (i != 2) continue;
                pluginVersion += Integer.parseInt(pluginVersionStringSplit[i]);
            }
            return pluginVersion;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

