/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.oneTimeJob;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.EntityManager;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;

public class ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info((Object)"Starting ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob one time job");
        try (KeycloakSession session = this.factory.create();){
            KeycloakTransactionManager transactionManager = session.getTransactionManager();
            ObjectMapper jsonObjectMapper = new ObjectMapper();
            jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            boolean transactionCompletedSuccessfully = false;
            try {
                transactionManager.begin();
                session.realms().getRealmsStream().forEach(realmModel -> {
                    session.getContext().setRealm(realmModel);
                    session.groups().getGroupsStream(realmModel).forEach(group -> {
                        try {
                            String olvidName = Utils.getGroupAttribute(group, "olvid-name");
                            if (olvidName == null) {
                                olvidName = Utils.getGroupAttribute(group, "custom-name");
                            }
                            Utils.setGroupAttribute(group, "olvid-name", olvidName);
                            Utils.setGroupAttribute(group, "custom-name", null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                });
                transactionCompletedSuccessfully = true;
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception in ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob", (Throwable)e);
            }
            finally {
                if (transactionCompletedSuccessfully) {
                    transactionManager.commit();
                } else {
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending ChangeGroupAttributeCustomNameToOlvidNameOneTimeJob one time job");
            }
        }
    }
}

