/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.users;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import io.olvid.keycloak.jpa.OlvidUser;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.utils.KeycloakSessionUtil;

public class DetectUserModificationsJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;
    private final ObjectMapper jsonObjectMapper;
    public static final long MAX_TRANSACTION_DURATION = 10000L;

    public DetectUserModificationsJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
        this.jsonObjectMapper = new ObjectMapper();
        this.jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        KeycloakTransactionManager transactionManager;
        Object transactionManager2;
        this.logger.info((Object)"Starting User modification detection task");
        long currentTimestamp = System.currentTimeMillis();
        HashSet olvidRealmIds = new HashSet();
        try (KeycloakSession session = this.factory.create();){
            KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
            transactionManager2 = session.getTransactionManager();
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            try {
                transactionManager2.begin();
                session.realms().getRealmsStream().forEach(realmModel -> {
                    session.getContext().setRealm(realmModel);
                    if (OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "olvid", false)) {
                        olvidRealmIds.add(realmModel.getId());
                    }
                });
            }
            finally {
                transactionManager2.rollback();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception in User modification detection task (part 1)", (Throwable)e);
            return;
        }
        boolean jobCompleted = false;
        try {
            transactionManager2 = olvidRealmIds.iterator();
            block44: while (true) {
                if (!transactionManager2.hasNext()) {
                    jobCompleted = true;
                    this.logger.info((Object)("Ending User modification detection task: " + (jobCompleted ? "success" : "failed")));
                    try (KeycloakSession session = this.factory.create();){
                        KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                        transactionManager = session.getTransactionManager();
                        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        try {
                            transactionManager.begin();
                            OlvidLogsBackend item = new OlvidLogsBackend();
                            item.setLogType(new CronJobModel().detectUserModificationsJob);
                            item.setTimestampStart(currentTimestamp);
                            item.setTimestampEnd(System.currentTimeMillis());
                            item.setMessage(jobCompleted ? "success" : "failed");
                            em.persist((Object)item);
                            return;
                        }
                        catch (Exception item) {
                            return;
                        }
                        finally {
                            transactionManager.commit();
                        }
                    }
                }
                String realmId = (String)transactionManager2.next();
                int totalProcessedUsers = 0;
                HashSet<String> existingUserIds = new HashSet<String>();
                while (true) {
                    int processedUsers;
                    if ((processedUsers = this.subProcess(realmId, totalProcessedUsers, existingUserIds)) == 0) {
                        this.cleanUpOlvidUsers(realmId, existingUserIds);
                        continue block44;
                    }
                    this.logger.info((Object)("    User modification for realm " + realmId + " progress: " + (totalProcessedUsers += processedUsers)));
                }
                break;
            }
        }
        catch (Exception e) {
            try {
                this.logger.warn((Object)"Exception in User modification detection task (part 2)", (Throwable)e);
                this.logger.info((Object)("Ending User modification detection task: " + (jobCompleted ? "success" : "failed")));
            }
            catch (Throwable throwable) {
                this.logger.info((Object)("Ending User modification detection task: " + (jobCompleted ? "success" : "failed")));
                try (KeycloakSession session = this.factory.create();){
                    KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                    KeycloakTransactionManager transactionManager3 = session.getTransactionManager();
                    EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                    try {
                        transactionManager3.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().detectUserModificationsJob);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(System.currentTimeMillis());
                        item.setMessage(jobCompleted ? "success" : "failed");
                        em.persist((Object)item);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw throwable;
                    }
                    finally {
                        transactionManager3.commit();
                    }
                }
            }
            try (KeycloakSession session = this.factory.create();){
                KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                transactionManager = session.getTransactionManager();
                EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().detectUserModificationsJob);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(System.currentTimeMillis());
                    item.setMessage(jobCompleted ? "success" : "failed");
                    em.persist((Object)item);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    transactionManager.commit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int subProcess(String realmId, int offset, HashSet<String> existingUserIds) {
        try (KeycloakSession session = this.factory.create();){
            int n;
            block12: {
                KeycloakTransactionManager transactionManager;
                block11: {
                    KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                    transactionManager = session.getTransactionManager();
                    EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                    HashSet<UserOrTopicToNotify> usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
                    SignatureSignerContext[] signatureSignerContext = new SignatureSignerContext[]{null};
                    boolean transactionCompletedSuccessfully = false;
                    long startTime = System.currentTimeMillis();
                    try {
                        transactionManager.begin();
                        RealmModel realmModel = session.realms().getRealm(realmId);
                        session.getContext().setRealm(realmModel);
                        int[] processedUsers = new int[]{0};
                        session.getContext().setRealm(realmModel);
                        session.users().searchForUserStream(realmModel, Collections.emptyMap(), Integer.valueOf(offset), Integer.valueOf(1000)).filter(userModel -> {
                            String identityToNotify;
                            OlvidUserDetails olvidUserDetails;
                            block17: {
                                processedUsers[0] = processedUsers[0] + 1;
                                olvidUserDetails = new OlvidUserDetails((UserModel)userModel);
                                identityToNotify = null;
                                if (olvidUserDetails.getIdentity() != null) {
                                    if (!userModel.isEnabled()) {
                                        if (!Utils.isUnboundUser(userModel)) {
                                            Configuration.subProcessRevokeUsers(em, session, "cron", realmModel.getName(), Collections.singletonList(userModel.getId()), 2, realmModel, this.jsonObjectMapper);
                                        }
                                        olvidUserDetails.setIdentity(null);
                                    } else {
                                        existingUserIds.add(olvidUserDetails.getId());
                                        OlvidUserDetails signedUserDetails = null;
                                        try {
                                            String signedDetails = Utils.getSignedUserDetails(session, em, this.jsonObjectMapper, realmModel, userModel);
                                            if (signedDetails != null && Utils.nullOrTrim((signedUserDetails = (OlvidUserDetails)this.jsonObjectMapper.readValue(new JWSInput(signedDetails).readContentAsString(), OlvidUserDetails.class)).getFirstname()) == null && Utils.nullOrTrim(signedUserDetails.getLastname()) == null) {
                                                try {
                                                    TypedQuery q = em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
                                                    q.setParameter("realmId", (Object)realmId);
                                                    q.setParameter("userId", (Object)userModel.getId());
                                                    OlvidUser olvidUser = (OlvidUser)q.getSingleResult();
                                                    em.remove((Object)olvidUser);
                                                }
                                                catch (NoResultException noResultException) {}
                                            }
                                        }
                                        catch (Exception signedDetails) {
                                            // empty catch block
                                        }
                                        if (signedUserDetails == null || !signedUserDetails.areContentsTheSame(olvidUserDetails) || signedUserDetails.getTimestamp() < System.currentTimeMillis() - 1296000000L) {
                                            this.logger.info((Object)"Outdated user signed details: updating them");
                                            try {
                                                if (signatureSignerContext[0] == null) {
                                                    signatureSignerContext[0] = OlvidUserDetailsSignatureSignerContext.createForRealm(session, em, realmModel);
                                                }
                                                if (signatureSignerContext[0] == null) {
                                                    this.logger.warn((Object)"Unable to update signed user details: failed to get signature context");
                                                    break block17;
                                                }
                                                Utils.updateSignedUserDetails(em, realmModel, userModel, olvidUserDetails.getSignedDetails(signatureSignerContext[0], this.jsonObjectMapper), false);
                                                identityToNotify = olvidUserDetails.getIdentity();
                                            }
                                            catch (Exception e) {
                                                this.logger.warn((Object)"Unable to check signature", (Throwable)e);
                                            }
                                        }
                                    }
                                } else {
                                    existingUserIds.add(olvidUserDetails.getId());
                                }
                            }
                            String fullSearchString = olvidUserDetails.getFullSearchString();
                            if (!Objects.equals(fullSearchString, Utils.getUserAttribute(userModel, "olvid-search"))) {
                                this.logger.info((Object)("Full search string change detected for " + userModel.getId()));
                                Utils.setUserAttribute(userModel, "olvid-search", fullSearchString);
                                identityToNotify = olvidUserDetails.getIdentity();
                            }
                            if (identityToNotify != null) {
                                this.logger.info((Object)"-> Requesting targeted push notification");
                                usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realmId, olvidUserDetails.getIdentity()));
                            }
                            return System.currentTimeMillis() > startTime + 10000L;
                        }).findFirst();
                        transactionCompletedSuccessfully = true;
                        n = processedUsers[0];
                        if (!transactionCompletedSuccessfully) break block11;
                    }
                    catch (Throwable throwable) {
                        if (transactionCompletedSuccessfully) {
                            transactionManager.commit();
                            OlvidServerApiHelper.sendNotifications(session, em, this.jsonObjectMapper, usersAndTopicsToNotify);
                        } else {
                            transactionManager.rollback();
                        }
                        throw throwable;
                    }
                    transactionManager.commit();
                    OlvidServerApiHelper.sendNotifications(session, em, this.jsonObjectMapper, usersAndTopicsToNotify);
                    break block12;
                }
                transactionManager.rollback();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOlvidUsers(String realmId, HashSet<String> existingUserIds) {
        try (KeycloakSession session = this.factory.create();){
            KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
            KeycloakTransactionManager transactionManager = session.getTransactionManager();
            ObjectMapper jsonObjectMapper = new ObjectMapper();
            jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            boolean transactionCompletedSuccessfully = false;
            try {
                transactionManager.begin();
                TypedQuery q = em.createNamedQuery("OlvidUser.getAllByRealmId", OlvidUser.class);
                q.setParameter("realmId", (Object)realmId);
                for (OlvidUser olvidUser : q.getResultList()) {
                    if (existingUserIds.contains(olvidUser.getUserId())) continue;
                    this.logger.info((Object)("Removing unnecessary OlvidUser for keycloakUserId " + olvidUser.getUserId()));
                    em.remove((Object)olvidUser);
                    TypedQuery qd = em.createNamedQuery("OlvidUserDevice.getById", OlvidUserDevice.class);
                    qd.setParameter("realmId", (Object)realmId);
                    qd.setParameter("userId", (Object)olvidUser.getUserId());
                    try {
                        qd.getResultList().forEach(arg_0 -> ((EntityManager)em).remove(arg_0));
                    }
                    catch (NoResultException noResultException) {}
                }
                transactionCompletedSuccessfully = true;
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception during cleanup --> ignoring it", (Throwable)e);
            }
            finally {
                if (transactionCompletedSuccessfully) {
                    transactionManager.commit();
                } else {
                    transactionManager.rollback();
                }
            }
        }
    }
}

