/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.groups;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.utils.KeycloakSessionUtil;

public class ExpungeGroupDeletionsAndKicksJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public ExpungeGroupDeletionsAndKicksJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block28: {
            this.logger.info((Object)"Starting Group deletions and Member kicks expunge task");
            long currentTimestamp = System.currentTimeMillis();
            try (KeycloakSession session = this.factory.create();){
                boolean transactionCompletedSuccessfully;
                EntityManager em;
                KeycloakTransactionManager transactionManager;
                block31: {
                    block27: {
                        KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                        transactionManager = session.getTransactionManager();
                        ObjectMapper jsonObjectMapper = new ObjectMapper();
                        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionCompletedSuccessfully = false;
                        transactionManager.begin();
                        long timestamp = System.currentTimeMillis() - 5184000000L;
                        Query q = em.createNamedQuery("OlvidGroupDeletion.expunge");
                        q.setParameter("timestamp", (Object)timestamp);
                        int count = q.executeUpdate();
                        if (count != 0) {
                            this.logger.infof("Expunged %d OlvidGroupDeletion", (Object)count);
                        }
                        q = em.createNamedQuery("OlvidGroupMemberKicked.expunge");
                        q.setParameter("timestamp", (Object)timestamp);
                        count = q.executeUpdate();
                        if (count != 0) {
                            this.logger.infof("Expunged %d OlvidGroupMemberKicked", (Object)count);
                        }
                        if (!(transactionCompletedSuccessfully = true)) break block27;
                        transactionManager.commit();
                        break block31;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending Group deletions and Member kicks expunge task");
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().expungeGroupDeletionsAndKicksJob);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    break block28;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block28;
                catch (Exception e) {
                    block32: {
                        block29: {
                            try {
                                this.logger.warn((Object)"Exception in Group deletions and Member kicks expunge task", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block29;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)"Ending Group deletions and Member kicks expunge task");
                                try {
                                    transactionManager.begin();
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().expungeGroupDeletionsAndKicksJob);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block32;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)"Ending Group deletions and Member kicks expunge task");
                    try {
                        transactionManager.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().expungeGroupDeletionsAndKicksJob);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block28;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
        }
    }
}

