/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.groups;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.utils.KeycloakSessionUtil;

public class DetectGroupModificationsJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;
    public static final long MAX_TRANSACTION_DURATION = 10000L;

    public DetectGroupModificationsJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block59: {
            this.logger.info((Object)"Starting Group modification detection task");
            long currentTimestamp = System.currentTimeMillis();
            HashMap olvidRealmIdsAndGroupIds = new HashMap();
            try (KeycloakSession session = this.factory.create();){
                KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                KeycloakTransactionManager transactionManager = session.getTransactionManager();
                EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                try {
                    transactionManager.begin();
                    session.realms().getRealmsStream().forEach(realmModel -> {
                        session.getContext().setRealm(realmModel);
                        if (OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "olvid", false)) {
                            HashSet keycloakGroupIds = olvidRealmIdsAndGroupIds.computeIfAbsent(realmModel.getId(), k -> new HashSet());
                            session.groups().getGroupsStream(realmModel).forEach(groupModel -> keycloakGroupIds.add(groupModel.getId()));
                        }
                    });
                }
                finally {
                    transactionManager.rollback();
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception in Group modification detection task (part 1)", (Throwable)e);
                return;
            }
            HashSet<UserOrTopicToNotify> usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
            ObjectMapper jsonObjectMapper = new ObjectMapper();
            jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            SecureRandom random = new SecureRandom();
            boolean jobCompleted = false;
            for (Map.Entry entry : olvidRealmIdsAndGroupIds.entrySet()) {
                String realmId = (String)entry.getKey();
                HashSet allKeycloakGroupIds = (HashSet)entry.getValue();
                HashSet<String> unprocessedGroupIds = new HashSet<String>(allKeycloakGroupIds);
                while (!unprocessedGroupIds.isEmpty()) {
                    this.subProcess(realmId, unprocessedGroupIds, usersAndTopicsToNotify, jsonObjectMapper, random);
                    if (unprocessedGroupIds.isEmpty()) continue;
                    this.logger.info((Object)("    Group modification for realm " + realmId + " remaining groups to process: " + unprocessedGroupIds.size() + "/" + allKeycloakGroupIds.size()));
                }
                try {
                    KeycloakSession session = this.factory.create();
                    try {
                        KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                        KeycloakTransactionManager transactionManager = session.getTransactionManager();
                        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        try {
                            transactionManager.begin();
                            RealmModel realmModel2 = session.realms().getRealm(realmId);
                            session.getContext().setRealm(realmModel2);
                            TypedQuery q = em.createNamedQuery("OlvidGroup.getAllEnabledByRealm", OlvidGroup.class);
                            q.setParameter("realmId", (Object)realmId);
                            List allOlvidGroups = q.getResultList();
                            for (OlvidGroup olvidGroup : allOlvidGroups) {
                                if (allKeycloakGroupIds.contains(olvidGroup.getKeycloakGroupId())) continue;
                                usersAndTopicsToNotify.addAll(OlvidGroupDao.disableGroupAndGetMembersToNotify(session, jsonObjectMapper, em, realmModel2, olvidGroup));
                            }
                            OlvidServerApiHelper.sendNotifications(session, em, jsonObjectMapper, usersAndTopicsToNotify);
                        }
                        finally {
                            transactionManager.commit();
                        }
                    }
                    finally {
                        if (session == null) continue;
                        session.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            jobCompleted = true;
            this.logger.info((Object)("Ending Group modification detection task: " + (jobCompleted ? "success" : "failed")));
            try (KeycloakSession session = this.factory.create();){
                KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                KeycloakTransactionManager transactionManager = session.getTransactionManager();
                EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().detectGroupModificationsJob);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(jobCompleted ? System.currentTimeMillis() : 0L);
                    item.setMessage(jobCompleted ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
            }
            catch (Exception e) {
                try {
                    this.logger.warn((Object)"Exception in Group modification detection task (part 2)", (Throwable)e);
                    this.logger.info((Object)("Ending Group modification detection task: " + (jobCompleted ? "success" : "failed")));
                }
                catch (Throwable throwable) {
                    block60: {
                        this.logger.info((Object)("Ending Group modification detection task: " + (jobCompleted ? "success" : "failed")));
                        try (KeycloakSession session = this.factory.create();){
                            KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                            KeycloakTransactionManager transactionManager = session.getTransactionManager();
                            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                            try {
                                transactionManager.begin();
                                OlvidLogsBackend item = new OlvidLogsBackend();
                                item.setLogType(new CronJobModel().detectGroupModificationsJob);
                                item.setTimestampStart(currentTimestamp);
                                item.setTimestampEnd(jobCompleted ? System.currentTimeMillis() : 0L);
                                item.setMessage(jobCompleted ? "success" : "failed");
                                em.persist((Object)item);
                            }
                            catch (Exception exception) {
                                transactionManager.commit();
                                break block60;
                                catch (Throwable throwable2) {
                                    transactionManager.commit();
                                    throw throwable2;
                                }
                            }
                            transactionManager.commit();
                        }
                    }
                    throw throwable;
                }
                session = this.factory.create();
                try {
                    KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                    KeycloakTransactionManager transactionManager = session.getTransactionManager();
                    EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                    try {
                        transactionManager.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().detectGroupModificationsJob);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(jobCompleted ? System.currentTimeMillis() : 0L);
                        item.setMessage(jobCompleted ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block59;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subProcess(String realmId, HashSet<String> unprocessedGroupIds, HashSet<UserOrTopicToNotify> usersAndTopicsToNotify, ObjectMapper jsonObjectMapper, SecureRandom random) {
        try (KeycloakSession session = this.factory.create();){
            KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
            KeycloakTransactionManager transactionManager = session.getTransactionManager();
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            long startTime = System.currentTimeMillis();
            try {
                transactionManager.begin();
                RealmModel realmModel = session.realms().getRealm(realmId);
                session.getContext().setRealm(realmModel);
                for (String groupId : unprocessedGroupIds.toArray(new String[0])) {
                    try {
                        GroupModel groupModel = session.groups().getGroupById(realmModel, groupId);
                        if (groupModel != null) {
                            if (Utils.isOlvidGroup(groupModel)) {
                                usersAndTopicsToNotify.addAll(OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(session, em, realmModel, groupModel, jsonObjectMapper, random));
                            } else {
                                OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(em, realmId, groupModel.getId());
                                if (olvidGroup != null && olvidGroup.isEnabled()) {
                                    usersAndTopicsToNotify.addAll(OlvidGroupDao.disableGroupAndGetMembersToNotify(session, jsonObjectMapper, em, realmModel, olvidGroup));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        unprocessedGroupIds.remove(groupId);
                    }
                    if (System.currentTimeMillis() <= startTime + 10000L) continue;
                    break;
                }
            }
            finally {
                transactionManager.commit();
            }
        }
    }
}

